/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.loan;

import java.time.LocalDate;
import lombok.Generated;
import org.apache.fineract.cob.loan.LoanCOBBusinessStep;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.service.LoanAccrualActivityProcessingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AccrualActivityPostingBusinessStep
implements LoanCOBBusinessStep {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AccrualActivityPostingBusinessStep.class);
    private final LoanAccrualActivityProcessingService loanAccrualActivityProcessingService;

    public Loan execute(Loan loan) {
        log.debug("start processing loan accrual activity posting on installment due date with id [{}]", (Object)loan.getId());
        LocalDate currentDate = DateUtils.getBusinessLocalDate();
        this.loanAccrualActivityProcessingService.makeAccrualActivityTransaction(loan, currentDate);
        log.debug("end processing loan accrual activity posting on installment due date with id [{}]", (Object)loan.getId());
        return loan;
    }

    public String getEnumStyledName() {
        return "ACCRUAL_ACTIVITY_POSTING";
    }

    public String getHumanReadableName() {
        return "Accrual Activity Posting on Installment Due Date";
    }

    @Generated
    public AccrualActivityPostingBusinessStep(LoanAccrualActivityProcessingService loanAccrualActivityProcessingService) {
        this.loanAccrualActivityProcessingService = loanAccrualActivityProcessingService;
    }
}

