/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util.credentials;

import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.util.credentials.Authentication;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.Instant;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class TokenFileAuthentication
implements Authentication,
Interceptor {
    private String file;
    private String token;
    private Instant expiry = Instant.MIN;

    public TokenFileAuthentication(String file) {
        this.file = file;
    }

    private String getToken() {
        if (Instant.now().isAfter(this.expiry)) {
            try {
                this.token = new String(Files.readAllBytes(Paths.get(this.file, new String[0])), Charset.defaultCharset()).trim();
                this.expiry = Instant.now().plusSeconds(60L);
            }
            catch (IOException ie) {
                throw new RuntimeException("Cannot read file: " + this.file);
            }
        }
        return this.token;
    }

    public void setExpiry(Instant expiry) {
        this.expiry = expiry;
    }

    public void setFile(String file) {
        this.file = file;
    }

    @Override
    public void provide(ApiClient client) {
        OkHttpClient withInterceptor = client.getHttpClient().newBuilder().addInterceptor((Interceptor)this).build();
        client.setHttpClient(withInterceptor);
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Request newRequest = request.newBuilder().header("Authorization", "Bearer " + this.getToken()).build();
        return chain.proceed(newRequest);
    }
}

