/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.quantiles;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.IdentityHashMap;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantiles.DoublesUnion;

public class DoublesSketchMergeBufferAggregatorHelper {
    private static final MemoryRequestServer MEM_REQ_SERVER = new DefaultMemoryRequestServer();
    private final int k;
    private final int maxIntermediateSize;
    private final IdentityHashMap<ByteBuffer, WritableMemory> memCache = new IdentityHashMap();
    private final IdentityHashMap<ByteBuffer, Int2ObjectMap<DoublesUnion>> unions = new IdentityHashMap();

    public DoublesSketchMergeBufferAggregatorHelper(int k, int maxIntermediateSize) {
        this.k = k;
        this.maxIntermediateSize = maxIntermediateSize;
    }

    public void init(ByteBuffer buffer, int position) {
        WritableMemory mem = this.getMemory(buffer);
        WritableMemory region = mem.writableRegion((long)position, (long)this.maxIntermediateSize);
        DoublesUnion union = DoublesUnion.builder().setMaxK(this.k).build(region);
        this.putUnion(buffer, position, union);
    }

    public Object get(ByteBuffer buffer, int position) {
        return ((DoublesUnion)this.unions.get(buffer).get(position)).getResult();
    }

    public void clear() {
        this.unions.clear();
        this.memCache.clear();
    }

    public void relocate(int oldPosition, int newPosition, ByteBuffer oldBuffer, ByteBuffer newBuffer) {
        WritableMemory oldMem;
        DoublesUnion union = (DoublesUnion)this.unions.get(oldBuffer).get(oldPosition);
        if (union.isSameResource((Memory)(oldMem = this.getMemory(oldBuffer).writableRegion((long)oldPosition, (long)this.maxIntermediateSize)))) {
            WritableMemory newMem = this.getMemory(newBuffer).writableRegion((long)newPosition, (long)this.maxIntermediateSize);
            union = DoublesUnion.wrap((WritableMemory)newMem);
        }
        this.putUnion(newBuffer, newPosition, union);
        Int2ObjectMap<DoublesUnion> map = this.unions.get(oldBuffer);
        map.remove(oldPosition);
        if (map.isEmpty()) {
            this.unions.remove(oldBuffer);
            this.memCache.remove(oldBuffer);
        }
    }

    public DoublesUnion getSketchAtPosition(ByteBuffer buf, int position) {
        return (DoublesUnion)this.unions.get(buf).get(position);
    }

    private WritableMemory getMemory(ByteBuffer buffer) {
        return this.memCache.computeIfAbsent(buffer, buf -> WritableMemory.writableWrap((ByteBuffer)buf, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryRequestServer)MEM_REQ_SERVER));
    }

    private void putUnion(ByteBuffer buffer, int position, DoublesUnion union) {
        Int2ObjectMap map = this.unions.computeIfAbsent(buffer, buf -> new Int2ObjectOpenHashMap());
        map.put(position, (Object)union);
    }
}

