/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.cluster.loadbalancer;

import org.apache.dolphinscheduler.server.master.cluster.ClusterManager;
import org.apache.dolphinscheduler.server.master.cluster.loadbalancer.DynamicWeightedRoundRobinWorkerLoadBalancer;
import org.apache.dolphinscheduler.server.master.cluster.loadbalancer.FixedWeightedRoundRobinWorkerLoadBalancer;
import org.apache.dolphinscheduler.server.master.cluster.loadbalancer.IWorkerLoadBalancer;
import org.apache.dolphinscheduler.server.master.cluster.loadbalancer.RandomWorkerLoadBalancer;
import org.apache.dolphinscheduler.server.master.cluster.loadbalancer.RoundRobinWorkerLoadBalancer;
import org.apache.dolphinscheduler.server.master.cluster.loadbalancer.WorkerLoadBalancerConfigurationProperties;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class WorkerLoadBalancerConfiguration {
    @Bean
    public IWorkerLoadBalancer randomWorkerLoadBalancer(MasterConfig masterConfig, ClusterManager clusterManager) {
        WorkerLoadBalancerConfigurationProperties workerLoadBalancerConfigurationProperties = masterConfig.getWorkerLoadBalancerConfigurationProperties();
        switch (workerLoadBalancerConfigurationProperties.getType()) {
            case RANDOM: {
                return new RandomWorkerLoadBalancer(clusterManager.getWorkerClusters());
            }
            case ROUND_ROBIN: {
                return new RoundRobinWorkerLoadBalancer(clusterManager.getWorkerClusters());
            }
            case FIXED_WEIGHTED_ROUND_ROBIN: {
                return new FixedWeightedRoundRobinWorkerLoadBalancer(clusterManager.getWorkerClusters());
            }
            case DYNAMIC_WEIGHTED_ROUND_ROBIN: {
                return new DynamicWeightedRoundRobinWorkerLoadBalancer(clusterManager.getWorkerClusters(), workerLoadBalancerConfigurationProperties.getDynamicWeightConfigProperties());
            }
        }
        throw new IllegalArgumentException("unSupport worker load balancer type " + (Object)((Object)workerLoadBalancerConfigurationProperties.getType()));
    }
}

