/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1LabelSelectorBuilder;
import io.kubernetes.client.openapi.models.V1LabelSelectorFluentImpl;
import io.kubernetes.client.openapi.models.V2beta1ExternalMetricStatus;
import io.kubernetes.client.openapi.models.V2beta1ExternalMetricStatusFluent;
import java.util.Objects;

public class V2beta1ExternalMetricStatusFluentImpl<A extends V2beta1ExternalMetricStatusFluent<A>>
extends BaseFluent<A>
implements V2beta1ExternalMetricStatusFluent<A> {
    private Quantity currentAverageValue;
    private Quantity currentValue;
    private String metricName;
    private V1LabelSelectorBuilder metricSelector;

    public V2beta1ExternalMetricStatusFluentImpl() {
    }

    public V2beta1ExternalMetricStatusFluentImpl(V2beta1ExternalMetricStatus instance) {
        this.withCurrentAverageValue(instance.getCurrentAverageValue());
        this.withCurrentValue(instance.getCurrentValue());
        this.withMetricName(instance.getMetricName());
        this.withMetricSelector(instance.getMetricSelector());
    }

    @Override
    public Quantity getCurrentAverageValue() {
        return this.currentAverageValue;
    }

    @Override
    public A withCurrentAverageValue(Quantity currentAverageValue) {
        this.currentAverageValue = currentAverageValue;
        return (A)this;
    }

    @Override
    public Boolean hasCurrentAverageValue() {
        return this.currentAverageValue != null;
    }

    @Override
    public A withNewCurrentAverageValue(String value) {
        return this.withCurrentAverageValue(new Quantity(value));
    }

    @Override
    public Quantity getCurrentValue() {
        return this.currentValue;
    }

    @Override
    public A withCurrentValue(Quantity currentValue) {
        this.currentValue = currentValue;
        return (A)this;
    }

    @Override
    public Boolean hasCurrentValue() {
        return this.currentValue != null;
    }

    @Override
    public A withNewCurrentValue(String value) {
        return this.withCurrentValue(new Quantity(value));
    }

    @Override
    public String getMetricName() {
        return this.metricName;
    }

    @Override
    public A withMetricName(String metricName) {
        this.metricName = metricName;
        return (A)this;
    }

    @Override
    public Boolean hasMetricName() {
        return this.metricName != null;
    }

    @Override
    @Deprecated
    public A withNewMetricName(String original) {
        return this.withMetricName(new String(original));
    }

    @Override
    @Deprecated
    public V1LabelSelector getMetricSelector() {
        return this.metricSelector != null ? this.metricSelector.build() : null;
    }

    @Override
    public V1LabelSelector buildMetricSelector() {
        return this.metricSelector != null ? this.metricSelector.build() : null;
    }

    @Override
    public A withMetricSelector(V1LabelSelector metricSelector) {
        this._visitables.get("metricSelector").remove(this.metricSelector);
        if (metricSelector != null) {
            this.metricSelector = new V1LabelSelectorBuilder(metricSelector);
            this._visitables.get("metricSelector").add(this.metricSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetricSelector() {
        return this.metricSelector != null;
    }

    @Override
    public V2beta1ExternalMetricStatusFluent.MetricSelectorNested<A> withNewMetricSelector() {
        return new MetricSelectorNestedImpl();
    }

    @Override
    public V2beta1ExternalMetricStatusFluent.MetricSelectorNested<A> withNewMetricSelectorLike(V1LabelSelector item) {
        return new MetricSelectorNestedImpl(item);
    }

    @Override
    public V2beta1ExternalMetricStatusFluent.MetricSelectorNested<A> editMetricSelector() {
        return this.withNewMetricSelectorLike(this.getMetricSelector());
    }

    @Override
    public V2beta1ExternalMetricStatusFluent.MetricSelectorNested<A> editOrNewMetricSelector() {
        return this.withNewMetricSelectorLike(this.getMetricSelector() != null ? this.getMetricSelector() : new V1LabelSelectorBuilder().build());
    }

    @Override
    public V2beta1ExternalMetricStatusFluent.MetricSelectorNested<A> editOrNewMetricSelectorLike(V1LabelSelector item) {
        return this.withNewMetricSelectorLike(this.getMetricSelector() != null ? this.getMetricSelector() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2beta1ExternalMetricStatusFluentImpl that = (V2beta1ExternalMetricStatusFluentImpl)o;
        if (this.currentAverageValue != null ? !this.currentAverageValue.equals((Object)that.currentAverageValue) : that.currentAverageValue != null) {
            return false;
        }
        if (this.currentValue != null ? !this.currentValue.equals((Object)that.currentValue) : that.currentValue != null) {
            return false;
        }
        if (this.metricName != null ? !this.metricName.equals(that.metricName) : that.metricName != null) {
            return false;
        }
        return !(this.metricSelector != null ? !this.metricSelector.equals(that.metricSelector) : that.metricSelector != null);
    }

    public int hashCode() {
        return Objects.hash(this.currentAverageValue, this.currentValue, this.metricName, this.metricSelector, super.hashCode());
    }

    public class MetricSelectorNestedImpl<N>
    extends V1LabelSelectorFluentImpl<V2beta1ExternalMetricStatusFluent.MetricSelectorNested<N>>
    implements V2beta1ExternalMetricStatusFluent.MetricSelectorNested<N>,
    Nested<N> {
        private final V1LabelSelectorBuilder builder;

        MetricSelectorNestedImpl(V1LabelSelector item) {
            this.builder = new V1LabelSelectorBuilder(this, item);
        }

        MetricSelectorNestedImpl() {
            this.builder = new V1LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)V2beta1ExternalMetricStatusFluentImpl.this.withMetricSelector(this.builder.build());
        }

        @Override
        public N endMetricSelector() {
            return this.and();
        }
    }
}

