/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.implementation;

import com.azure.core.management.Resource;
import com.azure.resourcemanager.monitor.MonitorManager;
import com.azure.resourcemanager.monitor.fluent.MonitorClient;
import com.azure.resourcemanager.monitor.fluent.models.ActionGroupResourceInner;
import com.azure.resourcemanager.monitor.models.ActionGroup;
import com.azure.resourcemanager.monitor.models.AutomationRunbookReceiver;
import com.azure.resourcemanager.monitor.models.AzureAppPushReceiver;
import com.azure.resourcemanager.monitor.models.AzureFunctionReceiver;
import com.azure.resourcemanager.monitor.models.EmailReceiver;
import com.azure.resourcemanager.monitor.models.ItsmReceiver;
import com.azure.resourcemanager.monitor.models.LogicAppReceiver;
import com.azure.resourcemanager.monitor.models.SmsReceiver;
import com.azure.resourcemanager.monitor.models.VoiceReceiver;
import com.azure.resourcemanager.monitor.models.WebhookReceiver;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import reactor.core.publisher.Mono;

class ActionGroupImpl
extends GroupableResourceImpl<ActionGroup, ActionGroupResourceInner, ActionGroupImpl, MonitorManager>
implements ActionGroup,
ActionGroup.Definition<ActionGroupImpl>,
ActionGroup.Update,
ActionGroup.UpdateStages.WithActionUpdateDefinition {
    private static final String EMAIL_SUFFIX = "_-EmailAction-";
    private static final String SMS_SUFFIX = "_-SMSAction-";
    private static final String APP_ACTION_SUFFIX = "_-AzureAppAction-";
    private static final String VOICE_SUFFIX = "_-VoiceAction-";
    private static final String RUN_BOOK_SUFFIX = " (RB)";
    private static final String LOGIC_SUFFIX = " (LA)";
    private static final String FUNCTION_SUFFIX = " (F)";
    private static final String WEBHOOK_SUFFIX = " (WH)";
    private static final String ITSM_SUFFIX = " (ITSM)";
    private String actionReceiverPrefix = "";
    private TreeMap<String, EmailReceiver> emailReceivers = new TreeMap();
    private TreeMap<String, SmsReceiver> smsReceivers = new TreeMap();
    private TreeMap<String, AzureAppPushReceiver> appActionReceivers = new TreeMap();
    private TreeMap<String, VoiceReceiver> voiceReceivers = new TreeMap();
    private TreeMap<String, AutomationRunbookReceiver> runBookReceivers = new TreeMap();
    private TreeMap<String, LogicAppReceiver> logicReceivers = new TreeMap();
    private TreeMap<String, AzureFunctionReceiver> functionReceivers = new TreeMap();
    private TreeMap<String, WebhookReceiver> webhookReceivers = new TreeMap();
    private TreeMap<String, ItsmReceiver> itsmReceivers = new TreeMap();

    ActionGroupImpl(String name, ActionGroupResourceInner innerModel, MonitorManager monitorManager) {
        super(name, (Resource)innerModel, (Manager)monitorManager);
        if (this.isInCreateMode()) {
            ((ActionGroupResourceInner)((Object)this.innerModel())).withEnabled(true);
            ((ActionGroupResourceInner)((Object)this.innerModel())).withGroupShortName(this.name().substring(0, this.name().length() > 12 ? 12 : this.name().length()));
        } else {
            this.withExistingResourceGroup(ResourceUtils.groupFromResourceId((String)this.id()));
        }
    }

    @Override
    public String shortName() {
        return ((ActionGroupResourceInner)((Object)this.innerModel())).groupShortName();
    }

    @Override
    public List<EmailReceiver> emailReceivers() {
        return ((ActionGroupResourceInner)((Object)this.innerModel())).emailReceivers();
    }

    @Override
    public List<SmsReceiver> smsReceivers() {
        return ((ActionGroupResourceInner)((Object)this.innerModel())).smsReceivers();
    }

    @Override
    public List<WebhookReceiver> webhookReceivers() {
        return ((ActionGroupResourceInner)((Object)this.innerModel())).webhookReceivers();
    }

    @Override
    public List<ItsmReceiver> itsmReceivers() {
        return ((ActionGroupResourceInner)((Object)this.innerModel())).itsmReceivers();
    }

    @Override
    public List<AzureAppPushReceiver> pushNotificationReceivers() {
        return ((ActionGroupResourceInner)((Object)this.innerModel())).azureAppPushReceivers();
    }

    @Override
    public List<AutomationRunbookReceiver> automationRunbookReceivers() {
        return ((ActionGroupResourceInner)((Object)this.innerModel())).automationRunbookReceivers();
    }

    @Override
    public List<VoiceReceiver> voiceReceivers() {
        return ((ActionGroupResourceInner)((Object)this.innerModel())).voiceReceivers();
    }

    @Override
    public List<LogicAppReceiver> logicAppReceivers() {
        return ((ActionGroupResourceInner)((Object)this.innerModel())).logicAppReceivers();
    }

    @Override
    public List<AzureFunctionReceiver> azureFunctionReceivers() {
        return ((ActionGroupResourceInner)((Object)this.innerModel())).azureFunctionReceivers();
    }

    @Override
    public ActionGroupImpl withoutReceiver(String actionNamePrefix) {
        this.updateReceiver(actionNamePrefix);
        this.withoutEmail();
        this.withoutSms();
        this.withoutPushNotification();
        this.withoutVoice();
        this.withoutAutomationRunbook();
        this.withoutLogicApp();
        this.withoutAzureFunction();
        this.withoutWebhook();
        this.withoutItsm();
        return this.parent();
    }

    public ActionGroupImpl defineReceiver(String actionNamePrefix) {
        return this.updateReceiver(actionNamePrefix);
    }

    @Override
    public ActionGroupImpl updateReceiver(String actionNamePrefix) {
        this.actionReceiverPrefix = actionNamePrefix;
        this.emailReceivers.clear();
        this.smsReceivers.clear();
        this.appActionReceivers.clear();
        this.voiceReceivers.clear();
        this.runBookReceivers.clear();
        this.logicReceivers.clear();
        this.functionReceivers.clear();
        this.webhookReceivers.clear();
        this.itsmReceivers.clear();
        if (((ActionGroupResourceInner)((Object)this.innerModel())).emailReceivers() != null) {
            for (EmailReceiver emailReceiver : ((ActionGroupResourceInner)((Object)this.innerModel())).emailReceivers()) {
                this.emailReceivers.put(emailReceiver.name(), emailReceiver);
            }
        }
        if (((ActionGroupResourceInner)((Object)this.innerModel())).smsReceivers() != null) {
            for (SmsReceiver smsReceiver : ((ActionGroupResourceInner)((Object)this.innerModel())).smsReceivers()) {
                this.smsReceivers.put(smsReceiver.name(), smsReceiver);
            }
        }
        if (((ActionGroupResourceInner)((Object)this.innerModel())).azureAppPushReceivers() != null) {
            for (AzureAppPushReceiver azureAppPushReceiver : ((ActionGroupResourceInner)((Object)this.innerModel())).azureAppPushReceivers()) {
                this.appActionReceivers.put(azureAppPushReceiver.name(), azureAppPushReceiver);
            }
        }
        if (((ActionGroupResourceInner)((Object)this.innerModel())).voiceReceivers() != null) {
            for (VoiceReceiver voiceReceiver : ((ActionGroupResourceInner)((Object)this.innerModel())).voiceReceivers()) {
                this.voiceReceivers.put(voiceReceiver.name(), voiceReceiver);
            }
        }
        if (((ActionGroupResourceInner)((Object)this.innerModel())).automationRunbookReceivers() != null) {
            for (AutomationRunbookReceiver automationRunbookReceiver : ((ActionGroupResourceInner)((Object)this.innerModel())).automationRunbookReceivers()) {
                this.runBookReceivers.put(automationRunbookReceiver.name(), automationRunbookReceiver);
            }
        }
        if (((ActionGroupResourceInner)((Object)this.innerModel())).logicAppReceivers() != null) {
            for (LogicAppReceiver logicAppReceiver : ((ActionGroupResourceInner)((Object)this.innerModel())).logicAppReceivers()) {
                this.logicReceivers.put(logicAppReceiver.name(), logicAppReceiver);
            }
        }
        if (((ActionGroupResourceInner)((Object)this.innerModel())).azureFunctionReceivers() != null) {
            for (AzureFunctionReceiver azureFunctionReceiver : ((ActionGroupResourceInner)((Object)this.innerModel())).azureFunctionReceivers()) {
                this.functionReceivers.put(azureFunctionReceiver.name(), azureFunctionReceiver);
            }
        }
        if (((ActionGroupResourceInner)((Object)this.innerModel())).webhookReceivers() != null) {
            for (WebhookReceiver webhookReceiver : ((ActionGroupResourceInner)((Object)this.innerModel())).webhookReceivers()) {
                this.webhookReceivers.put(webhookReceiver.name(), webhookReceiver);
            }
        }
        if (((ActionGroupResourceInner)((Object)this.innerModel())).itsmReceivers() != null) {
            for (ItsmReceiver itsmReceiver : ((ActionGroupResourceInner)((Object)this.innerModel())).itsmReceivers()) {
                this.itsmReceivers.put(itsmReceiver.name(), itsmReceiver);
            }
        }
        return this;
    }

    @Override
    public ActionGroupImpl withShortName(String shortName) {
        ((ActionGroupResourceInner)((Object)this.innerModel())).withGroupShortName(shortName);
        return this;
    }

    public Mono<ActionGroup> createResourceAsync() {
        ((ActionGroupResourceInner)((Object)this.innerModel())).withLocation("global");
        return ((MonitorClient)((MonitorManager)this.manager()).serviceClient()).getActionGroups().createOrUpdateAsync(this.resourceGroupName(), this.name(), (ActionGroupResourceInner)((Object)this.innerModel())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Mono<ActionGroupResourceInner> getInnerAsync() {
        return ((MonitorClient)((MonitorManager)this.manager()).serviceClient()).getActionGroups().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public ActionGroupImpl withEmail(String emailAddress) {
        this.withoutEmail();
        String compositeKey = this.actionReceiverPrefix + EMAIL_SUFFIX;
        EmailReceiver er = new EmailReceiver();
        er.withName(compositeKey);
        er.withEmailAddress(emailAddress);
        this.emailReceivers.put(compositeKey, er);
        return this;
    }

    @Override
    public ActionGroupImpl withSms(String countryCode, String phoneNumber) {
        this.withoutSms();
        String compositeKey = this.actionReceiverPrefix + SMS_SUFFIX;
        SmsReceiver sr = new SmsReceiver();
        sr.withName(compositeKey);
        sr.withCountryCode(countryCode);
        sr.withPhoneNumber(phoneNumber);
        this.smsReceivers.put(compositeKey, sr);
        return this;
    }

    @Override
    public ActionGroupImpl withWebhook(String serviceUri) {
        this.withoutWebhook();
        String compositeKey = this.actionReceiverPrefix + WEBHOOK_SUFFIX;
        WebhookReceiver wr = new WebhookReceiver();
        wr.withName(compositeKey);
        wr.withServiceUri(serviceUri);
        this.webhookReceivers.put(compositeKey, wr);
        return this;
    }

    @Override
    public ActionGroupImpl withItsm(String workspaceId, String connectionId, String ticketConfiguration, String region) {
        this.withoutItsm();
        String compositeKey = this.actionReceiverPrefix + ITSM_SUFFIX;
        ItsmReceiver ir = new ItsmReceiver();
        ir.withName(compositeKey);
        ir.withWorkspaceId(workspaceId);
        ir.withConnectionId(connectionId);
        ir.withRegion(region);
        ir.withTicketConfiguration(ticketConfiguration);
        this.itsmReceivers.put(compositeKey, ir);
        return this;
    }

    @Override
    public ActionGroupImpl withPushNotification(String emailAddress) {
        this.withoutPushNotification();
        String compositeKey = this.actionReceiverPrefix + APP_ACTION_SUFFIX;
        AzureAppPushReceiver ar = new AzureAppPushReceiver();
        ar.withName(compositeKey);
        ar.withEmailAddress(emailAddress);
        this.appActionReceivers.put(compositeKey, ar);
        return this;
    }

    @Override
    public ActionGroupImpl withAutomationRunbook(String automationAccountId, String runbookName, String webhookResourceId, boolean isGlobalRunbook) {
        this.withoutAutomationRunbook();
        String compositeKey = this.actionReceiverPrefix + RUN_BOOK_SUFFIX;
        AutomationRunbookReceiver arr = new AutomationRunbookReceiver();
        arr.withName(compositeKey);
        arr.withAutomationAccountId(automationAccountId);
        arr.withRunbookName(runbookName);
        arr.withWebhookResourceId(webhookResourceId);
        arr.withIsGlobalRunbook(isGlobalRunbook);
        this.runBookReceivers.put(compositeKey, arr);
        return this;
    }

    @Override
    public ActionGroupImpl withVoice(String countryCode, String phoneNumber) {
        this.withoutVoice();
        String compositeKey = this.actionReceiverPrefix + VOICE_SUFFIX;
        VoiceReceiver vr = new VoiceReceiver();
        vr.withName(compositeKey);
        vr.withCountryCode(countryCode);
        vr.withPhoneNumber(phoneNumber);
        this.voiceReceivers.put(compositeKey, vr);
        return this;
    }

    @Override
    public ActionGroupImpl withLogicApp(String logicAppResourceId, String callbackUrl) {
        this.withoutLogicApp();
        String compositeKey = this.actionReceiverPrefix + LOGIC_SUFFIX;
        LogicAppReceiver lr = new LogicAppReceiver();
        lr.withName(compositeKey);
        lr.withResourceId(logicAppResourceId);
        lr.withCallbackUrl(callbackUrl);
        this.logicReceivers.put(compositeKey, lr);
        return this;
    }

    @Override
    public ActionGroupImpl withAzureFunction(String functionAppResourceId, String functionName, String httpTriggerUrl) {
        this.withoutAzureFunction();
        String compositeKey = this.actionReceiverPrefix + FUNCTION_SUFFIX;
        AzureFunctionReceiver afr = new AzureFunctionReceiver();
        afr.withName(compositeKey);
        afr.withFunctionAppResourceId(functionAppResourceId);
        afr.withFunctionName(functionName);
        afr.withHttpTriggerUrl(httpTriggerUrl);
        this.functionReceivers.put(compositeKey, afr);
        return this;
    }

    @Override
    public ActionGroupImpl attach() {
        this.actionReceiverPrefix = "";
        this.populateReceivers();
        this.emailReceivers.clear();
        this.smsReceivers.clear();
        this.appActionReceivers.clear();
        this.voiceReceivers.clear();
        this.runBookReceivers.clear();
        this.logicReceivers.clear();
        this.functionReceivers.clear();
        this.webhookReceivers.clear();
        this.itsmReceivers.clear();
        return this;
    }

    @Override
    public ActionGroupImpl withoutEmail() {
        String compositeKey = this.actionReceiverPrefix + EMAIL_SUFFIX;
        if (this.emailReceivers.containsKey(compositeKey)) {
            this.emailReceivers.remove(compositeKey);
        }
        if (this.emailReceivers.containsKey(this.actionReceiverPrefix)) {
            this.emailReceivers.remove(this.actionReceiverPrefix);
        }
        return this;
    }

    @Override
    public ActionGroupImpl withoutSms() {
        String compositeKey = this.actionReceiverPrefix + SMS_SUFFIX;
        if (this.smsReceivers.containsKey(compositeKey)) {
            this.smsReceivers.remove(compositeKey);
        }
        if (this.smsReceivers.containsKey(this.actionReceiverPrefix)) {
            this.smsReceivers.remove(this.actionReceiverPrefix);
        }
        return this;
    }

    @Override
    public ActionGroupImpl withoutWebhook() {
        String compositeKey = this.actionReceiverPrefix + WEBHOOK_SUFFIX;
        if (this.webhookReceivers.containsKey(compositeKey)) {
            this.webhookReceivers.remove(compositeKey);
        }
        if (this.webhookReceivers.containsKey(this.actionReceiverPrefix)) {
            this.webhookReceivers.remove(this.actionReceiverPrefix);
        }
        return this;
    }

    @Override
    public ActionGroupImpl withoutItsm() {
        String compositeKey = this.actionReceiverPrefix + ITSM_SUFFIX;
        if (this.itsmReceivers.containsKey(compositeKey)) {
            this.itsmReceivers.remove(compositeKey);
        }
        if (this.itsmReceivers.containsKey(this.actionReceiverPrefix)) {
            this.itsmReceivers.remove(this.actionReceiverPrefix);
        }
        return this;
    }

    @Override
    public ActionGroupImpl withoutPushNotification() {
        String compositeKey = this.actionReceiverPrefix + APP_ACTION_SUFFIX;
        if (this.appActionReceivers.containsKey(compositeKey)) {
            this.appActionReceivers.remove(compositeKey);
        }
        if (this.appActionReceivers.containsKey(this.actionReceiverPrefix)) {
            this.appActionReceivers.remove(this.actionReceiverPrefix);
        }
        return this;
    }

    @Override
    public ActionGroupImpl withoutAutomationRunbook() {
        String compositeKey = this.actionReceiverPrefix + RUN_BOOK_SUFFIX;
        if (this.runBookReceivers.containsKey(compositeKey)) {
            this.runBookReceivers.remove(compositeKey);
        }
        if (this.runBookReceivers.containsKey(this.actionReceiverPrefix)) {
            this.runBookReceivers.remove(this.actionReceiverPrefix);
        }
        return this;
    }

    @Override
    public ActionGroupImpl withoutVoice() {
        String compositeKey = this.actionReceiverPrefix + VOICE_SUFFIX;
        if (this.voiceReceivers.containsKey(compositeKey)) {
            this.voiceReceivers.remove(compositeKey);
        }
        if (this.voiceReceivers.containsKey(this.actionReceiverPrefix)) {
            this.voiceReceivers.remove(this.actionReceiverPrefix);
        }
        return this;
    }

    @Override
    public ActionGroupImpl withoutLogicApp() {
        String compositeKey = this.actionReceiverPrefix + LOGIC_SUFFIX;
        if (this.logicReceivers.containsKey(compositeKey)) {
            this.logicReceivers.remove(compositeKey);
        }
        if (this.logicReceivers.containsKey(this.actionReceiverPrefix)) {
            this.logicReceivers.remove(this.actionReceiverPrefix);
        }
        return this;
    }

    @Override
    public ActionGroupImpl withoutAzureFunction() {
        String compositeKey = this.actionReceiverPrefix + LOGIC_SUFFIX;
        if (this.functionReceivers.containsKey(compositeKey)) {
            this.functionReceivers.remove(compositeKey);
        }
        if (this.functionReceivers.containsKey(this.actionReceiverPrefix)) {
            this.functionReceivers.remove(this.actionReceiverPrefix);
        }
        return this;
    }

    @Override
    public ActionGroupImpl parent() {
        return this.attach();
    }

    private void populateReceivers() {
        if (this.emailReceivers.values().size() > 0) {
            if (((ActionGroupResourceInner)((Object)this.innerModel())).emailReceivers() == null) {
                ((ActionGroupResourceInner)((Object)this.innerModel())).withEmailReceivers(new ArrayList<EmailReceiver>());
            } else {
                ((ActionGroupResourceInner)((Object)this.innerModel())).emailReceivers().clear();
            }
            ((ActionGroupResourceInner)((Object)this.innerModel())).emailReceivers().addAll(this.emailReceivers.values());
        } else {
            ((ActionGroupResourceInner)((Object)this.innerModel())).withEmailReceivers(null);
        }
        if (this.smsReceivers.values().size() > 0) {
            if (((ActionGroupResourceInner)((Object)this.innerModel())).smsReceivers() == null) {
                ((ActionGroupResourceInner)((Object)this.innerModel())).withSmsReceivers(new ArrayList<SmsReceiver>());
            } else {
                ((ActionGroupResourceInner)((Object)this.innerModel())).smsReceivers().clear();
            }
            ((ActionGroupResourceInner)((Object)this.innerModel())).smsReceivers().addAll(this.smsReceivers.values());
        } else {
            ((ActionGroupResourceInner)((Object)this.innerModel())).withSmsReceivers(null);
        }
        if (this.appActionReceivers.values().size() > 0) {
            if (((ActionGroupResourceInner)((Object)this.innerModel())).azureAppPushReceivers() == null) {
                ((ActionGroupResourceInner)((Object)this.innerModel())).withAzureAppPushReceivers(new ArrayList<AzureAppPushReceiver>());
            } else {
                ((ActionGroupResourceInner)((Object)this.innerModel())).azureAppPushReceivers().clear();
            }
            ((ActionGroupResourceInner)((Object)this.innerModel())).azureAppPushReceivers().addAll(this.appActionReceivers.values());
        } else {
            ((ActionGroupResourceInner)((Object)this.innerModel())).withAzureAppPushReceivers(null);
        }
        if (this.voiceReceivers.values().size() > 0) {
            if (((ActionGroupResourceInner)((Object)this.innerModel())).voiceReceivers() == null) {
                ((ActionGroupResourceInner)((Object)this.innerModel())).withVoiceReceivers(new ArrayList<VoiceReceiver>());
            } else {
                ((ActionGroupResourceInner)((Object)this.innerModel())).voiceReceivers().clear();
            }
            ((ActionGroupResourceInner)((Object)this.innerModel())).voiceReceivers().addAll(this.voiceReceivers.values());
        } else {
            ((ActionGroupResourceInner)((Object)this.innerModel())).withVoiceReceivers(null);
        }
        if (this.runBookReceivers.values().size() > 0) {
            if (((ActionGroupResourceInner)((Object)this.innerModel())).automationRunbookReceivers() == null) {
                ((ActionGroupResourceInner)((Object)this.innerModel())).withAutomationRunbookReceivers(new ArrayList<AutomationRunbookReceiver>());
            } else {
                ((ActionGroupResourceInner)((Object)this.innerModel())).automationRunbookReceivers().clear();
            }
            ((ActionGroupResourceInner)((Object)this.innerModel())).automationRunbookReceivers().addAll(this.runBookReceivers.values());
        } else {
            ((ActionGroupResourceInner)((Object)this.innerModel())).withAutomationRunbookReceivers(null);
        }
        if (this.logicReceivers.values().size() > 0) {
            if (((ActionGroupResourceInner)((Object)this.innerModel())).logicAppReceivers() == null) {
                ((ActionGroupResourceInner)((Object)this.innerModel())).withLogicAppReceivers(new ArrayList<LogicAppReceiver>());
            } else {
                ((ActionGroupResourceInner)((Object)this.innerModel())).logicAppReceivers().clear();
            }
            ((ActionGroupResourceInner)((Object)this.innerModel())).logicAppReceivers().addAll(this.logicReceivers.values());
        } else {
            ((ActionGroupResourceInner)((Object)this.innerModel())).withLogicAppReceivers(null);
        }
        if (this.functionReceivers.values().size() > 0) {
            if (((ActionGroupResourceInner)((Object)this.innerModel())).azureFunctionReceivers() == null) {
                ((ActionGroupResourceInner)((Object)this.innerModel())).withAzureFunctionReceivers(new ArrayList<AzureFunctionReceiver>());
            } else {
                ((ActionGroupResourceInner)((Object)this.innerModel())).azureFunctionReceivers().clear();
            }
            ((ActionGroupResourceInner)((Object)this.innerModel())).azureFunctionReceivers().addAll(this.functionReceivers.values());
        } else {
            ((ActionGroupResourceInner)((Object)this.innerModel())).withAzureFunctionReceivers(null);
        }
        if (this.webhookReceivers.values().size() > 0) {
            if (((ActionGroupResourceInner)((Object)this.innerModel())).webhookReceivers() == null) {
                ((ActionGroupResourceInner)((Object)this.innerModel())).withWebhookReceivers(new ArrayList<WebhookReceiver>());
            } else {
                ((ActionGroupResourceInner)((Object)this.innerModel())).webhookReceivers().clear();
            }
            ((ActionGroupResourceInner)((Object)this.innerModel())).webhookReceivers().addAll(this.webhookReceivers.values());
        } else {
            ((ActionGroupResourceInner)((Object)this.innerModel())).withWebhookReceivers(null);
        }
        if (this.itsmReceivers.values().size() > 0) {
            if (((ActionGroupResourceInner)((Object)this.innerModel())).itsmReceivers() == null) {
                ((ActionGroupResourceInner)((Object)this.innerModel())).withItsmReceivers(new ArrayList<ItsmReceiver>());
            } else {
                ((ActionGroupResourceInner)((Object)this.innerModel())).itsmReceivers().clear();
            }
            ((ActionGroupResourceInner)((Object)this.innerModel())).itsmReceivers().addAll(this.itsmReceivers.values());
        } else {
            ((ActionGroupResourceInner)((Object)this.innerModel())).withItsmReceivers(null);
        }
    }
}

