/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.datafactory.fluent.IntegrationRuntimeObjectMetadatasClient;
import com.azure.resourcemanager.datafactory.fluent.models.SsisObjectMetadataListResponseInner;
import com.azure.resourcemanager.datafactory.fluent.models.SsisObjectMetadataStatusResponseInner;
import com.azure.resourcemanager.datafactory.implementation.DataFactoryManagementClientImpl;
import com.azure.resourcemanager.datafactory.models.GetSsisObjectMetadataRequest;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class IntegrationRuntimeObjectMetadatasClientImpl
implements IntegrationRuntimeObjectMetadatasClient {
    private final IntegrationRuntimeObjectMetadatasService service;
    private final DataFactoryManagementClientImpl client;

    IntegrationRuntimeObjectMetadatasClientImpl(DataFactoryManagementClientImpl client) {
        this.service = (IntegrationRuntimeObjectMetadatasService)RestProxy.create(IntegrationRuntimeObjectMetadatasService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> refreshWithResponseAsync(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.refresh(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, integrationRuntimeName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> refreshWithResponseAsync(String resourceGroupName, String factoryName, String integrationRuntimeName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.refresh(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, integrationRuntimeName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<SsisObjectMetadataStatusResponseInner>, SsisObjectMetadataStatusResponseInner> beginRefreshAsync(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.refreshWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)SsisObjectMetadataStatusResponseInner.class), (Type)((Object)SsisObjectMetadataStatusResponseInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<SsisObjectMetadataStatusResponseInner>, SsisObjectMetadataStatusResponseInner> beginRefreshAsync(String resourceGroupName, String factoryName, String integrationRuntimeName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.refreshWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)SsisObjectMetadataStatusResponseInner.class), (Type)((Object)SsisObjectMetadataStatusResponseInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SsisObjectMetadataStatusResponseInner>, SsisObjectMetadataStatusResponseInner> beginRefresh(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        return this.beginRefreshAsync(resourceGroupName, factoryName, integrationRuntimeName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SsisObjectMetadataStatusResponseInner>, SsisObjectMetadataStatusResponseInner> beginRefresh(String resourceGroupName, String factoryName, String integrationRuntimeName, Context context) {
        return this.beginRefreshAsync(resourceGroupName, factoryName, integrationRuntimeName, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SsisObjectMetadataStatusResponseInner> refreshAsync(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        return this.beginRefreshAsync(resourceGroupName, factoryName, integrationRuntimeName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SsisObjectMetadataStatusResponseInner> refreshAsync(String resourceGroupName, String factoryName, String integrationRuntimeName, Context context) {
        return this.beginRefreshAsync(resourceGroupName, factoryName, integrationRuntimeName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SsisObjectMetadataStatusResponseInner refresh(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        return (SsisObjectMetadataStatusResponseInner)this.refreshAsync(resourceGroupName, factoryName, integrationRuntimeName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SsisObjectMetadataStatusResponseInner refresh(String resourceGroupName, String factoryName, String integrationRuntimeName, Context context) {
        return (SsisObjectMetadataStatusResponseInner)this.refreshAsync(resourceGroupName, factoryName, integrationRuntimeName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SsisObjectMetadataListResponseInner>> getWithResponseAsync(String resourceGroupName, String factoryName, String integrationRuntimeName, GetSsisObjectMetadataRequest getMetadataRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        if (getMetadataRequest != null) {
            getMetadataRequest.validate();
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, integrationRuntimeName, this.client.getApiVersion(), getMetadataRequest, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SsisObjectMetadataListResponseInner>> getWithResponseAsync(String resourceGroupName, String factoryName, String integrationRuntimeName, GetSsisObjectMetadataRequest getMetadataRequest, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        if (getMetadataRequest != null) {
            getMetadataRequest.validate();
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, integrationRuntimeName, this.client.getApiVersion(), getMetadataRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SsisObjectMetadataListResponseInner> getAsync(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        GetSsisObjectMetadataRequest getMetadataRequest = null;
        return this.getWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName, getMetadataRequest).flatMap(res -> Mono.justOrEmpty((Object)((SsisObjectMetadataListResponseInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SsisObjectMetadataListResponseInner> getWithResponse(String resourceGroupName, String factoryName, String integrationRuntimeName, GetSsisObjectMetadataRequest getMetadataRequest, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName, getMetadataRequest, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SsisObjectMetadataListResponseInner get(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        GetSsisObjectMetadataRequest getMetadataRequest = null;
        return (SsisObjectMetadataListResponseInner)this.getWithResponse(resourceGroupName, factoryName, integrationRuntimeName, getMetadataRequest, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="DataFactoryManagemen")
    public static interface IntegrationRuntimeObjectMetadatasService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/integrationRuntimes/{integrationRuntimeName}/refreshObjectMetadata")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> refresh(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @PathParam(value="integrationRuntimeName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/integrationRuntimes/{integrationRuntimeName}/getObjectMetadata")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SsisObjectMetadataListResponseInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @PathParam(value="integrationRuntimeName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") GetSsisObjectMetadataRequest var7, @HeaderParam(value="Accept") String var8, Context var9);
    }
}

