/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.datafactory.fluent.ActivityRunsClient;
import com.azure.resourcemanager.datafactory.fluent.models.ActivityRunsQueryResponseInner;
import com.azure.resourcemanager.datafactory.implementation.DataFactoryManagementClientImpl;
import com.azure.resourcemanager.datafactory.models.RunFilterParameters;
import reactor.core.publisher.Mono;

public final class ActivityRunsClientImpl
implements ActivityRunsClient {
    private final ActivityRunsService service;
    private final DataFactoryManagementClientImpl client;

    ActivityRunsClientImpl(DataFactoryManagementClientImpl client) {
        this.service = (ActivityRunsService)RestProxy.create(ActivityRunsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ActivityRunsQueryResponseInner>> queryByPipelineRunWithResponseAsync(String resourceGroupName, String factoryName, String runId, RunFilterParameters filterParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (runId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runId is required and cannot be null."));
        }
        if (filterParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter filterParameters is required and cannot be null."));
        }
        filterParameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.queryByPipelineRun(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, runId, this.client.getApiVersion(), filterParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ActivityRunsQueryResponseInner>> queryByPipelineRunWithResponseAsync(String resourceGroupName, String factoryName, String runId, RunFilterParameters filterParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (runId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runId is required and cannot be null."));
        }
        if (filterParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter filterParameters is required and cannot be null."));
        }
        filterParameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.queryByPipelineRun(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, runId, this.client.getApiVersion(), filterParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ActivityRunsQueryResponseInner> queryByPipelineRunAsync(String resourceGroupName, String factoryName, String runId, RunFilterParameters filterParameters) {
        return this.queryByPipelineRunWithResponseAsync(resourceGroupName, factoryName, runId, filterParameters).flatMap(res -> Mono.justOrEmpty((Object)((ActivityRunsQueryResponseInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ActivityRunsQueryResponseInner> queryByPipelineRunWithResponse(String resourceGroupName, String factoryName, String runId, RunFilterParameters filterParameters, Context context) {
        return (Response)this.queryByPipelineRunWithResponseAsync(resourceGroupName, factoryName, runId, filterParameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ActivityRunsQueryResponseInner queryByPipelineRun(String resourceGroupName, String factoryName, String runId, RunFilterParameters filterParameters) {
        return (ActivityRunsQueryResponseInner)this.queryByPipelineRunWithResponse(resourceGroupName, factoryName, runId, filterParameters, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="DataFactoryManagemen")
    public static interface ActivityRunsService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/pipelineruns/{runId}/queryActivityruns")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ActivityRunsQueryResponseInner>> queryByPipelineRun(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @PathParam(value="runId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") RunFilterParameters var7, @HeaderParam(value="Accept") String var8, Context var9);
    }
}

