/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.engine.ILifecycleEventHandler;
import org.apache.dolphinscheduler.server.master.engine.WorkflowEventBusFireWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkflowEventBusFireWorkers
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowEventBusFireWorkers.class);
    @Autowired
    private List<ILifecycleEventHandler> eventHandlers;
    @Autowired
    private MasterConfig masterConfig;
    private static final long DEFAULT_FIRE_INTERVAL = 100L;
    private WorkflowEventBusFireWorker[] workflowEventBusFireWorkers;
    private ScheduledExecutorService workflowEventBusFireThreadPool;

    public void start() {
        int workflowEventBusFireThreadCount = this.masterConfig.getWorkflowEventBusFireThreadCount();
        this.workflowEventBusFireThreadPool = Executors.newScheduledThreadPool(workflowEventBusFireThreadCount, ThreadUtils.newDaemonThreadFactory((String)"ds-workflow-eventbus-worker-%d"));
        this.workflowEventBusFireWorkers = new WorkflowEventBusFireWorker[workflowEventBusFireThreadCount];
        for (int i = 0; i < workflowEventBusFireThreadCount; ++i) {
            WorkflowEventBusFireWorker workflowEventBusFireWorker = new WorkflowEventBusFireWorker();
            this.eventHandlers.forEach(workflowEventBusFireWorker::registerEventHandler);
            this.workflowEventBusFireWorkers[i] = workflowEventBusFireWorker;
            this.workflowEventBusFireThreadPool.scheduleWithFixedDelay(workflowEventBusFireWorker::fireAllRegisteredEvent, 100L, 100L, TimeUnit.MILLISECONDS);
        }
        log.info("WorkflowEventBusFireWorkers started, worker size: {}", (Object)workflowEventBusFireThreadCount);
    }

    public WorkflowEventBusFireWorker getWorker(Integer workerSlot) {
        return this.workflowEventBusFireWorkers[workerSlot];
    }

    @VisibleForTesting
    public WorkflowEventBusFireWorker[] getWorkers() {
        return this.workflowEventBusFireWorkers;
    }

    public int getWorkerSize() {
        return this.masterConfig.getWorkflowEventBusFireThreadCount();
    }

    @Override
    public void close() throws Exception {
        if (this.workflowEventBusFireThreadPool != null) {
            this.workflowEventBusFireThreadPool.shutdown();
        }
        log.info("WorkflowEventBusFireWorkers closed");
    }
}

