/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dns.implementation;

import com.azure.resourcemanager.dns.fluent.models.RecordSetInner;
import com.azure.resourcemanager.dns.implementation.ARecordSetImpl;
import com.azure.resourcemanager.dns.implementation.AaaaRecordSetImpl;
import com.azure.resourcemanager.dns.implementation.CaaRecordSetImpl;
import com.azure.resourcemanager.dns.implementation.CnameRecordSetImpl;
import com.azure.resourcemanager.dns.implementation.DnsRecordSetImpl;
import com.azure.resourcemanager.dns.implementation.DnsZoneImpl;
import com.azure.resourcemanager.dns.implementation.MxRecordSetImpl;
import com.azure.resourcemanager.dns.implementation.NsRecordSetImpl;
import com.azure.resourcemanager.dns.implementation.PtrRecordSetImpl;
import com.azure.resourcemanager.dns.implementation.SoaRecordSetImpl;
import com.azure.resourcemanager.dns.implementation.SrvRecordSetImpl;
import com.azure.resourcemanager.dns.implementation.TxtRecordSetImpl;
import com.azure.resourcemanager.dns.models.DnsRecordSet;
import com.azure.resourcemanager.dns.models.DnsZone;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.ExternalChildResourcesNonCachedImpl;

class DnsRecordSetsImpl
extends ExternalChildResourcesNonCachedImpl<DnsRecordSetImpl, DnsRecordSet, RecordSetInner, DnsZoneImpl, DnsZone> {
    private static final long DEFAULT_TTL_IN_SECONDS = 3600L;

    DnsRecordSetsImpl(DnsZoneImpl parent) {
        super((Object)parent, parent.taskGroup(), "RecordSet");
    }

    DnsRecordSetImpl defineARecordSet(String name) {
        return this.setDefaults((DnsRecordSetImpl)this.prepareInlineDefine(ARecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.getParent())));
    }

    DnsRecordSetImpl defineAaaaRecordSet(String name) {
        return this.setDefaults((DnsRecordSetImpl)this.prepareInlineDefine(AaaaRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.getParent())));
    }

    void withCNameRecordSet(String name, String alias) {
        CnameRecordSetImpl recordSet = CnameRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.getParent());
        ((RecordSetInner)((Object)recordSet.innerModel())).cnameRecord().withCname(alias);
        this.setDefaults((DnsRecordSetImpl)this.prepareInlineDefine(recordSet.withTimeToLive(3600L)));
    }

    DnsRecordSetImpl defineCaaRecordSet(String name) {
        return this.setDefaults((DnsRecordSetImpl)this.prepareInlineDefine(CaaRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.getParent())));
    }

    DnsRecordSetImpl defineCNameRecordSet(String name) {
        return this.setDefaults((DnsRecordSetImpl)this.prepareInlineDefine(CnameRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.getParent())));
    }

    DnsRecordSetImpl defineMXRecordSet(String name) {
        return this.setDefaults((DnsRecordSetImpl)this.prepareInlineDefine(MxRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.getParent())));
    }

    DnsRecordSetImpl defineNSRecordSet(String name) {
        return this.setDefaults((DnsRecordSetImpl)this.prepareInlineDefine(NsRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.getParent())));
    }

    DnsRecordSetImpl definePtrRecordSet(String name) {
        return this.setDefaults((DnsRecordSetImpl)this.prepareInlineDefine(PtrRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.getParent())));
    }

    DnsRecordSetImpl defineSrvRecordSet(String name) {
        return this.setDefaults((DnsRecordSetImpl)this.prepareInlineDefine(SrvRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.getParent())));
    }

    DnsRecordSetImpl defineTxtRecordSet(String name) {
        return this.setDefaults((DnsRecordSetImpl)this.prepareInlineDefine(TxtRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.getParent())));
    }

    DnsRecordSetImpl updateARecordSet(String name) {
        return (DnsRecordSetImpl)this.prepareInlineUpdate(ARecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.getParent()));
    }

    DnsRecordSetImpl updateAaaaRecordSet(String name) {
        return (DnsRecordSetImpl)this.prepareInlineUpdate(AaaaRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.getParent()));
    }

    DnsRecordSetImpl updateMXRecordSet(String name) {
        return (DnsRecordSetImpl)this.prepareInlineUpdate(MxRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.getParent()));
    }

    DnsRecordSetImpl updateCaaRecordSet(String name) {
        return (DnsRecordSetImpl)this.prepareInlineUpdate(CaaRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.getParent()));
    }

    DnsRecordSetImpl updateCNameRecordSet(String name) {
        return (DnsRecordSetImpl)this.prepareInlineUpdate(CnameRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.getParent()));
    }

    DnsRecordSetImpl updateNSRecordSet(String name) {
        return (DnsRecordSetImpl)this.prepareInlineUpdate(NsRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.getParent()));
    }

    DnsRecordSetImpl updatePtrRecordSet(String name) {
        return (DnsRecordSetImpl)this.prepareInlineUpdate(PtrRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.getParent()));
    }

    DnsRecordSetImpl updateSrvRecordSet(String name) {
        return (DnsRecordSetImpl)this.prepareInlineUpdate(SrvRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.getParent()));
    }

    DnsRecordSetImpl updateTxtRecordSet(String name) {
        return (DnsRecordSetImpl)this.prepareInlineUpdate(TxtRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.getParent()));
    }

    DnsRecordSetImpl updateSoaRecordSet() {
        return (DnsRecordSetImpl)this.prepareInlineUpdate(SoaRecordSetImpl.newRecordSet((DnsZoneImpl)this.getParent()));
    }

    void withoutARecordSet(String name, String eTagValue) {
        this.prepareInlineRemove(ARecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.getParent()).withETagOnDelete(eTagValue));
    }

    void withoutAaaaRecordSet(String name, String eTagValue) {
        this.prepareInlineRemove(AaaaRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.getParent()).withETagOnDelete(eTagValue));
    }

    void withoutCaaRecordSet(String name, String eTagValue) {
        this.prepareInlineRemove(CaaRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.getParent()).withETagOnDelete(eTagValue));
    }

    void withoutCNameRecordSet(String name, String eTagValue) {
        this.prepareInlineRemove(CnameRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.getParent()).withETagOnDelete(eTagValue));
    }

    void withoutMXRecordSet(String name, String eTagValue) {
        this.prepareInlineRemove(MxRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.getParent()).withETagOnDelete(eTagValue));
    }

    void withoutNSRecordSet(String name, String eTagValue) {
        this.prepareInlineRemove(NsRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.getParent()).withETagOnDelete(eTagValue));
    }

    void withoutPtrRecordSet(String name, String eTagValue) {
        this.prepareInlineRemove(PtrRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.getParent()).withETagOnDelete(eTagValue));
    }

    void withoutSrvRecordSet(String name, String eTagValue) {
        this.prepareInlineRemove(SrvRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.getParent()).withETagOnDelete(eTagValue));
    }

    void withoutTxtRecordSet(String name, String eTagValue) {
        this.prepareInlineRemove(TxtRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.getParent()).withETagOnDelete(eTagValue));
    }

    private DnsRecordSetImpl setDefaults(DnsRecordSetImpl recordSet) {
        return recordSet.withTimeToLive(3600L);
    }
}

