/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.api.client;

import com.google.common.base.Preconditions;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.DataSourceUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.PasswordUtils;
import org.apache.dolphinscheduler.spi.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.PooledDataSourceClient;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasePooledDataSourceClient
implements PooledDataSourceClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BasePooledDataSourceClient.class);
    protected final BaseConnectionParam baseConnectionParam;
    protected HikariDataSource dataSource;

    public BasePooledDataSourceClient(BaseConnectionParam baseConnectionParam, DbType dbType) {
        this.baseConnectionParam = (BaseConnectionParam)Preconditions.checkNotNull((Object)baseConnectionParam, (Object)"baseConnectionParam is null");
        this.dataSource = this.createDataSourcePool(baseConnectionParam, (DbType)Preconditions.checkNotNull((Object)dbType, (Object)"dbType is null"));
    }

    public HikariDataSource createDataSourcePool(BaseConnectionParam baseConnectionParam, DbType dbType) {
        HikariDataSource dataSource = new HikariDataSource();
        dataSource.setDriverClassName(baseConnectionParam.getDriverClassName());
        dataSource.setJdbcUrl(DataSourceUtils.getJdbcUrl(dbType, (ConnectionParam)baseConnectionParam));
        dataSource.setUsername(baseConnectionParam.getUser());
        dataSource.setPassword(PasswordUtils.decodePassword(baseConnectionParam.getPassword()));
        dataSource.setMinimumIdle(PropertyUtils.getInt((String)"spring.datasource.minIdle", (int)5).intValue());
        dataSource.setMaximumPoolSize(PropertyUtils.getInt((String)"spring.datasource.maxActive", (int)50).intValue());
        dataSource.setConnectionTestQuery(baseConnectionParam.getValidationQuery());
        if (MapUtils.isNotEmpty((Map)baseConnectionParam.getOther())) {
            baseConnectionParam.getOther().forEach((arg_0, arg_1) -> ((HikariDataSource)dataSource).addDataSourceProperty(arg_0, arg_1));
        }
        log.info("Creating HikariDataSource for {} success.", (Object)dbType.name());
        return dataSource;
    }

    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    public void close() {
        log.info("do close dataSource {}.", (Object)this.baseConnectionParam.getDatabase());
        HikariDataSource closedDatasource = this.dataSource;
        Throwable throwable = null;
        if (closedDatasource != null) {
            if (throwable != null) {
                try {
                    closedDatasource.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                closedDatasource.close();
            }
        }
    }
}

