/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.polling;

import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.AsyncPollResponse;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollingContext;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Function;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class PollingUtil {
    private static final ClientLogger LOGGER = new ClientLogger(PollingUtil.class);

    PollingUtil() {
    }

    static <T> PollResponse<T> pollingLoop(PollingContext<T> pollingContext, Duration timeout, LongRunningOperationStatus statusToWaitFor, Function<PollingContext<T>, PollResponse<T>> pollOperation, Duration pollInterval) {
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        boolean timeBound = timeout != null;
        long timeoutInMillis = timeBound ? timeout.toMillis() : -1L;
        long startTime = System.currentTimeMillis();
        pollingContext.setLatestResponse(pollOperation.apply(pollingContext));
        PollResponse<T> intermediatePollResponse = pollingContext.getLatestResponse();
        Runnable pollOpRunnable = () -> {
            PollResponse pollResponse1 = (PollResponse)pollOperation.apply(pollingContext);
            pollingContext.setLatestResponse(pollResponse1);
        };
        while (!intermediatePollResponse.getStatus().isComplete()) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            if (timeBound && elapsedTime >= timeoutInMillis) {
                scheduler.shutdown();
                return intermediatePollResponse;
            }
            if (statusToWaitFor != null && intermediatePollResponse.getStatus().equals(statusToWaitFor)) {
                scheduler.shutdown();
                return intermediatePollResponse;
            }
            ScheduledFuture<?> pollOp = scheduler.schedule(pollOpRunnable, PollingUtil.getDelay(intermediatePollResponse, pollInterval).toMillis(), TimeUnit.MILLISECONDS);
            try {
                if (timeBound) {
                    pollOp.get(timeoutInMillis - elapsedTime, TimeUnit.MILLISECONDS);
                } else {
                    pollOp.get();
                }
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                scheduler.shutdown();
                throw LOGGER.logExceptionAsError(new RuntimeException(e));
            }
            intermediatePollResponse = pollingContext.getLatestResponse();
        }
        scheduler.shutdown();
        return intermediatePollResponse;
    }

    static <T, U> Flux<AsyncPollResponse<T, U>> pollingLoopAsync(PollingContext<T> pollingContext, Function<PollingContext<T>, Mono<PollResponse<T>>> pollOperation, BiFunction<PollingContext<T>, PollResponse<T>, Mono<T>> cancelOperation, Function<PollingContext<T>, Mono<U>> fetchResultOperation, Duration pollInterval) {
        return Flux.using(() -> pollingContext, cxt -> Mono.defer(() -> (Mono)pollOperation.apply((PollingContext)cxt)).delaySubscription(PollingUtil.getDelay(cxt.getLatestResponse(), pollInterval)).switchIfEmpty(Mono.error(() -> new IllegalStateException("PollOperation returned Mono.empty()."))).repeat().takeUntil(currentPollResponse -> currentPollResponse.getStatus().isComplete()).concatMap(currentPollResponse -> {
            cxt.setLatestResponse(currentPollResponse);
            return Mono.just(new AsyncPollResponse(cxt, cancelOperation, fetchResultOperation));
        }), cxt -> {});
    }

    private static <T> Duration getDelay(PollResponse<T> pollResponse, Duration pollInterval) {
        Duration retryAfter = pollResponse.getRetryAfter();
        if (retryAfter == null) {
            return pollInterval;
        }
        return retryAfter.compareTo(Duration.ZERO) > 0 ? retryAfter : pollInterval;
    }

    static <T, U> PollResponse<T> toPollResponse(AsyncPollResponse<T, U> asyncPollResponse) {
        return new PollResponse<T>(asyncPollResponse.getStatus(), asyncPollResponse.getValue(), asyncPollResponse.getRetryAfter());
    }

    static <T, U> boolean matchStatus(AsyncPollResponse<T, U> currentPollResponse, LongRunningOperationStatus statusToWaitFor) {
        if (currentPollResponse == null || statusToWaitFor == null) {
            return false;
        }
        return statusToWaitFor == currentPollResponse.getStatus();
    }
}

