/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.azure.resourcemanager.network.fluent.models.ConnectionSharedKeyInner;
import com.azure.resourcemanager.network.fluent.models.LocalNetworkGatewayInner;
import com.azure.resourcemanager.network.fluent.models.VirtualNetworkGatewayConnectionInner;
import com.azure.resourcemanager.network.fluent.models.VirtualNetworkGatewayInner;
import com.azure.resourcemanager.network.implementation.VirtualNetworkGatewayImpl;
import com.azure.resourcemanager.network.models.AppliableWithTags;
import com.azure.resourcemanager.network.models.ExpressRouteCircuit;
import com.azure.resourcemanager.network.models.IpsecPolicy;
import com.azure.resourcemanager.network.models.LocalNetworkGateway;
import com.azure.resourcemanager.network.models.TagsObject;
import com.azure.resourcemanager.network.models.TunnelConnectionHealth;
import com.azure.resourcemanager.network.models.VirtualNetworkGateway;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayConnection;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayConnectionStatus;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayConnectionType;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import java.util.Collection;
import java.util.Collections;
import reactor.core.publisher.Mono;

public class VirtualNetworkGatewayConnectionImpl
extends GroupableResourceImpl<VirtualNetworkGatewayConnection, VirtualNetworkGatewayConnectionInner, VirtualNetworkGatewayConnectionImpl, NetworkManager>
implements VirtualNetworkGatewayConnection,
VirtualNetworkGatewayConnection.Definition,
VirtualNetworkGatewayConnection.Update,
AppliableWithTags<VirtualNetworkGatewayConnection> {
    private final VirtualNetworkGateway parent;
    private String updateSharedKey;

    VirtualNetworkGatewayConnectionImpl(String name, VirtualNetworkGatewayImpl parent, VirtualNetworkGatewayConnectionInner inner) {
        super(name, (Resource)inner, (Manager)((NetworkManager)parent.manager()));
        this.parent = parent;
    }

    public VirtualNetworkGateway parent() {
        return this.parent;
    }

    @Override
    public String authorizationKey() {
        return ((VirtualNetworkGatewayConnectionInner)((Object)this.innerModel())).authorizationKey();
    }

    @Override
    public String virtualNetworkGateway1Id() {
        if (((VirtualNetworkGatewayConnectionInner)((Object)this.innerModel())).virtualNetworkGateway1() == null) {
            return null;
        }
        return ((VirtualNetworkGatewayConnectionInner)((Object)this.innerModel())).virtualNetworkGateway1().id();
    }

    @Override
    public String virtualNetworkGateway2Id() {
        if (((VirtualNetworkGatewayConnectionInner)((Object)this.innerModel())).virtualNetworkGateway2() == null) {
            return null;
        }
        return ((VirtualNetworkGatewayConnectionInner)((Object)this.innerModel())).virtualNetworkGateway2().id();
    }

    @Override
    public String localNetworkGateway2Id() {
        if (((VirtualNetworkGatewayConnectionInner)((Object)this.innerModel())).localNetworkGateway2() == null) {
            return null;
        }
        return ((VirtualNetworkGatewayConnectionInner)((Object)this.innerModel())).localNetworkGateway2().id();
    }

    @Override
    public VirtualNetworkGatewayConnectionType connectionType() {
        return ((VirtualNetworkGatewayConnectionInner)((Object)this.innerModel())).connectionType();
    }

    @Override
    public int routingWeight() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)((VirtualNetworkGatewayConnectionInner)((Object)this.innerModel())).routingWeight());
    }

    @Override
    public String sharedKey() {
        return ((VirtualNetworkGatewayConnectionInner)((Object)this.innerModel())).sharedKey();
    }

    @Override
    public VirtualNetworkGatewayConnectionStatus connectionStatus() {
        return ((VirtualNetworkGatewayConnectionInner)((Object)this.innerModel())).connectionStatus();
    }

    @Override
    public Collection<TunnelConnectionHealth> tunnelConnectionStatus() {
        return Collections.unmodifiableCollection(((VirtualNetworkGatewayConnectionInner)((Object)this.innerModel())).tunnelConnectionStatus());
    }

    @Override
    public long egressBytesTransferred() {
        return ResourceManagerUtils.toPrimitiveLong((Long)((VirtualNetworkGatewayConnectionInner)((Object)this.innerModel())).egressBytesTransferred());
    }

    @Override
    public long ingressBytesTransferred() {
        return ResourceManagerUtils.toPrimitiveLong((Long)((VirtualNetworkGatewayConnectionInner)((Object)this.innerModel())).ingressBytesTransferred());
    }

    @Override
    public String peerId() {
        return ((VirtualNetworkGatewayConnectionInner)((Object)this.innerModel())).peer() == null ? null : ((VirtualNetworkGatewayConnectionInner)((Object)this.innerModel())).peer().id();
    }

    @Override
    public boolean isBgpEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((VirtualNetworkGatewayConnectionInner)((Object)this.innerModel())).enableBgp());
    }

    @Override
    public boolean usePolicyBasedTrafficSelectors() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((VirtualNetworkGatewayConnectionInner)((Object)this.innerModel())).usePolicyBasedTrafficSelectors());
    }

    @Override
    public Collection<IpsecPolicy> ipsecPolicies() {
        return Collections.unmodifiableCollection(((VirtualNetworkGatewayConnectionInner)((Object)this.innerModel())).ipsecPolicies());
    }

    @Override
    public String provisioningState() {
        return ((VirtualNetworkGatewayConnectionInner)((Object)this.innerModel())).provisioningState().toString();
    }

    @Override
    public VirtualNetworkGatewayConnectionImpl withSiteToSite() {
        ((VirtualNetworkGatewayConnectionInner)((Object)this.innerModel())).withConnectionType(VirtualNetworkGatewayConnectionType.IPSEC);
        return this;
    }

    @Override
    public VirtualNetworkGatewayConnectionImpl withVNetToVNet() {
        ((VirtualNetworkGatewayConnectionInner)((Object)this.innerModel())).withConnectionType(VirtualNetworkGatewayConnectionType.VNET2VNET);
        return this;
    }

    @Override
    public VirtualNetworkGatewayConnectionImpl withExpressRoute(String circuitId) {
        ((VirtualNetworkGatewayConnectionInner)((Object)this.innerModel())).withConnectionType(VirtualNetworkGatewayConnectionType.EXPRESS_ROUTE);
        ((VirtualNetworkGatewayConnectionInner)((Object)this.innerModel())).withPeer(new SubResource().withId(circuitId));
        return this;
    }

    @Override
    public VirtualNetworkGatewayConnectionImpl withExpressRoute(ExpressRouteCircuit circuit) {
        return this.withExpressRoute(circuit.id());
    }

    @Override
    public VirtualNetworkGatewayConnectionImpl withLocalNetworkGateway(LocalNetworkGateway localNetworkGateway) {
        ((VirtualNetworkGatewayConnectionInner)((Object)this.innerModel())).withLocalNetworkGateway2((LocalNetworkGatewayInner)((Object)localNetworkGateway.innerModel()));
        return this;
    }

    @Override
    public VirtualNetworkGatewayConnectionImpl withSecondVirtualNetworkGateway(VirtualNetworkGateway virtualNetworkGateway2) {
        ((VirtualNetworkGatewayConnectionInner)((Object)this.innerModel())).withVirtualNetworkGateway2((VirtualNetworkGatewayInner)((Object)virtualNetworkGateway2.innerModel()));
        return this;
    }

    @Override
    public VirtualNetworkGatewayConnectionImpl withSharedKey(String sharedKey) {
        if (this.isInCreateMode()) {
            ((VirtualNetworkGatewayConnectionInner)((Object)this.innerModel())).withSharedKey(sharedKey);
        } else {
            this.updateSharedKey = sharedKey;
        }
        return this;
    }

    @Override
    public VirtualNetworkGatewayConnectionImpl withBgp() {
        ((VirtualNetworkGatewayConnectionInner)((Object)this.innerModel())).withEnableBgp(true);
        return this;
    }

    @Override
    public VirtualNetworkGatewayConnectionImpl withoutBgp() {
        ((VirtualNetworkGatewayConnectionInner)((Object)this.innerModel())).withEnableBgp(false);
        return this;
    }

    @Override
    public VirtualNetworkGatewayConnectionImpl withAuthorization(String authorizationKey) {
        ((VirtualNetworkGatewayConnectionInner)((Object)this.innerModel())).withAuthorizationKey(authorizationKey);
        return this;
    }

    protected Mono<VirtualNetworkGatewayConnectionInner> getInnerAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.myManager).serviceClient()).getVirtualNetworkGatewayConnections().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    public Mono<VirtualNetworkGatewayConnection> createResourceAsync() {
        this.beforeCreating();
        return ((NetworkManagementClient)((NetworkManager)this.myManager).serviceClient()).getVirtualNetworkGatewayConnections().createOrUpdateAsync(this.resourceGroupName(), this.name(), (VirtualNetworkGatewayConnectionInner)((Object)this.innerModel())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this)).flatMap(virtualNetworkGatewayConnection -> {
            if (this.updateSharedKey == null) {
                return Mono.just((Object)virtualNetworkGatewayConnection);
            }
            return ((NetworkManagementClient)((NetworkManager)this.myManager).serviceClient()).getVirtualNetworkGatewayConnections().setSharedKeyAsync(this.resourceGroupName(), this.name(), new ConnectionSharedKeyInner().withValue(this.updateSharedKey)).doOnSuccess(inner -> {
                this.updateSharedKey = null;
            }).then(((NetworkManagementClient)((NetworkManager)this.myManager).serviceClient()).getVirtualNetworkGatewayConnections().getByResourceGroupAsync(this.resourceGroupName(), this.name()).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this)));
        });
    }

    private void beforeCreating() {
        ((VirtualNetworkGatewayConnectionInner)((Object)this.innerModel())).withVirtualNetworkGateway1((VirtualNetworkGatewayInner)((Object)this.parent.innerModel()));
    }

    public VirtualNetworkGatewayConnectionImpl updateTags() {
        return this;
    }

    @Override
    public VirtualNetworkGatewayConnection applyTags() {
        return (VirtualNetworkGatewayConnection)this.applyTagsAsync().block();
    }

    @Override
    public Mono<VirtualNetworkGatewayConnection> applyTagsAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getVirtualNetworkGatewayConnections().updateTagsAsync(this.resourceGroupName(), this.name(), new TagsObject().withTags(((VirtualNetworkGatewayConnectionInner)((Object)this.innerModel())).tags())).flatMap(inner -> this.refreshAsync());
    }
}

