/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.fluent.models.WorkspaceInfoProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class WorkspaceInfo {
    @JsonProperty(value="id", required=true)
    private String id;
    @JsonProperty(value="location", required=true)
    private String location;
    @JsonProperty(value="properties", required=true)
    private WorkspaceInfoProperties innerProperties = new WorkspaceInfoProperties();
    private static final ClientLogger LOGGER = new ClientLogger(WorkspaceInfo.class);

    public String id() {
        return this.id;
    }

    public WorkspaceInfo withId(String id) {
        this.id = id;
        return this;
    }

    public String location() {
        return this.location;
    }

    public WorkspaceInfo withLocation(String location) {
        this.location = location;
        return this;
    }

    private WorkspaceInfoProperties innerProperties() {
        return this.innerProperties;
    }

    public String customerId() {
        return this.innerProperties() == null ? null : this.innerProperties().customerId();
    }

    public WorkspaceInfo withCustomerId(String customerId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkspaceInfoProperties();
        }
        this.innerProperties().withCustomerId(customerId);
        return this;
    }

    public void validate() {
        if (this.id() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property id in model WorkspaceInfo"));
        }
        if (this.location() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property location in model WorkspaceInfo"));
        }
        if (this.innerProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model WorkspaceInfo"));
        }
        this.innerProperties().validate();
    }
}

