/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.model;

import com.qcloud.cos.internal.CosServiceRequest;
import com.qcloud.cos.model.AccessControlList;
import com.qcloud.cos.model.CannedAccessControlList;
import com.qcloud.cos.model.CosDataSource;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.SSECOSKeyManagementParams;
import com.qcloud.cos.model.SSECOSKeyManagementParamsProvider;
import com.qcloud.cos.model.SSECustomerKey;
import com.qcloud.cos.model.SSECustomerKeyProvider;
import com.qcloud.cos.model.StorageClass;
import com.qcloud.cos.model.ciModel.persistence.PicOperations;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;

public abstract class AbstractPutObjectRequest
extends CosServiceRequest
implements Cloneable,
SSECustomerKeyProvider,
SSECOSKeyManagementParamsProvider,
CosDataSource,
Serializable {
    private String bucketName;
    private String key;
    private File file;
    private transient InputStream inputStream;
    private ObjectMetadata metadata;
    private CannedAccessControlList cannedAcl;
    private AccessControlList accessControlList;
    private String storageClass;
    private String redirectLocation;
    private SSECustomerKey sseCustomerKey;
    private SSECOSKeyManagementParams sseCOSKeyManagementParams;
    private int trafficLimit = 0;
    private PicOperations picOperations;

    public AbstractPutObjectRequest(String bucketName, String key, File file) {
        this.bucketName = bucketName;
        this.key = key;
        this.file = file;
    }

    public AbstractPutObjectRequest(String bucketName, String key, String redirectLocation) {
        this.bucketName = bucketName;
        this.key = key;
        this.redirectLocation = redirectLocation;
    }

    protected AbstractPutObjectRequest(String bucketName, String key, InputStream input, ObjectMetadata metadata) {
        this.bucketName = bucketName;
        this.key = key;
        this.inputStream = input;
        this.metadata = metadata;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public <T extends AbstractPutObjectRequest> T withBucketName(String bucketName) {
        this.setBucketName(bucketName);
        AbstractPutObjectRequest t = this;
        return (T)t;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public <T extends AbstractPutObjectRequest> T withKey(String key) {
        this.setKey(key);
        AbstractPutObjectRequest t = this;
        return (T)t;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public void setStorageClass(String storageClass) {
        this.storageClass = storageClass;
    }

    public <T extends AbstractPutObjectRequest> T withStorageClass(String storageClass) {
        this.setStorageClass(storageClass);
        AbstractPutObjectRequest t = this;
        return (T)t;
    }

    public void setStorageClass(StorageClass storageClass) {
        this.storageClass = storageClass.toString();
    }

    public <T extends AbstractPutObjectRequest> T withStorageClass(StorageClass storageClass) {
        this.setStorageClass(storageClass);
        AbstractPutObjectRequest t = this;
        return (T)t;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public void setFile(File file) {
        this.file = file;
    }

    public <T extends AbstractPutObjectRequest> T withFile(File file) {
        this.setFile(file);
        AbstractPutObjectRequest t = this;
        return (T)t;
    }

    public ObjectMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(ObjectMetadata metadata) {
        this.metadata = metadata;
    }

    public <T extends AbstractPutObjectRequest> T withMetadata(ObjectMetadata metadata) {
        this.setMetadata(metadata);
        AbstractPutObjectRequest t = this;
        return (T)t;
    }

    public CannedAccessControlList getCannedAcl() {
        return this.cannedAcl;
    }

    public void setCannedAcl(CannedAccessControlList cannedAcl) {
        this.cannedAcl = cannedAcl;
    }

    public <T extends AbstractPutObjectRequest> T withCannedAcl(CannedAccessControlList cannedAcl) {
        this.setCannedAcl(cannedAcl);
        AbstractPutObjectRequest t = this;
        return (T)t;
    }

    public AccessControlList getAccessControlList() {
        return this.accessControlList;
    }

    public void setAccessControlList(AccessControlList accessControlList) {
        this.accessControlList = accessControlList;
    }

    public <T extends AbstractPutObjectRequest> T withAccessControlList(AccessControlList accessControlList) {
        this.setAccessControlList(accessControlList);
        AbstractPutObjectRequest t = this;
        return (T)t;
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public <T extends AbstractPutObjectRequest> T withInputStream(InputStream inputStream) {
        this.setInputStream(inputStream);
        AbstractPutObjectRequest t = this;
        return (T)t;
    }

    public void setRedirectLocation(String redirectLocation) {
        this.redirectLocation = redirectLocation;
    }

    public String getRedirectLocation() {
        return this.redirectLocation;
    }

    public <T extends AbstractPutObjectRequest> T withRedirectLocation(String redirectLocation) {
        this.redirectLocation = redirectLocation;
        AbstractPutObjectRequest t = this;
        return (T)t;
    }

    @Override
    public SSECustomerKey getSSECustomerKey() {
        return this.sseCustomerKey;
    }

    public void setSSECustomerKey(SSECustomerKey sseKey) {
        if (sseKey != null && this.sseCOSKeyManagementParams != null) {
            throw new IllegalArgumentException("Either SSECustomerKey or SSECOSKeyManagementParams must not be set at the same time.");
        }
        this.sseCustomerKey = sseKey;
    }

    public <T extends AbstractPutObjectRequest> T withSSECustomerKey(SSECustomerKey sseKey) {
        this.setSSECustomerKey(sseKey);
        AbstractPutObjectRequest t = this;
        return (T)t;
    }

    @Override
    public SSECOSKeyManagementParams getSSECOSKeyManagementParams() {
        return this.sseCOSKeyManagementParams;
    }

    public void setSSECOSKeyManagementParams(SSECOSKeyManagementParams params) {
        if (params != null && this.sseCustomerKey != null) {
            throw new IllegalArgumentException("Either SSECustomerKey or SSECOSKeyManagementParams must not be set at the same time.");
        }
        this.sseCOSKeyManagementParams = params;
    }

    public <T extends AbstractPutObjectRequest> T withSSECOSKeyManagementParams(SSECOSKeyManagementParams sseCOSKeyManagementParams) {
        this.setSSECOSKeyManagementParams(sseCOSKeyManagementParams);
        AbstractPutObjectRequest t = this;
        return (T)t;
    }

    @Override
    public AbstractPutObjectRequest clone() {
        return (AbstractPutObjectRequest)super.clone();
    }

    protected final <T extends AbstractPutObjectRequest> T copyPutObjectBaseTo(T target) {
        this.copyBaseTo(target);
        ObjectMetadata metadata = this.getMetadata();
        return ((AbstractPutObjectRequest)((AbstractPutObjectRequest)((AbstractPutObjectRequest)((AbstractPutObjectRequest)((AbstractPutObjectRequest)((AbstractPutObjectRequest)((AbstractPutObjectRequest)target.withAccessControlList(this.getAccessControlList())).withCannedAcl(this.getCannedAcl())).withInputStream(this.getInputStream())).withMetadata(metadata == null ? null : metadata.clone())).withRedirectLocation(this.getRedirectLocation())).withStorageClass(this.getStorageClass())).withSSECOSKeyManagementParams(this.getSSECOSKeyManagementParams())).withSSECustomerKey(this.getSSECustomerKey());
    }

    public int getTrafficLimit() {
        return this.trafficLimit;
    }

    public void setTrafficLimit(int trafficLimit) {
        this.trafficLimit = trafficLimit;
    }

    public PicOperations getPicOperations() {
        return this.picOperations;
    }

    public void setPicOperations(PicOperations picOperations) {
        this.picOperations = picOperations;
    }
}

