/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.WaiterFactory;
import org.apache.commons.pool2.impl.AtomicIntegerFactory;
import org.apache.commons.pool2.impl.BaseGenericObjectPool;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.commons.pool2.impl.TestGenericObjectPool;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

class TestBaseGenericObjectPool {
    BaseGenericObjectPool<String> pool;
    TestGenericObjectPool.SimpleFactory factory;

    TestBaseGenericObjectPool() {
    }

    @BeforeEach
    public void setUp() {
        this.factory = new TestGenericObjectPool.SimpleFactory();
        this.pool = new GenericObjectPool((PooledObjectFactory)this.factory);
    }

    @AfterEach
    public void tearDown() {
        this.pool.close();
        this.pool = null;
        this.factory = null;
    }

    @Test
    void testActiveTimeStatistics() {
        for (int i = 0; i < 99; ++i) {
            this.pool.updateStatsReturn(Duration.ofMillis(i));
        }
        Assertions.assertEquals((double)49.0, (double)this.pool.getMeanActiveTimeMillis(), (double)Double.MIN_VALUE);
    }

    @Test
    void testBorrowWaitStatistics() {
        DefaultPooledObject p = (DefaultPooledObject)this.factory.makeObject();
        this.pool.updateStatsBorrow((PooledObject)p, Duration.ofMillis(10L));
        this.pool.updateStatsBorrow((PooledObject)p, Duration.ofMillis(20L));
        this.pool.updateStatsBorrow((PooledObject)p, Duration.ofMillis(20L));
        this.pool.updateStatsBorrow((PooledObject)p, Duration.ofMillis(30L));
        Assertions.assertEquals((double)20.0, (double)this.pool.getMeanBorrowWaitTimeMillis(), (double)Double.MIN_VALUE);
        Assertions.assertEquals((float)30.0f, (float)this.pool.getMaxBorrowWaitTimeMillis(), (float)0.0f);
    }

    void testBorrowWaitStatisticsMax() {
        DefaultPooledObject p = (DefaultPooledObject)this.factory.makeObject();
        Assertions.assertEquals((double)0.0, (double)this.pool.getMaxBorrowWaitTimeMillis(), (double)Double.MIN_VALUE);
        this.pool.updateStatsBorrow((PooledObject)p, Duration.ZERO);
        Assertions.assertEquals((double)0.0, (double)this.pool.getMaxBorrowWaitTimeMillis(), (double)Double.MIN_VALUE);
        this.pool.updateStatsBorrow((PooledObject)p, Duration.ofMillis(20L));
        Assertions.assertEquals((double)20.0, (double)this.pool.getMaxBorrowWaitTimeMillis(), (double)Double.MIN_VALUE);
        this.pool.updateStatsBorrow((PooledObject)p, Duration.ofMillis(20L));
        Assertions.assertEquals((double)20.0, (double)this.pool.getMaxBorrowWaitTimeMillis(), (double)Double.MIN_VALUE);
        this.pool.updateStatsBorrow((PooledObject)p, Duration.ofMillis(10L));
        Assertions.assertEquals((double)20.0, (double)this.pool.getMaxBorrowWaitTimeMillis(), (double)Double.MIN_VALUE);
    }

    @Test
    void testCollectDetailedStatisticsConfiguration() {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setCollectDetailedStatistics(false);
        try (GenericObjectPool testPool = new GenericObjectPool((PooledObjectFactory)this.factory, config);){
            Assertions.assertFalse((boolean)testPool.getCollectDetailedStatistics());
        }
        this.pool.setCollectDetailedStatistics(false);
        Assertions.assertFalse((boolean)this.pool.getCollectDetailedStatistics());
        this.pool.setCollectDetailedStatistics(true);
        Assertions.assertTrue((boolean)this.pool.getCollectDetailedStatistics());
    }

    @Test
    void testCollectDetailedStatisticsDefault() {
        Assertions.assertTrue((boolean)this.pool.getCollectDetailedStatistics());
    }

    @Test
    void testCollectDetailedStatisticsDisabled() throws Exception {
        this.pool.setCollectDetailedStatistics(false);
        DefaultPooledObject pooledObject = (DefaultPooledObject)this.factory.makeObject();
        long initialActiveTime = this.pool.getMeanActiveTimeMillis();
        long initialIdleTime = this.pool.getMeanIdleDuration().toMillis();
        long initialWaitTime = this.pool.getMeanBorrowWaitTimeMillis();
        long initialMaxWaitTime = this.pool.getMaxBorrowWaitTimeMillis();
        this.pool.updateStatsBorrow((PooledObject)pooledObject, Duration.ofMillis(100L));
        this.pool.updateStatsReturn(Duration.ofMillis(200L));
        Assertions.assertEquals((long)1L, (long)this.pool.getBorrowedCount());
        Assertions.assertEquals((long)1L, (long)this.pool.getReturnedCount());
        Assertions.assertEquals((long)initialActiveTime, (long)this.pool.getMeanActiveTimeMillis());
        Assertions.assertEquals((long)initialIdleTime, (long)this.pool.getMeanIdleDuration().toMillis());
        Assertions.assertEquals((long)initialWaitTime, (long)this.pool.getMeanBorrowWaitTimeMillis());
        Assertions.assertEquals((long)initialMaxWaitTime, (long)this.pool.getMaxBorrowWaitTimeMillis());
    }

    @Test
    void testCollectDetailedStatisticsEnabled() throws Exception {
        this.pool.setCollectDetailedStatistics(true);
        DefaultPooledObject pooledObject = (DefaultPooledObject)this.factory.makeObject();
        this.pool.updateStatsBorrow((PooledObject)pooledObject, Duration.ofMillis(100L));
        this.pool.updateStatsReturn(Duration.ofMillis(200L));
        Assertions.assertEquals((long)1L, (long)this.pool.getBorrowedCount());
        Assertions.assertEquals((long)1L, (long)this.pool.getReturnedCount());
        Assertions.assertEquals((long)200L, (long)this.pool.getMeanActiveTimeMillis());
        Assertions.assertEquals((long)100L, (long)this.pool.getMeanBorrowWaitTimeMillis());
        Assertions.assertEquals((long)100L, (long)this.pool.getMaxBorrowWaitTimeMillis());
    }

    @Test
    void testCollectDetailedStatisticsToggling() throws Exception {
        DefaultPooledObject pooledObject = (DefaultPooledObject)this.factory.makeObject();
        this.pool.setCollectDetailedStatistics(true);
        this.pool.updateStatsBorrow((PooledObject)pooledObject, Duration.ofMillis(50L));
        this.pool.updateStatsReturn(Duration.ofMillis(100L));
        Assertions.assertEquals((long)50L, (long)this.pool.getMeanBorrowWaitTimeMillis());
        Assertions.assertEquals((long)100L, (long)this.pool.getMeanActiveTimeMillis());
        this.pool.setCollectDetailedStatistics(false);
        this.pool.updateStatsBorrow((PooledObject)pooledObject, Duration.ofMillis(200L));
        this.pool.updateStatsReturn(Duration.ofMillis(300L));
        Assertions.assertEquals((long)50L, (long)this.pool.getMeanBorrowWaitTimeMillis());
        Assertions.assertEquals((long)100L, (long)this.pool.getMeanActiveTimeMillis());
        Assertions.assertEquals((long)2L, (long)this.pool.getBorrowedCount());
        Assertions.assertEquals((long)2L, (long)this.pool.getReturnedCount());
    }

    @Test
    void testDetailedStatisticsConfigIntegration() {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setCollectDetailedStatistics(false);
        try (GenericObjectPool testPool = new GenericObjectPool((PooledObjectFactory)this.factory, config);){
            Assertions.assertFalse((boolean)testPool.getCollectDetailedStatistics(), (String)"Pool should respect collectDetailedStatistics setting from config");
            String configString = config.toString();
            Assertions.assertTrue((boolean)configString.contains("collectDetailedStatistics"), (String)"Config toString should include collectDetailedStatistics property");
        }
    }

    @Test
    void testEvictionTimerMultiplePools() throws InterruptedException {
        AtomicIntegerFactory factory = new AtomicIntegerFactory();
        factory.setValidateLatency(50L);
        try (GenericObjectPool evictingPool = new GenericObjectPool((PooledObjectFactory)factory);){
            int i;
            evictingPool.setTimeBetweenEvictionRuns(Duration.ofMillis(100L));
            evictingPool.setNumTestsPerEvictionRun(5);
            evictingPool.setTestWhileIdle(true);
            evictingPool.setMinEvictableIdleTime(Duration.ofMillis(50L));
            for (i = 0; i < 10; ++i) {
                try {
                    evictingPool.addObject();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            for (i = 0; i < 1000; ++i) {
                GenericObjectPool nonEvictingPool = new GenericObjectPool((PooledObjectFactory)factory);
                nonEvictingPool.close();
            }
            Thread.sleep(1000L);
            Assertions.assertEquals((int)0, (int)evictingPool.getNumIdle());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    void testJMXRegistrationLatency() {
        int numPools = 1000;
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ArrayList<GenericObjectPool> pools = new ArrayList<GenericObjectPool>();
        try {
            for (int i = 0; i < 1000; ++i) {
                pools.add(new GenericObjectPool(new WaiterFactory(0L, 0L, 0L, 0L, 0L, 0L), new GenericObjectPoolConfig()));
            }
            ObjectName oname = ((GenericObjectPool)pools.get(999)).getJmxName();
            Assertions.assertEquals((int)1, (int)mbs.queryNames(oname, null).size());
        }
        finally {
            pools.forEach(GenericObjectPool::close);
        }
    }

    @Test
    void testStatsStoreCircularBuffer() throws Exception {
        DefaultPooledObject pooledObject = (DefaultPooledObject)this.factory.makeObject();
        int cacheSize = 100;
        for (int i = 0; i < 150; ++i) {
            this.pool.updateStatsBorrow((PooledObject)pooledObject, Duration.ofMillis(i));
            this.pool.updateStatsReturn(Duration.ofMillis(i * 2));
        }
        Assertions.assertTrue((this.pool.getMeanActiveTimeMillis() > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((this.pool.getMeanBorrowWaitTimeMillis() > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((this.pool.getMaxBorrowWaitTimeMillis() > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((this.pool.getMeanBorrowWaitTimeMillis() >= 50L ? 1 : 0) != 0);
    }

    @Test
    void testStatsStoreConcurrentAccess() throws Exception {
        int numThreads = 10;
        int operationsPerThread = 1000;
        ExecutorService executor = Executors.newFixedThreadPool(10);
        CountDownLatch startLatch = new CountDownLatch(1);
        CountDownLatch completeLatch = new CountDownLatch(10);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        int i = 0;
        while (i < 10) {
            int n = i++;
            futures.add(executor.submit(() -> {
                try {
                    DefaultPooledObject pooledObject = (DefaultPooledObject)this.factory.makeObject();
                    startLatch.await();
                    for (int j = 0; j < 1000; ++j) {
                        this.pool.updateStatsBorrow((PooledObject)pooledObject, Duration.ofMillis(threadId * 10 + j));
                        this.pool.updateStatsReturn(Duration.ofMillis(threadId * 20 + j));
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    completeLatch.countDown();
                }
                return null;
            }));
        }
        startLatch.countDown();
        Assertions.assertTrue((boolean)completeLatch.await(30L, TimeUnit.SECONDS), (String)"Concurrent test should complete within 30 seconds");
        for (Future future : futures) {
            future.get();
        }
        Assertions.assertEquals((long)10000L, (long)this.pool.getBorrowedCount());
        Assertions.assertEquals((long)10000L, (long)this.pool.getReturnedCount());
        Assertions.assertTrue((this.pool.getMeanActiveTimeMillis() >= 0L ? 1 : 0) != 0);
        Assertions.assertTrue((this.pool.getMeanBorrowWaitTimeMillis() >= 0L ? 1 : 0) != 0);
        Assertions.assertTrue((this.pool.getMaxBorrowWaitTimeMillis() >= 0L ? 1 : 0) != 0);
        executor.shutdown();
        Assertions.assertTrue((boolean)executor.awaitTermination(5L, TimeUnit.SECONDS));
    }
}

