/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.stat.interval;

import org.apache.commons.math4.core.jdkmath.JdkMath;
import org.apache.commons.math4.legacy.stat.interval.BinomialConfidenceInterval;
import org.apache.commons.math4.legacy.stat.interval.ConfidenceInterval;
import org.apache.commons.math4.legacy.stat.interval.IntervalUtils;
import org.apache.commons.statistics.distribution.NormalDistribution;

public class WilsonScoreInterval
implements BinomialConfidenceInterval {
    @Override
    public ConfidenceInterval createInterval(int numberOfTrials, int numberOfSuccesses, double confidenceLevel) {
        IntervalUtils.checkParameters(numberOfTrials, numberOfSuccesses, confidenceLevel);
        double alpha = (1.0 - confidenceLevel) / 2.0;
        NormalDistribution normalDistribution = NormalDistribution.of((double)0.0, (double)1.0);
        double z = normalDistribution.inverseSurvivalProbability(alpha);
        double zSquared = z * z;
        double oneOverNumTrials = 1.0 / (double)numberOfTrials;
        double zSquaredOverNumTrials = zSquared * oneOverNumTrials;
        double mean = oneOverNumTrials * (double)numberOfSuccesses;
        double factor = 1.0 / (1.0 + zSquaredOverNumTrials);
        double modifiedSuccessRatio = mean + zSquaredOverNumTrials / 2.0;
        double difference = z * JdkMath.sqrt((double)(oneOverNumTrials * mean * (1.0 - mean) + oneOverNumTrials * zSquaredOverNumTrials / 4.0));
        double lowerBound = factor * (modifiedSuccessRatio - difference);
        double upperBound = factor * (modifiedSuccessRatio + difference);
        return new ConfidenceInterval(lowerBound, upperBound, confidenceLevel);
    }
}

