/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.fitting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.math4.legacy.analysis.ParametricUnivariateFunction;
import org.apache.commons.math4.legacy.exception.OutOfRangeException;
import org.apache.commons.math4.legacy.exception.ZeroException;
import org.apache.commons.math4.legacy.fitting.AbstractCurveFitter;
import org.apache.commons.math4.legacy.fitting.WeightedObservedPoint;
import org.apache.commons.math4.legacy.fitting.leastsquares.LeastSquaresBuilder;
import org.apache.commons.math4.legacy.fitting.leastsquares.LeastSquaresProblem;
import org.apache.commons.math4.legacy.linear.DiagonalMatrix;

public class SimpleCurveFitter
extends AbstractCurveFitter {
    private final ParametricUnivariateFunction function;
    private final double[] initialGuess;
    private final ParameterGuesser guesser;
    private final int maxIter;

    protected SimpleCurveFitter(ParametricUnivariateFunction function, double[] initialGuess, ParameterGuesser guesser, int maxIter) {
        this.function = function;
        this.initialGuess = initialGuess;
        this.guesser = guesser;
        this.maxIter = maxIter;
    }

    public static SimpleCurveFitter create(ParametricUnivariateFunction f, double[] start) {
        return new SimpleCurveFitter(f, start, null, Integer.MAX_VALUE);
    }

    public static SimpleCurveFitter create(ParametricUnivariateFunction f, ParameterGuesser guesser) {
        return new SimpleCurveFitter(f, null, guesser, Integer.MAX_VALUE);
    }

    public SimpleCurveFitter withStartPoint(double[] newStart) {
        return new SimpleCurveFitter(this.function, (double[])newStart.clone(), null, this.maxIter);
    }

    public SimpleCurveFitter withMaxIterations(int newMaxIter) {
        return new SimpleCurveFitter(this.function, this.initialGuess, this.guesser, newMaxIter);
    }

    @Override
    protected LeastSquaresProblem getProblem(Collection<WeightedObservedPoint> observations) {
        int len = observations.size();
        double[] target = new double[len];
        double[] weights = new double[len];
        int count = 0;
        for (WeightedObservedPoint obs : observations) {
            target[count] = obs.getY();
            weights[count] = obs.getWeight();
            ++count;
        }
        AbstractCurveFitter.TheoreticalValuesFunction model = new AbstractCurveFitter.TheoreticalValuesFunction(this.function, observations);
        double[] startPoint = this.initialGuess != null ? this.initialGuess : this.guesser.guess(observations);
        return new LeastSquaresBuilder().maxEvaluations(Integer.MAX_VALUE).maxIterations(this.maxIter).start(startPoint).target(target).weight(new DiagonalMatrix(weights)).model(model.getModelFunction(), model.getModelFunctionJacobian()).build();
    }

    public static abstract class ParameterGuesser {
        private static final Comparator<WeightedObservedPoint> CMP = new Comparator<WeightedObservedPoint>(){

            @Override
            public int compare(WeightedObservedPoint p1, WeightedObservedPoint p2) {
                if (p1 == null && p2 == null) {
                    return 0;
                }
                if (p1 == null) {
                    return -1;
                }
                if (p2 == null) {
                    return 1;
                }
                int comp = Double.compare(p1.getX(), p2.getX());
                if (comp != 0) {
                    return comp;
                }
                comp = Double.compare(p1.getY(), p2.getY());
                if (comp != 0) {
                    return comp;
                }
                return Double.compare(p1.getWeight(), p2.getWeight());
            }
        };

        public abstract double[] guess(Collection<WeightedObservedPoint> var1);

        protected List<WeightedObservedPoint> sortObservations(Collection<WeightedObservedPoint> unsorted) {
            ArrayList<WeightedObservedPoint> observations = new ArrayList<WeightedObservedPoint>(unsorted);
            Collections.sort(observations, CMP);
            return observations;
        }

        protected int findMaxY(WeightedObservedPoint[] points) {
            int maxYIdx = 0;
            for (int i = 1; i < points.length; ++i) {
                if (!(points[i].getY() > points[maxYIdx].getY())) continue;
                maxYIdx = i;
            }
            return maxYIdx;
        }

        protected double interpolateXAtY(WeightedObservedPoint[] points, int startIdx, int idxStep, double y) {
            if (idxStep == 0) {
                throw new ZeroException();
            }
            WeightedObservedPoint[] twoPoints = this.getInterpolationPointsForY(points, startIdx, idxStep, y);
            WeightedObservedPoint p1 = twoPoints[0];
            WeightedObservedPoint p2 = twoPoints[1];
            if (p1.getY() == y) {
                return p1.getX();
            }
            if (p2.getY() == y) {
                return p2.getX();
            }
            return p1.getX() + (y - p1.getY()) * (p2.getX() - p1.getX()) / (p2.getY() - p1.getY());
        }

        private WeightedObservedPoint[] getInterpolationPointsForY(WeightedObservedPoint[] points, int startIdx, int idxStep, double y) {
            if (idxStep == 0) {
                throw new ZeroException();
            }
            int i = startIdx;
            while (idxStep < 0 ? i + idxStep >= 0 : i + idxStep < points.length) {
                WeightedObservedPoint p1 = points[i];
                WeightedObservedPoint p2 = points[i + idxStep];
                if (this.isBetween(y, p1.getY(), p2.getY())) {
                    if (idxStep < 0) {
                        return new WeightedObservedPoint[]{p2, p1};
                    }
                    return new WeightedObservedPoint[]{p1, p2};
                }
                i += idxStep;
            }
            throw new OutOfRangeException((Number)y, (Number)Double.NEGATIVE_INFINITY, (Number)Double.POSITIVE_INFINITY);
        }

        private boolean isBetween(double value, double boundary1, double boundary2) {
            return value >= boundary1 && value <= boundary2 || value >= boundary2 && value <= boundary1;
        }
    }
}

