/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.analysis.function;

import java.util.Arrays;
import org.apache.commons.math4.legacy.analysis.UnivariateFunction;
import org.apache.commons.math4.legacy.core.MathArrays;
import org.apache.commons.math4.legacy.exception.DimensionMismatchException;
import org.apache.commons.math4.legacy.exception.NoDataException;
import org.apache.commons.math4.legacy.exception.NonMonotonicSequenceException;
import org.apache.commons.math4.legacy.exception.NullArgumentException;

public class StepFunction
implements UnivariateFunction {
    private final double[] abscissa;
    private final double[] ordinate;

    public StepFunction(double[] x, double[] y) throws NullArgumentException, NoDataException, DimensionMismatchException, NonMonotonicSequenceException {
        if (x == null || y == null) {
            throw new NullArgumentException();
        }
        if (x.length == 0 || y.length == 0) {
            throw new NoDataException();
        }
        if (y.length != x.length) {
            throw new DimensionMismatchException(y.length, x.length);
        }
        MathArrays.checkOrder((double[])x);
        this.abscissa = Arrays.copyOf(x, x.length);
        this.ordinate = Arrays.copyOf(y, y.length);
    }

    @Override
    public double value(double x) {
        int index = Arrays.binarySearch(this.abscissa, x);
        double fx = 0.0;
        fx = index < -1 ? this.ordinate[-index - 2] : (index >= 0 ? this.ordinate[index] : this.ordinate[0]);
        return fx;
    }
}

