/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.analysis;

import org.apache.commons.math4.legacy.analysis.BivariateFunction;
import org.apache.commons.math4.legacy.analysis.MultivariateFunction;
import org.apache.commons.math4.legacy.analysis.MultivariateVectorFunction;
import org.apache.commons.math4.legacy.analysis.UnivariateFunction;
import org.apache.commons.math4.legacy.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math4.legacy.analysis.differentiation.MultivariateDifferentiableFunction;
import org.apache.commons.math4.legacy.analysis.differentiation.UnivariateDifferentiableFunction;
import org.apache.commons.math4.legacy.analysis.function.Identity;
import org.apache.commons.math4.legacy.exception.DimensionMismatchException;
import org.apache.commons.math4.legacy.exception.NumberIsTooLargeException;
import org.apache.commons.numbers.core.Sum;

public final class FunctionUtils {
    private FunctionUtils() {
    }

    public static UnivariateFunction compose(final UnivariateFunction ... f) {
        return new UnivariateFunction(){

            @Override
            public double value(double x) {
                double r = x;
                for (int i = f.length - 1; i >= 0; --i) {
                    r = f[i].value(r);
                }
                return r;
            }
        };
    }

    public static UnivariateDifferentiableFunction compose(final UnivariateDifferentiableFunction ... f) {
        return new UnivariateDifferentiableFunction(){

            @Override
            public double value(double t) {
                double r = t;
                for (int i = f.length - 1; i >= 0; --i) {
                    r = f[i].value(r);
                }
                return r;
            }

            @Override
            public DerivativeStructure value(DerivativeStructure t) {
                DerivativeStructure r = t;
                for (int i = f.length - 1; i >= 0; --i) {
                    r = f[i].value(r);
                }
                return r;
            }
        };
    }

    public static UnivariateFunction add(final UnivariateFunction ... f) {
        return new UnivariateFunction(){

            @Override
            public double value(double x) {
                double r = f[0].value(x);
                for (int i = 1; i < f.length; ++i) {
                    r += f[i].value(x);
                }
                return r;
            }
        };
    }

    public static UnivariateDifferentiableFunction add(final UnivariateDifferentiableFunction ... f) {
        return new UnivariateDifferentiableFunction(){

            @Override
            public double value(double t) {
                double r = f[0].value(t);
                for (int i = 1; i < f.length; ++i) {
                    r += f[i].value(t);
                }
                return r;
            }

            @Override
            public DerivativeStructure value(DerivativeStructure t) throws DimensionMismatchException {
                DerivativeStructure r = f[0].value(t);
                for (int i = 1; i < f.length; ++i) {
                    r = r.add(f[i].value(t));
                }
                return r;
            }
        };
    }

    public static UnivariateFunction multiply(final UnivariateFunction ... f) {
        return new UnivariateFunction(){

            @Override
            public double value(double x) {
                double r = f[0].value(x);
                for (int i = 1; i < f.length; ++i) {
                    r *= f[i].value(x);
                }
                return r;
            }
        };
    }

    public static UnivariateDifferentiableFunction multiply(final UnivariateDifferentiableFunction ... f) {
        return new UnivariateDifferentiableFunction(){

            @Override
            public double value(double t) {
                double r = f[0].value(t);
                for (int i = 1; i < f.length; ++i) {
                    r *= f[i].value(t);
                }
                return r;
            }

            @Override
            public DerivativeStructure value(DerivativeStructure t) {
                DerivativeStructure r = f[0].value(t);
                for (int i = 1; i < f.length; ++i) {
                    r = r.multiply(f[i].value(t));
                }
                return r;
            }
        };
    }

    public static UnivariateFunction combine(final BivariateFunction combiner, final UnivariateFunction f, final UnivariateFunction g) {
        return new UnivariateFunction(){

            @Override
            public double value(double x) {
                return combiner.value(f.value(x), g.value(x));
            }
        };
    }

    public static MultivariateFunction collector(final BivariateFunction combiner, final UnivariateFunction f, final double initialValue) {
        return new MultivariateFunction(){

            @Override
            public double value(double[] point) {
                double result = combiner.value(initialValue, f.value(point[0]));
                for (int i = 1; i < point.length; ++i) {
                    result = combiner.value(result, f.value(point[i]));
                }
                return result;
            }
        };
    }

    public static MultivariateFunction collector(BivariateFunction combiner, double initialValue) {
        return FunctionUtils.collector(combiner, new Identity(), initialValue);
    }

    public static UnivariateFunction fix1stArgument(final BivariateFunction f, final double fixed) {
        return new UnivariateFunction(){

            @Override
            public double value(double x) {
                return f.value(fixed, x);
            }
        };
    }

    public static UnivariateFunction fix2ndArgument(final BivariateFunction f, final double fixed) {
        return new UnivariateFunction(){

            @Override
            public double value(double x) {
                return f.value(x, fixed);
            }
        };
    }

    public static UnivariateDifferentiableFunction toDifferentiable(final UnivariateFunction f, final UnivariateFunction ... derivatives) {
        return new UnivariateDifferentiableFunction(){

            @Override
            public double value(double x) {
                return f.value(x);
            }

            @Override
            public DerivativeStructure value(DerivativeStructure x) {
                if (x.getOrder() > derivatives.length) {
                    throw new NumberIsTooLargeException((Number)x.getOrder(), (Number)derivatives.length, true);
                }
                double[] packed = new double[x.getOrder() + 1];
                packed[0] = f.value(x.getValue());
                for (int i = 0; i < x.getOrder(); ++i) {
                    packed[i + 1] = derivatives[i].value(x.getValue());
                }
                return x.compose(packed);
            }
        };
    }

    public static MultivariateDifferentiableFunction toDifferentiable(final MultivariateFunction f, final MultivariateVectorFunction gradient) {
        return new MultivariateDifferentiableFunction(){

            @Override
            public double value(double[] point) {
                return f.value(point);
            }

            @Override
            public DerivativeStructure value(DerivativeStructure[] point) {
                double[] dPoint = new double[point.length];
                for (int i = 0; i < point.length; ++i) {
                    dPoint[i] = point[i].getValue();
                    if (point[i].getOrder() <= 1) continue;
                    throw new NumberIsTooLargeException((Number)point[i].getOrder(), (Number)1, true);
                }
                double v = f.value(dPoint);
                double[] dv = gradient.value(dPoint);
                if (dv.length != point.length) {
                    throw new DimensionMismatchException(dv.length, point.length);
                }
                int parameters = point[0].getFreeParameters();
                double[] partials = new double[point.length];
                double[] packed = new double[parameters + 1];
                packed[0] = v;
                int[] orders = new int[parameters];
                for (int i = 0; i < parameters; ++i) {
                    orders[i] = 1;
                    for (int j = 0; j < point.length; ++j) {
                        partials[j] = point[j].getPartialDerivative(orders);
                    }
                    orders[i] = 0;
                    packed[i + 1] = Sum.ofProducts((double[])dv, (double[])partials).getAsDouble();
                }
                return new DerivativeStructure(parameters, 1, packed);
            }
        };
    }

    public static UnivariateFunction derivative(final UnivariateDifferentiableFunction f, final int order) {
        return new UnivariateFunction(){

            @Override
            public double value(double x) {
                DerivativeStructure dsX = new DerivativeStructure(1, order, 0, x);
                return f.value(dsX).getPartialDerivative(order);
            }
        };
    }

    public static MultivariateFunction derivative(final MultivariateDifferentiableFunction f, final int[] orders) {
        return new MultivariateFunction(){

            @Override
            public double value(double[] point) {
                int sumOrders = 0;
                for (int order : orders) {
                    sumOrders += order;
                }
                DerivativeStructure[] dsPoint = new DerivativeStructure[point.length];
                for (int i = 0; i < point.length; ++i) {
                    dsPoint[i] = new DerivativeStructure(point.length, sumOrders, i, point[i]);
                }
                return f.value(dsPoint).getPartialDerivative(orders);
            }
        };
    }
}

