/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.exception;

import org.apache.commons.math4.legacy.exception.MathIllegalNumberException;
import org.apache.commons.math4.legacy.exception.util.Localizable;
import org.apache.commons.math4.legacy.exception.util.LocalizedFormats;

public class NonMonotonicSequenceException
extends MathIllegalNumberException {
    private static final long serialVersionUID = 20210531L;
    private final boolean increasing;
    private final boolean strict;
    private final int index;
    private final Number previous;

    public NonMonotonicSequenceException(Number wrong, Number previous, int index) {
        this(wrong, previous, index, true, true);
    }

    public NonMonotonicSequenceException(Number wrong, Number previous, int index, boolean increasing, boolean strict) {
        super((Localizable)(increasing ? (strict ? LocalizedFormats.NOT_STRICTLY_INCREASING_SEQUENCE : LocalizedFormats.NOT_INCREASING_SEQUENCE) : (strict ? LocalizedFormats.NOT_STRICTLY_DECREASING_SEQUENCE : LocalizedFormats.NOT_DECREASING_SEQUENCE)), wrong, previous, index, index - 1);
        this.increasing = increasing;
        this.strict = strict;
        this.index = index;
        this.previous = previous;
    }

    public boolean getIncreasing() {
        return this.increasing;
    }

    public boolean getStrict() {
        return this.strict;
    }

    public int getIndex() {
        return this.index;
    }

    public Number getPrevious() {
        return this.previous;
    }
}

