/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.simple;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import org.apache.commons.logging.DummyException;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.PathableClassLoader;
import org.apache.commons.logging.PathableTestSuite;
import org.apache.commons.logging.impl.SimpleLog;
import org.apache.commons.logging.simple.DecoratedSimpleLog;
import org.apache.commons.logging.simple.DefaultConfigTestCase;
import org.apache.commons.logging.simple.LogRecord;

public class CustomConfigTestCase
extends DefaultConfigTestCase {
    protected List<LogRecord> expected;
    protected String[] testMessages = new String[]{"debug", "info", "warn", "error", "fatal"};

    public static Test suite() throws Exception {
        Class<CustomConfigTestCase> thisClass = CustomConfigTestCase.class;
        PathableClassLoader loader = new PathableClassLoader(null);
        loader.useExplicitLoader("junit.", Test.class.getClassLoader());
        loader.addLogicalLib("testclasses");
        loader.addLogicalLib("commons-logging");
        Class<?> testClass = loader.loadClass(thisClass.getName());
        return new PathableTestSuite(testClass, loader);
    }

    @Override
    protected void checkDecorated() {
        CustomConfigTestCase.assertNotNull((String)"Log exists", (Object)this.log);
        CustomConfigTestCase.assertEquals((String)"Log class", (String)"org.apache.commons.logging.simple.DecoratedSimpleLog", (String)this.log.getClass().getName());
        CustomConfigTestCase.assertTrue((boolean)this.log.isDebugEnabled());
        CustomConfigTestCase.assertTrue((boolean)this.log.isErrorEnabled());
        CustomConfigTestCase.assertTrue((boolean)this.log.isFatalEnabled());
        CustomConfigTestCase.assertTrue((boolean)this.log.isInfoEnabled());
        CustomConfigTestCase.assertFalse((boolean)this.log.isTraceEnabled());
        CustomConfigTestCase.assertTrue((boolean)this.log.isWarnEnabled());
        CustomConfigTestCase.assertEquals((int)2, (int)((SimpleLog)this.log).getLevel());
        this.checkDecoratedDateTime();
        CustomConfigTestCase.assertEquals((String)"DecoratedLogger", (String)((DecoratedSimpleLog)this.log).getLogName());
        this.checkShowDateTime();
        CustomConfigTestCase.assertTrue((boolean)((DecoratedSimpleLog)this.log).getShowShortName());
    }

    protected void checkDecoratedDateTime() {
        CustomConfigTestCase.assertEquals((String)"yyyy/MM/dd HH:mm:ss:SSS zzz", (String)((DecoratedSimpleLog)this.log).getDateTimeFormat());
    }

    protected void checkExpected() {
        List<LogRecord> acts = ((DecoratedSimpleLog)this.log).getCache();
        int n = 0;
        for (LogRecord exp : this.expected) {
            LogRecord act = acts.get(n++);
            CustomConfigTestCase.assertEquals((String)("Row " + n + " type"), (int)exp.type, (int)act.type);
            CustomConfigTestCase.assertEquals((String)("Row " + n + " message"), (Object)exp.message, (Object)act.message);
            CustomConfigTestCase.assertEquals((String)("Row " + n + " throwable"), (Object)exp.t, (Object)act.t);
        }
    }

    protected void checkShowDateTime() {
        CustomConfigTestCase.assertFalse((boolean)((DecoratedSimpleLog)this.log).getShowDateTime());
    }

    @Override
    protected void checkStandard() {
        this.checkDecorated();
    }

    protected void logExceptionMessages() {
        DummyException t = new DummyException();
        this.log.trace((Object)"trace", (Throwable)t);
        this.log.debug((Object)"debug", (Throwable)t);
        this.log.info((Object)"info", (Throwable)t);
        this.log.warn((Object)"warn", (Throwable)t);
        this.log.error((Object)"error", (Throwable)t);
        this.log.fatal((Object)"fatal", (Throwable)t);
        this.expected.add(new LogRecord(2, "debug", t));
        this.expected.add(new LogRecord(3, "info", t));
        this.expected.add(new LogRecord(4, "warn", t));
        this.expected.add(new LogRecord(5, "error", t));
        this.expected.add(new LogRecord(6, "fatal", t));
    }

    protected void logPlainMessages() {
        this.log.trace((Object)"trace");
        this.log.debug((Object)"debug");
        this.log.info((Object)"info");
        this.log.warn((Object)"warn");
        this.log.error((Object)"error");
        this.log.fatal((Object)"fatal");
        this.expected.add(new LogRecord(2, "debug", null));
        this.expected.add(new LogRecord(3, "info", null));
        this.expected.add(new LogRecord(4, "warn", null));
        this.expected.add(new LogRecord(5, "error", null));
        this.expected.add(new LogRecord(6, "fatal", null));
    }

    @Override
    public void setProperties() {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.simple.DecoratedSimpleLog");
        System.setProperty("org.apache.commons.logging.simplelog.defaultlog", "debug");
    }

    @Override
    public void setUp() throws Exception {
        LogFactory.releaseAll();
        this.setProperties();
        this.expected = new ArrayList<LogRecord>();
        this.setUpFactory();
        this.setUpLog("DecoratedLogger");
    }

    @Override
    public void tearDown() {
        super.tearDown();
        this.expected = null;
    }

    public void testExceptionMessages() throws Exception {
        ((DecoratedSimpleLog)this.log).clearCache();
        this.logExceptionMessages();
        this.checkExpected();
    }

    public void testPlainMessages() throws Exception {
        ((DecoratedSimpleLog)this.log).clearCache();
        this.logPlainMessages();
        this.checkExpected();
    }

    @Override
    public void testSerializable() throws Exception {
        ((DecoratedSimpleLog)this.log).clearCache();
        this.logPlainMessages();
        super.testSerializable();
        this.logExceptionMessages();
        this.checkExpected();
    }
}

