/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import org.apache.commons.lang3.RuntimeEnvironment;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class RuntimeEnvironmentTest {
    private static final String simpleEnviron = "PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\u0000HOSTNAME=d62718b69f37\u0000TERM=xterm\u0000HOME=/root\u0000";
    private static final String podmanEnviron = "PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\u0000HOSTNAME=d62718b69f37\u0000TERM=xterm\u0000container=podman\u0000HOME=/root\u0000";
    private static final String emptyContainer = "PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\u0000HOSTNAME=d62718b69f37\u0000TERM=xterm\u0000container=\u0000HOME=/root\u0000";
    @TempDir
    private Path tempDir;

    RuntimeEnvironmentTest() {
    }

    private static Arguments[] testIsContainer() {
        return new Arguments[]{Arguments.of((Object[])new Object[]{"in docker no file", simpleEnviron, null, false}), Arguments.of((Object[])new Object[]{"in docker with file", simpleEnviron, ".dockerenv", true}), Arguments.of((Object[])new Object[]{"in podman no file", podmanEnviron, "run/.containerenv", true}), Arguments.of((Object[])new Object[]{"in podman with file", simpleEnviron, "run/.containerenv", true}), Arguments.of((Object[])new Object[]{"in podman empty env var no file", emptyContainer, null, false}), Arguments.of((Object[])new Object[]{"in podman empty env var with file", emptyContainer, "run/.containerenv", false}), Arguments.of((Object[])new Object[]{"not in container", simpleEnviron, null, false}), Arguments.of((Object[])new Object[]{"pid1 error no file", null, null, false}), Arguments.of((Object[])new Object[]{"pid1 error docker file", null, ".dockerenv", true}), Arguments.of((Object[])new Object[]{"pid1 error podman file", null, ".dockerenv", true})};
    }

    private boolean doTestInContainer(String environ, String fileToCreate) throws IOException {
        Path testDir = this.tempDir.resolve(UUID.randomUUID().toString());
        Path pid1EnvironFile = testDir.resolve("proc/1/environ");
        Files.createDirectories(pid1EnvironFile.getParent(), new FileAttribute[0]);
        if (fileToCreate != null) {
            Path file = testDir.resolve(fileToCreate);
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            Files.createFile(file, new FileAttribute[0]);
        }
        if (environ != null) {
            Files.write(pid1EnvironFile, environ.getBytes(Charset.defaultCharset()), new OpenOption[0]);
        }
        return RuntimeEnvironment.inContainer((String)testDir.toString());
    }

    @ParameterizedTest
    @MethodSource
    void testIsContainer(String label, String environ, String fileToCreate, boolean expected) throws IOException {
        Assertions.assertEquals((Object)expected, (Object)this.doTestInContainer(environ, fileToCreate), (String)label);
    }
}

