/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.stream.Stream;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.LangAssertions;
import org.apache.commons.lang3.RandomUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class RandomUtilsTest
extends AbstractLangTest {
    private static final double DELTA = 1.0E-5;

    RandomUtilsTest() {
    }

    static Stream<RandomUtils> randomProvider() {
        return Stream.of(RandomUtils.secure(), RandomUtils.secureStrong(), RandomUtils.insecure());
    }

    @Test
    void testBoolean() {
        boolean result = RandomUtils.nextBoolean();
        Assertions.assertTrue((result || !result ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    void testBoolean(RandomUtils ru) {
        boolean result = ru.randomBoolean();
        Assertions.assertTrue((result || !result ? 1 : 0) != 0);
    }

    @Test
    void testConstructor() {
        Assertions.assertNotNull((Object)new RandomUtils());
    }

    @Test
    void testExtremeRangeDouble() {
        double result = RandomUtils.nextDouble((double)0.0, (double)Double.MAX_VALUE);
        Assertions.assertTrue((result >= 0.0 && result <= Double.MAX_VALUE ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    void testExtremeRangeDouble(RandomUtils ru) {
        double result = ru.randomDouble(0.0, Double.MAX_VALUE);
        Assertions.assertTrue((result >= 0.0 && result <= Double.MAX_VALUE ? 1 : 0) != 0);
    }

    @Test
    void testExtremeRangeFloat() {
        float result = RandomUtils.nextFloat((float)0.0f, (float)Float.MAX_VALUE);
        Assertions.assertTrue((result >= 0.0f && result <= Float.MAX_VALUE ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    void testExtremeRangeFloat(RandomUtils ru) {
        float result = ru.randomFloat(0.0f, Float.MAX_VALUE);
        Assertions.assertTrue((result >= 0.0f && result <= Float.MAX_VALUE ? 1 : 0) != 0);
    }

    @Test
    void testExtremeRangeInt() {
        int result = RandomUtils.nextInt((int)0, (int)Integer.MAX_VALUE);
        Assertions.assertTrue((result >= 0 ? 1 : 0) != 0);
        Assertions.assertTrue((result < Integer.MAX_VALUE ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    void testExtremeRangeInt(RandomUtils ru) {
        int result = ru.randomInt(0, Integer.MAX_VALUE);
        Assertions.assertTrue((result >= 0 ? 1 : 0) != 0);
        Assertions.assertTrue((result < Integer.MAX_VALUE ? 1 : 0) != 0);
    }

    @Test
    void testExtremeRangeLong() {
        long result = RandomUtils.nextLong((long)0L, (long)Long.MAX_VALUE);
        Assertions.assertTrue((result >= 0L ? 1 : 0) != 0);
        Assertions.assertTrue((result < Long.MAX_VALUE ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    void testExtremeRangeLong(RandomUtils ru) {
        long result = ru.randomLong(0L, Long.MAX_VALUE);
        Assertions.assertTrue((result >= 0L ? 1 : 0) != 0);
        Assertions.assertTrue((result < Long.MAX_VALUE ? 1 : 0) != 0);
    }

    @Test
    void testLargeValueRangeLong() {
        long startInclusive = 12900000000001L;
        long endExclusive = 12900000000016L;
        int n = 15000;
        for (int i = 0; i < 15000; ++i) {
            Assertions.assertNotEquals((long)12900000000016L, (long)RandomUtils.nextLong((long)12900000000001L, (long)12900000000016L));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    void testLargeValueRangeLong(RandomUtils ru) {
        long startInclusive = 12900000000001L;
        long endExclusive = 12900000000016L;
        int n = 15000;
        for (int i = 0; i < 15000; ++i) {
            Assertions.assertNotEquals((long)12900000000016L, (long)ru.randomLong(12900000000001L, 12900000000016L));
        }
    }

    @Test
    void testNextBytes() {
        byte[] result = RandomUtils.nextBytes((int)20);
        Assertions.assertEquals((int)20, (int)result.length);
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    void testNextBytes(RandomUtils ru) {
        byte[] result = ru.randomBytes(20);
        Assertions.assertEquals((int)20, (int)result.length);
    }

    @Test
    void testNextBytesNegative() {
        LangAssertions.assertIllegalArgumentException(() -> RandomUtils.nextBytes((int)-1));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    void testNextBytesNegative(RandomUtils ru) {
        LangAssertions.assertIllegalArgumentException(() -> ru.randomBytes(-1));
    }

    @Test
    void testNextDouble() {
        double result = RandomUtils.nextDouble((double)33.0, (double)42.0);
        Assertions.assertTrue((result >= 33.0 ? 1 : 0) != 0);
        Assertions.assertTrue((result < 42.0 ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    void testNextDouble(RandomUtils ru) {
        double result = ru.randomDouble(33.0, 42.0);
        Assertions.assertTrue((result >= 33.0 ? 1 : 0) != 0);
        Assertions.assertTrue((result < 42.0 ? 1 : 0) != 0);
    }

    @Test
    void testNextDoubleLowerGreaterUpper() {
        LangAssertions.assertIllegalArgumentException(() -> RandomUtils.nextDouble((double)2.0, (double)1.0));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    void testNextDoubleLowerGreaterUpper(RandomUtils ru) {
        LangAssertions.assertIllegalArgumentException(() -> ru.randomDouble(2.0, 1.0));
    }

    @Test
    void testNextDoubleMinimalRange() {
        Assertions.assertEquals((double)42.1, (double)RandomUtils.nextDouble((double)42.1, (double)42.1), (double)1.0E-5);
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    void testNextDoubleMinimalRange(RandomUtils ru) {
        Assertions.assertEquals((double)42.1, (double)ru.randomDouble(42.1, 42.1), (double)1.0E-5);
    }

    @Test
    void testNextDoubleNegative() {
        LangAssertions.assertIllegalArgumentException(() -> RandomUtils.nextDouble((double)-1.0, (double)1.0));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    void testNextDoubleNegative(RandomUtils ru) {
        LangAssertions.assertIllegalArgumentException(() -> ru.randomDouble(-1.0, 1.0));
    }

    @Test
    void testNextDoubleRandomResult() {
        double result = RandomUtils.nextDouble();
        Assertions.assertTrue((result >= 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((result < Double.MAX_VALUE ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    void testNextDoubleRandomResult(RandomUtils ru) {
        double result = ru.randomDouble();
        Assertions.assertTrue((result >= 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((result < Double.MAX_VALUE ? 1 : 0) != 0);
    }

    @Test
    void testNextFloat() {
        float result = RandomUtils.nextFloat((float)33.0f, (float)42.0f);
        Assertions.assertTrue((result >= 33.0f ? 1 : 0) != 0);
        Assertions.assertTrue((result < 42.0f ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    void testNextFloat(RandomUtils ru) {
        float result = ru.randomFloat(33.0f, 42.0f);
        Assertions.assertTrue((result >= 33.0f ? 1 : 0) != 0);
        Assertions.assertTrue((result < 42.0f ? 1 : 0) != 0);
    }

    @Test
    void testNextFloatLowerGreaterUpper() {
        LangAssertions.assertIllegalArgumentException(() -> RandomUtils.nextFloat((float)2.0f, (float)1.0f));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    void testNextFloatLowerGreaterUpper(RandomUtils ru) {
        LangAssertions.assertIllegalArgumentException(() -> ru.randomFloat(2.0f, 1.0f));
    }

    @Test
    void testNextFloatMinimalRange() {
        Assertions.assertEquals((double)42.1f, (double)RandomUtils.nextFloat((float)42.1f, (float)42.1f), (double)1.0E-5);
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    void testNextFloatMinimalRange(RandomUtils ru) {
        Assertions.assertEquals((double)42.1f, (double)ru.randomFloat(42.1f, 42.1f), (double)1.0E-5);
    }

    @Test
    void testNextFloatNegative() {
        LangAssertions.assertIllegalArgumentException(() -> RandomUtils.nextFloat((float)-1.0f, (float)1.0f));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    void testNextFloatNegative(RandomUtils ru) {
        LangAssertions.assertIllegalArgumentException(() -> ru.randomFloat(-1.0f, 1.0f));
    }

    @Test
    void testNextFloatRandomResult() {
        float result = RandomUtils.nextFloat();
        Assertions.assertTrue((result >= 0.0f ? 1 : 0) != 0);
        Assertions.assertTrue((result < Float.MAX_VALUE ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    void testNextFloatRandomResult(RandomUtils ru) {
        float result = ru.randomFloat();
        Assertions.assertTrue((result >= 0.0f ? 1 : 0) != 0);
        Assertions.assertTrue((result < Float.MAX_VALUE ? 1 : 0) != 0);
    }

    @Test
    void testNextInt() {
        int result = RandomUtils.nextInt((int)33, (int)42);
        Assertions.assertTrue((result >= 33 ? 1 : 0) != 0);
        Assertions.assertTrue((result < 42 ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    void testNextInt(RandomUtils ru) {
        int result = ru.randomInt(33, 42);
        Assertions.assertTrue((result >= 33 ? 1 : 0) != 0);
        Assertions.assertTrue((result < 42 ? 1 : 0) != 0);
    }

    @Test
    void testNextIntLowerGreaterUpper() {
        LangAssertions.assertIllegalArgumentException(() -> RandomUtils.nextInt((int)2, (int)1));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    void testNextIntLowerGreaterUpper(RandomUtils ru) {
        LangAssertions.assertIllegalArgumentException(() -> ru.randomInt(2, 1));
    }

    @Test
    void testNextIntMinimalRange() {
        Assertions.assertEquals((int)42, (int)RandomUtils.nextInt((int)42, (int)42));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    void testNextIntMinimalRange(RandomUtils ru) {
        Assertions.assertEquals((int)42, (int)ru.randomInt(42, 42));
    }

    @Test
    void testNextIntNegative() {
        LangAssertions.assertIllegalArgumentException(() -> RandomUtils.nextInt((int)-1, (int)1));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    void testNextIntNegative(RandomUtils ru) {
        LangAssertions.assertIllegalArgumentException(() -> ru.randomInt(-1, 1));
    }

    @Test
    void testNextIntRandomResult() {
        int randomResult = RandomUtils.nextInt();
        Assertions.assertTrue((randomResult > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((randomResult < Integer.MAX_VALUE ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    void testNextIntRandomResult(RandomUtils ru) {
        int randomResult = ru.randomInt();
        Assertions.assertTrue((randomResult > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((randomResult < Integer.MAX_VALUE ? 1 : 0) != 0);
    }

    @Test
    void testNextLong() {
        long result = RandomUtils.nextLong((long)33L, (long)42L);
        Assertions.assertTrue((result >= 33L ? 1 : 0) != 0);
        Assertions.assertTrue((result < 42L ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    void testNextLong(RandomUtils ru) {
        long result = ru.randomLong(33L, 42L);
        Assertions.assertTrue((result >= 33L ? 1 : 0) != 0);
        Assertions.assertTrue((result < 42L ? 1 : 0) != 0);
    }

    @Test
    void testNextLongLowerGreaterUpper() {
        LangAssertions.assertIllegalArgumentException(() -> RandomUtils.nextLong((long)2L, (long)1L));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    void testNextLongLowerGreaterUpper(RandomUtils ru) {
        LangAssertions.assertIllegalArgumentException(() -> ru.randomLong(2L, 1L));
    }

    @Test
    void testNextLongMinimalRange() {
        Assertions.assertEquals((long)42L, (long)RandomUtils.nextLong((long)42L, (long)42L));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    void testNextLongMinimalRange(RandomUtils ru) {
        Assertions.assertEquals((long)42L, (long)ru.randomLong(42L, 42L));
    }

    @Test
    void testNextLongNegative() {
        LangAssertions.assertIllegalArgumentException(() -> RandomUtils.nextLong((long)-1L, (long)1L));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    void testNextLongNegative(RandomUtils ru) {
        LangAssertions.assertIllegalArgumentException(() -> ru.randomLong(-1L, 1L));
    }

    @Test
    void testNextLongRandomResult() {
        long result = RandomUtils.nextLong();
        Assertions.assertTrue((result >= 0L ? 1 : 0) != 0);
        Assertions.assertTrue((result < Long.MAX_VALUE ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    void testNextLongRandomResult(RandomUtils ru) {
        long result = ru.randomLong();
        Assertions.assertTrue((result >= 0L ? 1 : 0) != 0);
        Assertions.assertTrue((result < Long.MAX_VALUE ? 1 : 0) != 0);
    }

    @Test
    void testZeroLengthNextBytes() {
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])RandomUtils.nextBytes((int)0));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    void testZeroLengthNextBytes(RandomUtils ru) {
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])ru.randomBytes(0));
    }
}

