/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.util.Collections;
import org.apache.commons.jexl3.AnnotationTest;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class BlockTest
extends JexlTestCase {
    public BlockTest() {
        super("BlockTest");
    }

    @Test
    void testBlockExecutesAll() {
        JexlScript e = this.JEXL.createScript("if (true) { x = 'Hello'; y = 'World';}");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)"Hello", (Object)jc.get("x"), (String)"First result is wrong");
        Assertions.assertEquals((Object)"World", (Object)jc.get("y"), (String)"Second result is wrong");
        Assertions.assertEquals((Object)"World", (Object)o, (String)"Block result is wrong");
    }

    @Test
    void testBlockLastExecuted01() {
        JexlScript e = this.JEXL.createScript("if (true) { x = 1; } else { x = 2; }");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)1, (Object)o, (String)"Block result is wrong");
    }

    @Test
    void testBlockLastExecuted02() {
        JexlScript e = this.JEXL.createScript("if (false) { x = 1; } else { x = 2; }");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)2, (Object)o, (String)"Block result is wrong");
    }

    @Test
    void testBlockSimple() {
        JexlScript e = this.JEXL.createScript("if (true) { 'hello'; }");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)"hello", (Object)o, (String)"Result is wrong");
    }

    @Test
    void testEmptyBlock() {
        JexlScript e = this.JEXL.createScript("if (true) { }");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assertions.assertNull((Object)o, (String)"Result is wrong");
    }

    @Test
    void testNestedBlock() {
        JexlScript e = this.JEXL.createScript("if (true) { x = 'hello'; y = 'world'; if (true) { x; } y; }");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)"world", (Object)o, (String)"Block result is wrong");
    }

    @Test
    void testSetVSBlock() {
        AnnotationTest.AnnotationContext jc = new AnnotationTest.AnnotationContext();
        JexlScript e = this.JEXL.createScript("let n = 41 @synchronized { n += 1; }");
        Object r = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)42, (Object)r);
        Assertions.assertEquals((int)1, (int)jc.getCount());
        Assertions.assertTrue((boolean)jc.getNames().contains("synchronized"));
        e = this.JEXL.createScript("let n = 41 @synchronized { n += 1 }");
        r = e.execute((JexlContext)jc);
        Assertions.assertEquals(Collections.singleton(42), (Object)r);
        Assertions.assertEquals((int)2, (int)jc.getCount());
        Assertions.assertTrue((boolean)jc.getNames().contains("synchronized"));
        e = this.JEXL.createScript("let n = 41 { n += 1 }");
        r = e.execute((JexlContext)jc);
        Assertions.assertEquals(Collections.singleton(42), (Object)r);
        e = this.JEXL.createScript("let n = 41 { n += 1; }");
        r = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)42, (Object)r);
        e = this.JEXL.createScript("{'A' : 1, 'B' : 42}['B']");
        r = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)42, (Object)r);
        e = this.JEXL.createScript("{ n = 42; }");
        r = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)42, (Object)r);
        e = this.JEXL.createScript("@synchronized(y) { n = 42; }", new String[]{"y"});
        r = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)42, (Object)r);
        e = this.JEXL.createScript("{ n = 42 }");
        r = e.execute((JexlContext)jc);
        Assertions.assertEquals(Collections.singleton(42), (Object)r);
        e = this.JEXL.createScript("@synchronized(z) { n = 42 }", new String[]{"z"});
        r = e.execute((JexlContext)jc);
        Assertions.assertEquals(Collections.singleton(42), (Object)r);
        e = this.JEXL.createScript("{ n = 41; m = 42 }");
        r = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)42, (Object)r);
        e = this.JEXL.createScript("{ 20 + 22; }");
        r = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)42, (Object)r);
        e = this.JEXL.createScript("@synchronized { 20 + 22; }");
        r = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)42, (Object)r);
        e = this.JEXL.createScript("{ 6 * 7 }");
        r = e.execute((JexlContext)jc);
        Assertions.assertEquals(Collections.singleton(42), (Object)r);
    }
}

