/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.jackson.nullable;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.std.ReferenceTypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.ReferenceType;
import java.io.IOException;
import org.openapitools.jackson.nullable.JsonNullable;

public class JsonNullableDeserializer
extends ReferenceTypeDeserializer<JsonNullable<Object>> {
    private static final long serialVersionUID = 1L;
    private boolean isStringDeserializer = false;

    public JsonNullableDeserializer(JavaType fullType, ValueInstantiator inst, TypeDeserializer typeDeser, JsonDeserializer<?> deser) {
        super(fullType, inst, typeDeser, deser);
        if (fullType instanceof ReferenceType && ((ReferenceType)fullType).getReferencedType() != null) {
            this.isStringDeserializer = ((ReferenceType)fullType).getReferencedType().isTypeOrSubTypeOf(String.class);
        }
    }

    public JsonNullable<Object> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String str;
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.VALUE_STRING && !this.isStringDeserializer && (str = p.getText().trim()).isEmpty()) {
            return JsonNullable.undefined();
        }
        return (JsonNullable)super.deserialize(p, ctxt);
    }

    public JsonNullableDeserializer withResolved(TypeDeserializer typeDeser, JsonDeserializer<?> valueDeser) {
        return new JsonNullableDeserializer(this._fullType, this._valueInstantiator, typeDeser, valueDeser);
    }

    public Object getAbsentValue(DeserializationContext ctxt) {
        return JsonNullable.undefined();
    }

    public JsonNullable<Object> getNullValue(DeserializationContext ctxt) {
        return JsonNullable.of(null);
    }

    public Object getEmptyValue(DeserializationContext ctxt) {
        return JsonNullable.undefined();
    }

    public JsonNullable<Object> referenceValue(Object contents) {
        return JsonNullable.of(contents);
    }

    public Object getReferenced(JsonNullable<Object> reference) {
        return reference.get();
    }

    public JsonNullable<Object> updateReference(JsonNullable<Object> reference, Object contents) {
        return JsonNullable.of(contents);
    }

    public Boolean supportsUpdate(DeserializationConfig config) {
        return Boolean.TRUE;
    }
}

