/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.server.common.service.config;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.internal.config.ConfigEntry;
import org.apache.celeborn.server.common.service.config.DynamicConfig;
import org.apache.celeborn.server.common.service.model.ClusterSystemConfig;
import org.apache.celeborn.server.common.service.model.ClusterTag;

public class SystemConfig
extends DynamicConfig {
    private final CelebornConf celebornConf;

    public SystemConfig(CelebornConf celebornConf) {
        this.celebornConf = celebornConf;
        this.configs = new HashMap();
    }

    @Override
    public DynamicConfig getParentLevelConfig() {
        return null;
    }

    @Override
    public <T, V> T getValue(String configKey, ConfigEntry<V> configEntry, Class<T> finalType, DynamicConfig.ConfigType configType) {
        T formatValue;
        String configValue = (String)this.configs.get(configKey);
        T t = formatValue = configValue != null ? (T)this.formatValue(configKey, configValue, finalType, configType) : null;
        if (formatValue == null && configEntry != null) {
            return SystemConfig.convert(finalType, this.celebornConf.get(configEntry).toString());
        }
        return formatValue;
    }

    public void setConfigs(Map<String, String> configs) {
        this.configs = configs;
    }

    public void setConfigs(List<ClusterSystemConfig> configs) {
        HashMap<String, String> newConfigs = new HashMap<String, String>();
        for (ClusterSystemConfig c : configs) {
            newConfigs.put(c.getConfigKey(), c.getConfigValue());
        }
        this.configs = newConfigs;
    }

    public void setTags(Map<String, Set<String>> tags) {
        this.tags = tags;
    }

    public void setTags(List<ClusterTag> tags) {
        HashMap<String, Set> newTags = new HashMap<String, Set>();
        for (ClusterTag t : tags) {
            newTags.computeIfAbsent(t.getTag(), k -> new HashSet()).add(t.getWorkerId());
        }
        this.tags = newTags;
    }

    @Override
    protected Map<String, Set<String>> currentTags() {
        return this.tags;
    }
}

