/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.util;

import java.io.IOException;
import java.io.InputStream;
import org.apache.celeborn.shaded.io.netty.buffer.ByteBuf;
import org.apache.celeborn.shaded.io.netty.buffer.ByteBufHolder;
import org.apache.celeborn.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.celeborn.shaded.io.netty.handler.logging.LogLevel;
import org.apache.celeborn.shaded.io.netty.handler.logging.LoggingHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyLogger {
    private static final Logger logger = LoggerFactory.getLogger(NettyLogger.class);
    private final LoggingHandler loggingHandler = logger.isTraceEnabled() ? new LoggingHandler(NettyLogger.class, LogLevel.TRACE) : (logger.isDebugEnabled() ? new NoContentLoggingHandler(NettyLogger.class, LogLevel.DEBUG) : null);

    public LoggingHandler getLoggingHandler() {
        return this.loggingHandler;
    }

    private static class NoContentLoggingHandler
    extends LoggingHandler {
        NoContentLoggingHandler(Class<?> clazz, LogLevel level) {
            super(clazz, level);
        }

        @Override
        protected String format(ChannelHandlerContext ctx, String eventName, Object arg) {
            if (arg instanceof ByteBuf) {
                return this.format(ctx, eventName) + " " + ((ByteBuf)arg).readableBytes() + "B";
            }
            if (arg instanceof ByteBufHolder) {
                return this.format(ctx, eventName) + " " + ((ByteBufHolder)arg).content().readableBytes() + "B";
            }
            if (arg instanceof InputStream) {
                int available = -1;
                try {
                    available = ((InputStream)arg).available();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return this.format(ctx, eventName, arg) + " " + available + "B";
            }
            return super.format(ctx, eventName, arg);
        }
    }
}

