/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.plugin.flink.fallback;

import java.util.List;
import java.util.Optional;
import org.apache.celeborn.client.LifecycleManager;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.exception.CelebornIOException;
import org.apache.celeborn.common.protocol.FallbackPolicy;
import org.apache.celeborn.plugin.flink.fallback.ShuffleFallbackPolicy;
import org.apache.celeborn.plugin.flink.fallback.ShuffleFallbackPolicyFactory;
import org.apache.flink.runtime.shuffle.JobShuffleContext;

public class ShuffleFallbackPolicyRunner {
    private static final List<ShuffleFallbackPolicy> FALLBACK_POLICIES = ShuffleFallbackPolicyFactory.getShuffleFallbackPolicies();

    public static Optional<ShuffleFallbackPolicy> getActivatedFallbackPolicy(JobShuffleContext shuffleContext, CelebornConf celebornConf, LifecycleManager lifecycleManager) throws CelebornIOException {
        Optional<ShuffleFallbackPolicy> fallbackPolicy = FALLBACK_POLICIES.stream().filter(shuffleFallbackPolicy -> shuffleFallbackPolicy.needFallback(shuffleContext, celebornConf, lifecycleManager)).findFirst();
        if (fallbackPolicy.isPresent() && FallbackPolicy.NEVER.equals((Object)celebornConf.flinkShuffleFallbackPolicy())) {
            throw new CelebornIOException("Fallback to flink built-in shuffle implementation is prohibited.");
        }
        return fallbackPolicy;
    }
}

