/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.operations.userdefined;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Statement;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.stress.generate.Distribution;
import org.apache.cassandra.stress.generate.DistributionFixed;
import org.apache.cassandra.stress.generate.PartitionGenerator;
import org.apache.cassandra.stress.generate.PartitionIterator;
import org.apache.cassandra.stress.generate.Row;
import org.apache.cassandra.stress.generate.SeedManager;
import org.apache.cassandra.stress.operations.PartitionOperation;
import org.apache.cassandra.stress.operations.userdefined.SchemaStatement;
import org.apache.cassandra.stress.settings.StressSettings;
import org.apache.cassandra.stress.util.JavaDriverClient;
import org.apache.cassandra.stress.util.ThriftClient;
import org.apache.cassandra.stress.util.Timer;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.ThriftConversion;

public class SchemaQuery
extends SchemaStatement {
    final ArgSelect argSelect;
    final Object[][] randomBuffer;
    final Random random = new Random();

    public SchemaQuery(Timer timer, StressSettings settings, PartitionGenerator generator, SeedManager seedManager, Integer thriftId, PreparedStatement statement, ConsistencyLevel cl, ArgSelect argSelect) {
        super(timer, settings, new PartitionOperation.DataSpec(generator, seedManager, (Distribution)new DistributionFixed(1L), settings.insert.rowPopulationRatio.get(), argSelect == ArgSelect.MULTIROW ? statement.getVariables().size() : 1), statement, thriftId, cl);
        this.argSelect = argSelect;
        this.randomBuffer = new Object[this.argumentIndex.length][this.argumentIndex.length];
    }

    private int fillRandom() {
        int c = 0;
        PartitionIterator iterator = (PartitionIterator)this.partitions.get(0);
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            Object[] randomBufferRow = this.randomBuffer[c++];
            for (int i = 0; i < this.argumentIndex.length; ++i) {
                randomBufferRow[i] = row.get(this.argumentIndex[i]);
            }
            if (c < this.randomBuffer.length) continue;
            break;
        }
        assert (c > 0);
        return c;
    }

    BoundStatement bindArgs() {
        switch (this.argSelect) {
            case MULTIROW: {
                int c = this.fillRandom();
                for (int i = 0; i < this.argumentIndex.length; ++i) {
                    int argIndex = this.argumentIndex[i];
                    this.bindBuffer[i] = this.randomBuffer[argIndex < 0 ? 0 : this.random.nextInt(c)][i];
                }
                return this.statement.bind(this.bindBuffer);
            }
            case SAMEROW: {
                return this.bindRow((Row)((PartitionIterator)this.partitions.get(0)).next());
            }
        }
        throw new IllegalStateException();
    }

    List<ByteBuffer> thriftArgs() {
        switch (this.argSelect) {
            case MULTIROW: {
                ArrayList<ByteBuffer> args = new ArrayList<ByteBuffer>();
                int c = this.fillRandom();
                for (int i = 0; i < this.argumentIndex.length; ++i) {
                    int argIndex = this.argumentIndex[i];
                    args.add(this.spec.partitionGenerator.convert(argIndex, this.randomBuffer[argIndex < 0 ? 0 : this.random.nextInt(c)][i]));
                }
                return args;
            }
            case SAMEROW: {
                return this.thriftRowArgs((Row)((PartitionIterator)this.partitions.get(0)).next());
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void run(JavaDriverClient client) throws IOException {
        this.timeWithRetry(new JavaDriverRun(client));
    }

    @Override
    public void run(ThriftClient client) throws IOException {
        this.timeWithRetry(new ThriftRun(client));
    }

    private class ThriftRun
    extends SchemaStatement.Runner {
        final ThriftClient client;

        private ThriftRun(ThriftClient client) {
            super(SchemaQuery.this);
            this.client = client;
        }

        @Override
        public boolean run() throws Exception {
            CqlResult rs = this.client.execute_prepared_cql3_query(SchemaQuery.this.thriftId, ((PartitionIterator)SchemaQuery.this.partitions.get(0)).getToken(), SchemaQuery.this.thriftArgs(), ThriftConversion.toThrift((ConsistencyLevel)SchemaQuery.this.cl));
            this.rowCount = rs.getRowsSize();
            this.partitionCount = Math.min(1, this.rowCount);
            return true;
        }
    }

    private class JavaDriverRun
    extends SchemaStatement.Runner {
        final JavaDriverClient client;

        private JavaDriverRun(JavaDriverClient client) {
            super(SchemaQuery.this);
            this.client = client;
        }

        @Override
        public boolean run() throws Exception {
            ResultSet rs = this.client.getSession().execute((Statement)SchemaQuery.this.bindArgs());
            this.rowCount = rs.all().size();
            this.partitionCount = Math.min(1, this.rowCount);
            return true;
        }
    }

    public static enum ArgSelect {
        MULTIROW,
        SAMEROW;

    }
}

