/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.operations.predefined;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.stress.Operation;
import org.apache.cassandra.stress.generate.PartitionGenerator;
import org.apache.cassandra.stress.generate.SeedManager;
import org.apache.cassandra.stress.operations.predefined.PredefinedOperation;
import org.apache.cassandra.stress.settings.Command;
import org.apache.cassandra.stress.settings.StressSettings;
import org.apache.cassandra.stress.util.ThriftClient;
import org.apache.cassandra.stress.util.Timer;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.SlicePredicate;

public class ThriftCounterGetter
extends PredefinedOperation {
    public ThriftCounterGetter(Timer timer, PartitionGenerator generator, SeedManager seedManager, StressSettings settings) {
        super(Command.COUNTER_READ, timer, generator, seedManager, settings);
    }

    @Override
    public void run(final ThriftClient client) throws IOException {
        final SlicePredicate predicate = this.select().predicate();
        final ByteBuffer key = this.getKey();
        this.timeWithRetry(new Operation.RunOp(){

            @Override
            public boolean run() throws Exception {
                List<ColumnOrSuperColumn> r = client.get_slice(key, new ColumnParent(ThriftCounterGetter.this.type.table), predicate, ThriftCounterGetter.this.settings.command.consistencyLevel);
                return r != null && r.size() > 0;
            }

            @Override
            public int partitionCount() {
                return 1;
            }

            @Override
            public int rowCount() {
                return 1;
            }
        });
    }
}

