/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.File;
import java.io.IOException;
import java.util.zip.CRC32;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.DataIntegrityMetadata;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Throwables;

public class ChecksummedRandomAccessReader
extends RandomAccessReader {
    private final DataIntegrityMetadata.ChecksumValidator validator;

    private ChecksummedRandomAccessReader(Builder builder) {
        super(builder);
        this.validator = builder.validator;
    }

    @Override
    protected void reBufferStandard() {
        int n;
        long desiredPosition = this.current();
        this.bufferOffset = desiredPosition / (long)this.buffer.capacity() * (long)this.buffer.capacity();
        this.buffer.clear();
        long position = this.bufferOffset;
        while (this.buffer.hasRemaining() && (n = this.channel.read(this.buffer, position)) >= 0) {
            position += (long)n;
        }
        this.buffer.flip();
        try {
            this.validator.validate(ByteBufferUtil.getArray(this.buffer), 0, this.buffer.remaining());
        }
        catch (IOException e) {
            throw new CorruptFileException(e, this.channel.filePath());
        }
        this.buffer.position((int)(desiredPosition - this.bufferOffset));
    }

    @Override
    protected void reBufferMmap() {
        throw new AssertionError((Object)"Unsupported operation");
    }

    @Override
    public void seek(long newPosition) {
        this.validator.seek(newPosition);
        super.seek(newPosition);
    }

    @Override
    public void close() {
        Throwables.DiscreteAction[] discreteActionArray = new Throwables.DiscreteAction[3];
        discreteActionArray[0] = () -> super.close();
        discreteActionArray[1] = this.validator::close;
        discreteActionArray[2] = this.channel::close;
        Throwables.perform(this.channel.filePath(), Throwables.FileOpType.READ, discreteActionArray);
    }

    public static final class Builder
    extends RandomAccessReader.Builder {
        private final DataIntegrityMetadata.ChecksumValidator validator;

        public Builder(File file, File crcFile) throws IOException {
            super(new ChannelProxy(file));
            this.validator = new DataIntegrityMetadata.ChecksumValidator(new CRC32(), RandomAccessReader.open(crcFile), file.getPath());
            super.bufferSize(this.validator.chunkSize).bufferType(BufferType.ON_HEAP);
        }

        @Override
        public RandomAccessReader build() {
            return new ChecksummedRandomAccessReader(this);
        }
    }

    public static class CorruptFileException
    extends RuntimeException {
        public final String filePath;

        public CorruptFileException(Exception cause, String filePath) {
            super(cause);
            this.filePath = filePath;
        }
    }
}

