/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.lifecycle;

import java.io.File;
import java.io.IOException;
import org.apache.cassandra.db.lifecycle.LogRecord;
import org.apache.cassandra.db.lifecycle.LogTransaction;
import org.apache.cassandra.io.FSError;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.NativeLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LogReplica
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(LogReplica.class);
    private final File file;
    private int folderDescriptor;

    static LogReplica create(File folder, String fileName) {
        int folderFD = NativeLibrary.tryOpenDirectory(folder.getPath());
        if (folderFD == -1 && !FBUtilities.isWindows()) {
            throw new FSReadError((Throwable)new IOException(String.format("Invalid folder descriptor trying to create log replica %s", folder.getPath())), folder.getPath());
        }
        return new LogReplica(new File(fileName), folderFD);
    }

    static LogReplica open(File file) {
        int folderFD = NativeLibrary.tryOpenDirectory(file.getParentFile().getPath());
        if (folderFD == -1 && !FBUtilities.isWindows()) {
            throw new FSReadError((Throwable)new IOException(String.format("Invalid folder descriptor trying to create log replica %s", file.getParentFile().getPath())), file.getParentFile().getPath());
        }
        return new LogReplica(file, folderFD);
    }

    LogReplica(File file, int folderDescriptor) {
        this.file = file;
        this.folderDescriptor = folderDescriptor;
    }

    File file() {
        return this.file;
    }

    void append(LogRecord record) {
        boolean existed = this.exists();
        try {
            FileUtils.appendAndSync(this.file, record.toString());
        }
        catch (FSError e) {
            logger.error("Failed to sync file {}", (Object)this.file, (Object)e);
            FileUtils.handleFSErrorAndPropagate(e);
        }
        if (!existed) {
            this.syncFolder();
        }
    }

    void syncFolder() {
        try {
            if (this.folderDescriptor >= 0) {
                NativeLibrary.trySync(this.folderDescriptor);
            }
        }
        catch (FSError e) {
            logger.error("Failed to sync directory descriptor {}", (Object)this.folderDescriptor, (Object)e);
            FileUtils.handleFSErrorAndPropagate(e);
        }
    }

    void delete() {
        LogTransaction.delete(this.file);
        this.syncFolder();
    }

    boolean exists() {
        return this.file.exists();
    }

    @Override
    public void close() {
        if (this.folderDescriptor >= 0) {
            NativeLibrary.tryCloseFD(this.folderDescriptor);
            this.folderDescriptor = -1;
        }
    }

    public String toString() {
        return String.format("[%s] ", this.file);
    }
}

