/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsEngineProvider;
import org.bouncycastle.crypto.internal.EngineProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FipsRegister {
    private static final Map<FipsAlgorithm, EngineProvider> providerMap = new HashMap<FipsAlgorithm, EngineProvider>();

    FipsRegister() {
    }

    public static void registerEngineProvider(FipsAlgorithm fipsAlgorithm, FipsEngineProvider fipsEngineProvider) {
        if (fipsAlgorithm == null || fipsEngineProvider == null) {
            throw new IllegalArgumentException("Arguments cannot be null");
        }
        providerMap.put(fipsAlgorithm, fipsEngineProvider);
    }

    static <T> EngineProvider<T> getProvider(FipsAlgorithm fipsAlgorithm) {
        return providerMap.get(fipsAlgorithm);
    }
}

