/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;

public final class NestHost
extends Attribute {
    private int host_class_index;

    public NestHost(NestHost c) {
        this(c.getNameIndex(), c.getLength(), c.getHostClassIndex(), c.getConstantPool());
    }

    public NestHost(int name_index, int length, int host_class_index, ConstantPool constant_pool) {
        super((byte)26, name_index, length, constant_pool);
        this.host_class_index = host_class_index;
    }

    NestHost(int name_index, int length, DataInput input, ConstantPool constant_pool) throws IOException {
        this(name_index, length, 0, constant_pool);
        this.host_class_index = input.readUnsignedShort();
    }

    @Override
    public void accept(Visitor v) {
        v.visitNestHost(this);
    }

    @Override
    public void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.host_class_index);
    }

    public int getHostClassIndex() {
        return this.host_class_index;
    }

    public void setHostClassIndex(int host_class_index) {
        this.host_class_index = host_class_index;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("NestHost: ");
        String class_name = super.getConstantPool().getConstantString(this.host_class_index, (byte)7);
        buf.append(Utility.compactClassName(class_name, false));
        return buf.toString();
    }

    @Override
    public Attribute copy(ConstantPool _constant_pool) {
        NestHost c = (NestHost)this.clone();
        c.setConstantPool(_constant_pool);
        return c;
    }
}

