/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.siunitx;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.UserNumber;
import com.dickimawbooks.texparserlib.latex.siunitx.SIPrefixCs;
import com.dickimawbooks.texparserlib.latex.siunitx.SIUnitCs;
import com.dickimawbooks.texparserlib.latex.siunitx.SIunitxSty;
import java.io.IOException;

public class SiPower
extends ControlSequence {
    protected SIunitxSty sty;
    private int power;

    public SiPower(SIunitxSty sIunitxSty, String string, int n) {
        super(string);
        this.sty = sIunitxSty;
        this.power = n;
    }

    @Override
    public Object clone() {
        return new SiPower(this.sty, this.getName(), this.power);
    }

    public int getPower() {
        return this.power;
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = teXObjectList.peekStack();
        if (teXObject instanceof SIUnitCs || teXObject instanceof SIPrefixCs) {
            teXObjectList.push(this.sty.createUnitSep(teXParser));
        }
        teXObjectList.push(new UserNumber(this.power));
        if (teXParser.isMathMode()) {
            teXObjectList.push(teXParser.getListener().createSpChar());
        } else {
            teXObjectList.push(new TeXCsRef("textsuperscript"));
        }
    }
}

