/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.auxfile;

import com.dickimawbooks.texparserlib.AssignedControlSequence;
import com.dickimawbooks.texparserlib.CatCodeChanger;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Ignoreable;
import com.dickimawbooks.texparserlib.TeXApp;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.Writeable;
import com.dickimawbooks.texparserlib.auxfile.AuxActionCommand;
import com.dickimawbooks.texparserlib.auxfile.AuxCommand;
import com.dickimawbooks.texparserlib.auxfile.AuxData;
import com.dickimawbooks.texparserlib.auxfile.AuxIgnoreable;
import com.dickimawbooks.texparserlib.auxfile.AuxProvideCommand;
import com.dickimawbooks.texparserlib.auxfile.CiteInfo;
import com.dickimawbooks.texparserlib.auxfile.DivisionInfo;
import com.dickimawbooks.texparserlib.auxfile.LabelInfo;
import com.dickimawbooks.texparserlib.generic.DefaultTeXParserListener;
import com.dickimawbooks.texparserlib.latex.Input;
import com.dickimawbooks.texparserlib.primitives.Primitive;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Vector;

public class AuxParser
extends DefaultTeXParserListener
implements Writeable {
    private Vector<AuxData> auxData;
    private boolean saveDivisions = false;
    protected Vector<DivisionInfo> divisionData;
    private boolean saveLabels = false;
    protected HashMap<String, LabelInfo> labelData;
    private boolean saveCites = false;
    protected HashMap<String, CiteInfo> citeData;
    protected Vector<CiteInfo> citeList;
    private TeXApp texApp;
    private Charset charset = null;
    private String labelPrefix = null;
    private boolean allowCatChangers = true;

    public AuxParser(TeXApp teXApp) throws IOException {
        this(teXApp, null);
    }

    public AuxParser(TeXApp teXApp, Charset charset) throws IOException {
        this(teXApp, charset, null);
    }

    public AuxParser(TeXApp teXApp, Charset charset, String string) throws IOException {
        super(null);
        this.texApp = teXApp;
        this.charset = charset;
        this.labelPrefix = string;
        this.setWriteable(this);
        this.auxData = new Vector();
    }

    @Override
    public TeXApp getTeXApp() {
        return this.texApp;
    }

    public TeXParser parseAuxFile(File file) throws IOException {
        return this.parseAuxFile(file, null);
    }

    public TeXParser parseAuxFile(File file, Charset charset) throws IOException {
        TeXParser teXParser = new TeXParser(this);
        this.parseAuxFile(teXParser, file, charset);
        return teXParser;
    }

    public void parseAuxFile(TeXParser teXParser, File file) throws IOException {
        this.parseAuxFile(teXParser, file, null);
    }

    public void parseAuxFile(TeXParser teXParser, File file, Charset charset) throws IOException {
        if (charset != null) {
            this.charset = charset;
        }
        int n = teXParser.getCatCode(64);
        teXParser.setCatCode(64, 11);
        teXParser.parse(file);
        teXParser.setCatCode(64, n);
    }

    public String getLabelPrefix() {
        return this.labelPrefix;
    }

    @Override
    protected void addPredefined() {
        super.addPredefined();
        this.putControlSequence(new Input("@input", 1, false));
        this.addAuxCommand("newlabel", 2, this.labelPrefix);
        this.addAuxCommand("bibstyle", 1);
        this.addAuxCommand("citation", 1);
        this.addAuxCommand("bibdata", 1);
        this.addAuxCommand("bibcite", 2, this.labelPrefix);
        this.putControlSequence(new AuxProvideCommand());
        this.addAuxCommand("@writefile", 2);
        this.putControlSequence(new AuxIgnoreable("selectlanguage", true, new boolean[]{true}));
    }

    public void addAuxCommand(String string, int n) {
        this.addAuxCommand(string, n, null);
    }

    public void addAuxCommand(String string, int n, String string2) {
        this.putControlSequence(new AuxCommand(string, n, string2));
    }

    public boolean isAllowedAuxCommand(ControlSequence controlSequence) {
        if (controlSequence instanceof CatCodeChanger) {
            return this.allowCatChangers;
        }
        return controlSequence instanceof Input || controlSequence instanceof AuxCommand || controlSequence instanceof AuxIgnoreable || controlSequence instanceof AssignedControlSequence || controlSequence instanceof AuxProvideCommand || controlSequence instanceof AuxActionCommand || controlSequence instanceof Primitive;
    }

    @Override
    public ControlSequence getControlSequence(String string) {
        ControlSequence controlSequence = this.getParser().getControlSequence(string);
        if (controlSequence instanceof CatCodeChanger && !this.allowCatChangers) {
            return ((CatCodeChanger)((Object)controlSequence)).getNoOpCommand();
        }
        return this.isAllowedAuxCommand(controlSequence) ? controlSequence : new AuxIgnoreable(string);
    }

    public void setAllowCatCodeChangers(boolean bl) {
        this.allowCatChangers = bl;
    }

    public boolean isAllowCatCodeChangersOn() {
        return this.allowCatChangers;
    }

    public void enableSaveDivisions(boolean bl) {
        this.saveDivisions = bl;
    }

    public boolean isSaveDivisionsEnabled() {
        return this.saveDivisions;
    }

    public void enableSaveLabels(boolean bl) {
        this.saveLabels = bl;
    }

    public boolean isSaveLabelsEnabled() {
        return this.saveLabels;
    }

    public void enableSaveCites(boolean bl) {
        this.saveCites = bl;
    }

    public boolean isSaveCitesEnabled() {
        return this.saveCites;
    }

    protected DivisionInfo createDivisionInfo(String string, TeXObject teXObject, TeXObject teXObject2, String string2, TeXObject teXObject3) {
        return new DivisionInfo(string, teXObject, teXObject2, string2, teXObject3);
    }

    protected void initDivisionInfo() {
        this.divisionData = new Vector();
        this.divisionData.add(this.createDivisionInfo("document", null, null, "Doc-Start", null));
    }

    @Override
    public ControlSequence createUndefinedCs(String string) {
        return new AuxIgnoreable(string);
    }

    @Override
    public Writeable getWriteable() {
        return this;
    }

    @Override
    public void writeliteral(String string) throws IOException {
    }

    @Override
    public void writeliteralln(String string) throws IOException {
    }

    @Override
    public void write(String string) throws IOException {
    }

    @Override
    public void writeln(String string) throws IOException {
    }

    @Override
    public void write(char c) throws IOException {
    }

    @Override
    public void writeCodePoint(int n) throws IOException {
    }

    @Override
    public void overwithdelims(TeXObject teXObject, TeXObject teXObject2, TeXObject teXObject3, TeXObject teXObject4) throws IOException {
    }

    @Override
    public void abovewithdelims(TeXObject teXObject, TeXObject teXObject2, TeXDimension teXDimension, TeXObject teXObject3, TeXObject teXObject4) throws IOException {
    }

    @Override
    public void skipping(Ignoreable ignoreable) throws IOException {
    }

    @Override
    public void href(String string, TeXObject teXObject) throws IOException {
    }

    @Override
    public void subscript(TeXObject teXObject) throws IOException {
    }

    @Override
    public void superscript(TeXObject teXObject) throws IOException {
    }

    @Override
    public void endParse(File file) throws IOException {
    }

    @Override
    public void beginParse(File file, Charset charset) throws IOException {
        this.getParser().message("message.reading", file);
        if (charset != null) {
            this.getParser().message("message.charset", charset);
        }
    }

    public void addAuxData(AuxData auxData) {
        if (this.getParser().isDebugMode(8)) {
            this.getParser().logMessage("AuxData: " + auxData.toString(this.parser));
        }
        if (auxData.getName().equals("@writefile")) {
            DivisionInfo divisionInfo;
            String string;
            if (this.saveDivisions && (string = auxData.getArg(0).toString(this.getParser())).equals("toc") && (divisionInfo = this.getDivisionInfo(auxData.getArg(1))) != null) {
                if (this.divisionData == null) {
                    this.initDivisionInfo();
                }
                this.divisionData.add(divisionInfo);
            }
        } else {
            if (auxData.getName().equals("newlabel")) {
                DivisionInfo divisionInfo = null;
                if (this.saveDivisions) {
                    if (this.divisionData == null) {
                        this.initDivisionInfo();
                    }
                    if (!this.divisionData.isEmpty()) {
                        divisionInfo = this.divisionData.lastElement();
                        divisionInfo.addLabel(auxData.getArg(0).toString(this.getParser()));
                    }
                }
                if (this.saveLabels) {
                    if (this.labelData == null) {
                        this.labelData = new HashMap();
                    }
                    LabelInfo labelInfo = LabelInfo.createLabel(auxData, this.getParser());
                    if (divisionInfo != null) {
                        labelInfo.setDivisionInfo(divisionInfo);
                    }
                    this.labelData.put(labelInfo.getLabel(), labelInfo);
                }
            } else if (this.saveCites && auxData.getName().equals("bibcite")) {
                if (this.citeData == null) {
                    this.citeData = new HashMap();
                }
                if (this.citeList == null) {
                    this.citeList = new Vector();
                }
                CiteInfo citeInfo = CiteInfo.createCite(auxData, this.getParser());
                if (this.divisionData != null && !this.divisionData.isEmpty()) {
                    DivisionInfo divisionInfo = this.divisionData.lastElement();
                    citeInfo.setDivisionInfo(divisionInfo);
                }
                this.citeData.put(citeInfo.getLabel(), citeInfo);
                this.citeList.add(citeInfo);
            }
            this.auxData.add(auxData);
        }
    }

    protected DivisionInfo getDivisionInfo(TeXObject teXObject) {
        if (!this.getParser().isStack(teXObject)) {
            return null;
        }
        TeXObjectList teXObjectList = (TeXObjectList)teXObject;
        if (teXObjectList.isEmpty()) {
            return null;
        }
        try {
            TeXObject teXObject2;
            TeXObject teXObject3 = teXObjectList.popStack(this.getParser());
            if (!(teXObject3 instanceof ControlSequence) || !((ControlSequence)teXObject3).getName().equals("contentsline")) {
                return null;
            }
            String string = TeXParserUtils.popLabelString(this.getParser(), teXObjectList);
            TeXObject teXObject4 = teXObjectList.popArg(this.getParser());
            TeXObject teXObject5 = null;
            if (this.getParser().isStack(teXObject4) && (teXObject3 = ((TeXObjectList)teXObject4).peek()) instanceof ControlSequence) {
                teXObject2 = (ControlSequence)teXObject3;
                if (((ControlSequence)teXObject2).getName().equals("numberline")) {
                    ((TeXObjectList)teXObject4).pop();
                    teXObject5 = ((TeXObjectList)teXObject4).popArg(this.getParser());
                } else if (((ControlSequence)teXObject2).getName().equals("nonumberline")) {
                    ((TeXObjectList)teXObject4).pop();
                }
            }
            teXObject2 = teXObjectList.popArg(this.getParser());
            String string2 = null;
            if (!teXObjectList.isEmpty()) {
                string2 = TeXParserUtils.popLabelString(this.getParser(), teXObjectList);
            }
            return this.createDivisionInfo(string, teXObject5, teXObject4, string2, teXObject2);
        }
        catch (IOException iOException) {
            if (this.getParser().isDebugModeOn()) {
                this.getTeXApp().error(iOException);
            }
            return null;
        }
    }

    public Vector<DivisionInfo> getDivisionData() {
        return this.divisionData;
    }

    public DivisionInfo getDivisionByTarget(String string) {
        if (this.divisionData == null) {
            return null;
        }
        for (DivisionInfo divisionInfo : this.divisionData) {
            if (!string.equals(divisionInfo.getTarget())) continue;
            return divisionInfo;
        }
        return null;
    }

    public DivisionInfo getDivisionByLabel(String string) {
        if (this.divisionData == null) {
            return null;
        }
        for (DivisionInfo divisionInfo : this.divisionData) {
            if (!string.equals(divisionInfo.getLabel())) continue;
            return divisionInfo;
        }
        return null;
    }

    public DivisionInfo getDivisionContainingLabel(String string) {
        if (this.divisionData == null) {
            return null;
        }
        if (this.labelData != null) {
            LabelInfo labelInfo = this.labelData.get(string);
            if (labelInfo != null && labelInfo.getDivisionInfo() != null) {
                return labelInfo.getDivisionInfo();
            }
            return null;
        }
        for (DivisionInfo divisionInfo : this.divisionData) {
            if (!divisionInfo.containsLabel(string)) continue;
            return divisionInfo;
        }
        return null;
    }

    public Vector<AuxData> getAuxData(String string) {
        Vector<AuxData> vector = new Vector<AuxData>();
        for (AuxData auxData : this.auxData) {
            if (!auxData.getName().equals(string)) continue;
            vector.add(auxData);
        }
        return vector;
    }

    public Vector<AuxData> getAuxData() {
        return this.auxData;
    }

    public HashMap<String, LabelInfo> getLabelData() {
        return this.labelData;
    }

    public HashMap<String, CiteInfo> getCiteData() {
        return this.citeData;
    }

    public Vector<CiteInfo> getCiteList() {
        return this.citeList;
    }

    @Override
    public Charset getCharSet() {
        return this.charset == null ? super.getCharSet() : this.charset;
    }

    public void setCharSet(Charset charset) {
        this.charset = charset;
    }

    @Override
    public float emToPt(float f) {
        this.getParser().warning("Can't convert from em to pt, no font information loaded");
        return 9.5f * f;
    }

    @Override
    public float exToPt(float f) {
        this.getParser().warning("Can't convert from ex to pt, no font information loaded");
        return 4.4f * f;
    }
}

