package App::InteractivePerlTutorial::Chapter::IO::Printf;

use 5.014000;
use strict;
use warnings;
our $VERSION = '0.000_001';

use constant TEXT => 'Printf';

1;
__DATA__

=encoding utf-8

=head1 Using C<printf> to format output

The "printf" operator takes a format string followed by a list of things to print. It works just like the C<printf> function in C.

  printf "%g %g %g\n", 5/2, 51/17, 51 ** 17;  # will print  2.5  3  1.0683e+29  (automatically chooses floating-point, integer, or even exponential notation, as needed)

Generally, you won't use an array as an argument to printf. But if you want to, you can write a program like this:

  my @numbers = qw( one two three );
  my $format = "The items are:\n" . ("%10s\n" x @items);
  printf $format, @items;

This program prints each item on its own line, right-justified in a 10-character column, under a heading line.


=cut
