package Graphics::ColorNamesLite::HTML_ID;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2020-06-09'; # DATE
our $DIST = 'Graphics-ColorNamesLite-HTML_ID'; # DIST
our $VERSION = '3.3.1.001.000'; # VERSION

our $NAMES_RGB_TABLE = {
  abu        => 808080,
  akua       => "00ffff",
  aqua       => "00ffff",
  biru       => "0000ff",
  birutua    => "000080",
  fuchsia    => "ff00ff",
  hijau      => "008000",
  hitam      => "000000",
  kapur      => "00ff00",
  kuning     => "ffff00",
  merah      => "ff0000",
  merahmarun => 800000,
  perak      => "c0c0c0",
  putih      => "ffffff",
  teal       => "008080",
  ungu       => 800080,
  zaitun     => 808000,
}
;

1;
# ABSTRACT: HTML color names and equivalent RGB values (Indonesian translation) (lite version)

__END__

=pod

=encoding UTF-8

=head1 NAME

Graphics::ColorNamesLite::HTML_ID - HTML color names and equivalent RGB values (Indonesian translation) (lite version)

=head1 VERSION

This document describes version 3.3.1.001.000 of Graphics::ColorNamesLite::HTML_ID (from Perl distribution Graphics-ColorNamesLite-HTML_ID), released on 2020-06-09.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Graphics-ColorNamesLite-HTML_ID>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Graphics-ColorNamesLite-HTML_ID>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Graphics-ColorNamesLite-HTML_ID>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<Graphics::ColorNames::HTML_ID>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
