#!/usr/bin/perl

# (c) Andrew Murphy 2025, as a perl port of the mapbox/cheap-ruler original
#
# A direct port of mapbox/cheap-ruler's tests, which are (c) mapbox
#
# The original compared the results from this module to 'definitive' results from the @turf/tuf javascript library. 
# As that's not available in Perl, I saved the results from running the JS test program, and hardcoded them here.
#
#

require '../lib/Geo/CheapRuler.pm';

use Scalar::Util qw(looks_like_number);
use JSON;
use Data::Dumper;
use experimental 'signatures';
use strict;
use warnings;

my $lines = [
	[ [ -96.920341, 32.838261 ], [ -96.920421, 32.838295 ], [ -96.920421, 32.838295 ], [ -96.920536, 32.838297 ], [ -96.920684, 32.838293 ], [ -96.920818, 32.838342 ] ],
	[ [ -96.920349, 32.838306 ], [ -96.920421, 32.838295 ] ],
	[ [ -96.919874, 32.837479 ], [ -96.920097, 32.837684 ], [ -96.92018, 32.837844 ], [ -96.92029, 32.838216 ], [ -96.920341, 32.838261 ] ],
	[ [ -96.915781, 32.834689 ], [ -96.915735, 32.834529 ], [ -96.91573, 32.834443 ], [ -96.915733, 32.834286 ], [ -96.915853, 32.8337 ] ],
	[ [ -96.915092, 32.836889 ], [ -96.915915, 32.836977 ] ],
	[ [ -96.914617, 32.83752 ], [ -96.914507, 32.838106 ], [ -96.914319, 32.839063 ] ],
	[ [ -96.915671, 32.833443 ], [ -96.915427, 32.833817 ], [ -96.91532, 32.833963 ], [ -96.915247, 32.834072 ], [ -96.915062, 32.834252 ], [ -96.914775, 32.834518 ] ],
	[ [ -96.9104, 32.837119 ], [ -96.910567, 32.837069 ], [ -96.9111, 32.836941 ] ],
	[ [ -96.91441, 32.836582 ], [ -96.914225, 32.836544 ], [ -96.914158, 32.836499 ], [ -96.914107, 32.836449 ], [ -96.914075, 32.836393 ], [ -96.914059, 32.836292 ], [ -96.914091, 32.836073 ], [ -96.914649, 32.834919 ], [ -96.914837, 32.834601 ], [ -96.914858, 32.834583 ], [ -96.914912, 32.834563 ], [ -96.914968, 32.834561 ], [ -96.91503, 32.83457 ], [ -96.915081, 32.834592 ], [ -96.915116, 32.834628 ], [ -96.915134, 32.834671 ], [ -96.91514, 32.834718 ], [ -96.915124, 32.834793 ], [ -96.914931, 32.835336 ], [ -96.914888, 32.835509 ], [ -96.91481, 32.835911 ] ],
	[ [ -96.914155, 32.836758 ], [ -96.913391, 32.836697 ], [ -96.912991, 32.836643 ], [ -96.912847, 32.836589 ], [ -96.912761, 32.836508 ], [ -96.912573, 32.836433 ] ],
	[ [ -96.917377, 32.837281 ], [ -96.917589, 32.837317 ], [ -96.918117, 32.837339 ] ], [ [ -96.920815, 32.836594 ], [ -96.919732, 32.836643 ], [ -96.918975, 32.836702 ], [ -96.918077, 32.836729 ], [ -96.916661, 32.83672 ], [ -96.916358, 32.836774 ] ], [ [ -96.911543, 32.836925 ], [ -96.911806, 32.837006 ], [ -96.911994, 32.837028 ], [ -96.912326, 32.837114 ], [ -96.912552, 32.837202 ], [ -96.912656, 32.83729 ] ], [ [ -96.914657, 32.836659 ], [ -96.914518, 32.837522 ], [ -96.914472, 32.837673 ], [ -96.914383, 32.837772 ], [ -96.914284, 32.837858 ], [ -96.914153, 32.837905 ], [ -96.914024, 32.837912 ], [ -96.913925, 32.837885 ], [ -96.913804, 32.837828 ], [ -96.913678, 32.837729 ], [ -96.913391, 32.837479 ], [ -96.913278, 32.837328 ], [ -96.913252, 32.837238 ], [ -96.913262, 32.837148 ], [ -96.913305, 32.837078 ], [ -96.91337, 32.837024 ], [ -96.91348, 32.837004 ], [ -96.914483, 32.83688 ] ], [ [ -96.915915, 32.836977 ], [ -96.916183, 32.837004 ], [ -96.916425, 32.837042 ], [ -96.916862, 32.837164 ] ], [ [ -96.915183, 32.840102 ], [ -96.915151, 32.839929 ], [ -96.915113, 32.839539 ], [ -96.915008, 32.838973 ], [ -96.914949, 32.83873 ], [ -96.914909, 32.838491 ], [ -96.914834, 32.838234 ] ], [ [ -96.914728, 32.842674 ], [ -96.914772, 32.84257 ], [ -96.914872, 32.842277 ], [ -96.914974, 32.841939 ], [ -96.915014, 32.841646 ], [ -96.915065, 32.84138 ], [ -96.915113, 32.84099 ], [ -96.915175, 32.840321 ], [ -96.915193, 32.839827 ], [ -96.915204, 32.839345 ], [ -96.91525, 32.839045 ], [ -96.915325, 32.838759 ], [ -96.915483, 32.838464 ], [ -96.915658, 32.838236 ], [ -96.915907, 32.837943 ], [ -96.91621, 32.837709 ], [ -96.91636, 32.837612 ], [ -96.916588, 32.837481 ], [ -96.916948, 32.837324 ], [ -96.91731, 32.837188 ], [ -96.918026, 32.837098 ], [ -96.918847, 32.83706 ], [ -96.919391, 32.83704 ], [ -96.919847, 32.83701 ], [ -96.920174, 32.836961 ] ], [ [ -96.914603, 32.839688 ], [ -96.914335, 32.841087 ], [ -96.914099, 32.841896 ], [ -96.913823, 32.842577 ], [ -96.91377, 32.842674 ] ], [ [ -96.915915, 32.836977 ], [ -96.916105, 32.837042 ], [ -96.916183, 32.837116 ], [ -96.916218, 32.837164 ], [ -96.916232, 32.83722 ], [ -96.916223, 32.837308 ], [ -96.916202, 32.837355 ], [ -96.916006, 32.837556 ], [ -96.915714, 32.837779 ], [ -96.915588, 32.83784 ], [ -96.915419, 32.837871 ], [ -96.915293, 32.837867 ], [ -96.91514, 32.837828 ], [ -96.915062, 32.837774 ], [ -96.915014, 32.837734 ], [ -96.914925, 32.837614 ], [ -96.914888, 32.837515 ], [ -96.914831, 32.837297 ] ], [ [ -96.917743, 32.833443 ], [ -96.917766, 32.836553 ] ], [ [ -96.912399, 32.842674 ], [ -96.911487, 32.841373 ], [ -96.9104, 32.841399 ] ], [ [ -96.91072, 32.84264 ], [ -96.910717, 32.842674 ] ], [ [ -96.911584, 32.833443 ], [ -96.911581, 32.833684 ], [ -96.911559, 32.835271 ], [ -96.911554, 32.83642 ] ], [ [ -96.920403, 32.833443 ], [ -96.920397, 32.833894 ] ], [ [ -96.9104, 32.833662 ], [ -96.911581, 32.833684 ] ], [ [ -96.914775, 32.834518 ], [ -96.914512, 32.835038 ], [ -96.914327, 32.835437 ], [ -96.914016, 32.836136 ], [ -96.913973, 32.83621 ], [ -96.913906, 32.83628 ], [ -96.913769, 32.836359 ], [ -96.913675, 32.836384 ], [ -96.913203, 32.836445 ] ], [ [ -96.9104, 32.837231 ], [ -96.910695, 32.837202 ], [ -96.911025, 32.837182 ], [ -96.911355, 32.837168 ], [ -96.911948, 32.837168 ], [ -96.912391, 32.837222 ], [ -96.912656, 32.83729 ], [ -96.913072, 32.83752 ] ], [ [ -96.916189, 32.83818 ], [ -96.918117, 32.837339 ] ], [ [ -96.918165, 32.84179 ], [ -96.917329, 32.840988 ], [ -96.91702, 32.840704 ], [ -96.916811, 32.840587 ], [ -96.916661, 32.840519 ], [ -96.916368, 32.840454 ], [ -96.916164, 32.840438 ], [ -96.915263, 32.840458 ] ], [ [ -96.914137, 32.840553 ], [ -96.914316, 32.840555 ] ], [ [ -96.91415, 32.840452 ], [ -96.914054, 32.841182 ], [ -96.913976, 32.841572 ], [ -96.913842, 32.842049 ], [ -96.913691, 32.842414 ], [ -96.913569, 32.842674 ] ], [ [ -96.914919, 32.842674 ], [ -96.91492, 32.842671 ], [ -96.9151, 32.842171 ], [ -96.915244, 32.84152 ], [ -96.915322, 32.840979 ], [ -96.915376, 32.840569 ], [ -96.915384, 32.840454 ] ], [ [ -96.915474, 32.833443 ], [ -96.915379, 32.833664 ], [ -96.915314, 32.833772 ], [ -96.915261, 32.833849 ], [ -96.915081, 32.834083 ], [ -96.914775, 32.834518 ] ], [ [ -96.913072, 32.83752 ], [ -96.913195, 32.837608 ], [ -96.913675, 32.838002 ], [ -96.913694, 32.838011 ], [ -96.91396, 32.838241 ], [ -96.914054, 32.838345 ], [ -96.91416099999999, 32.838507 ], [ -96.914255, 32.838714 ], [ -96.914292, 32.83889 ], [ -96.914319, 32.839063 ], [ -96.914182, 32.840098 ], [ -96.91415, 32.840452 ] ], [ [ -96.917406, 32.836557 ], [ -96.91588, 32.836517 ], [ -96.915778, 32.836501 ], [ -96.915727, 32.836481 ], [ -96.91569, 32.836458 ], [ -96.915644, 32.836422 ], [ -96.915609, 32.836382 ], [ -96.915588, 32.836348 ], [ -96.915572, 32.836305 ], [ -96.915564, 32.836235 ], [ -96.915564, 32.836154 ], [ -96.915668, 32.835469 ], [ -96.915754, 32.834827 ], [ -96.915781, 32.834689 ], [ -96.915835, 32.834556 ], [ -96.916052, 32.834074 ], [ -96.916283, 32.833443 ] ], [ [ -96.915384, 32.840454 ], [ -96.915408, 32.839794 ], [ -96.915411, 32.839345 ], [ -96.915459, 32.839068 ], [ -96.91554, 32.838845 ], [ -96.915636, 32.838687 ], [ -96.915765, 32.838529 ], [ -96.915945, 32.838358 ], [ -96.916189, 32.83818 ] ], [ [ -96.919421, 32.837159 ], [ -96.919557, 32.837216 ], [ -96.919697, 32.837288 ], [ -96.919812, 32.8374 ], [ -96.919874, 32.837479 ], [ -96.920172, 32.838358 ], [ -96.920295, 32.838845 ], [ -96.920333, 32.839068 ], [ -96.920327, 32.839422 ], [ -96.920223, 32.839746 ], [ -96.920072, 32.840046 ], [ -96.919898, 32.840276 ], [ -96.919812, 32.840355 ], [ -96.919426, 32.84067 ], [ -96.918012, 32.84172 ], [ -96.91753, 32.84207 ], [ -96.917374, 32.842196 ], [ -96.916727, 32.842674 ] ], [ [ -96.916981, 32.842674 ], [ -96.917079, 32.842602 ], [ -96.917487, 32.842291 ], [ -96.918114, 32.841826 ], [ -96.919984, 32.840454 ], [ -96.920236, 32.840233 ], [ -96.920429, 32.839965 ], [ -96.920512, 32.839816 ], [ -96.92059, 32.839557 ], [ -96.920612, 32.839271 ], [ -96.920604, 32.839181 ], [ -96.920574, 32.839043 ], [ -96.920416, 32.83857 ], [ -96.920365, 32.83839 ], [ -96.920341, 32.838261 ], [ -96.9203, 32.838119 ], [ -96.920282, 32.837943 ], [ -96.920274, 32.83775 ], [ -96.920295, 32.837603 ], [ -96.920319, 32.837536 ], [ -96.920397, 32.837407 ], [ -96.920515, 32.837288 ], [ -96.920601, 32.837227 ], [ -96.920727, 32.83717 ] ], [ [ -96.91441, 32.836582 ], [ -96.914188, 32.836571 ], [ -96.913203, 32.836445 ] ], [ [ -96.914324, 32.840454 ], [ -96.91415, 32.840452 ] ], [ [ -96.921387, 32.836595 ], [ -96.920815, 32.836594 ], [ -96.917766, 32.836553 ], [ -96.917406, 32.836557 ], [ -96.915851, 32.836621 ], [ -96.915459, 32.836621 ], [ -96.915129, 32.836607 ] ], [ [ -96.918117, 32.837339 ], [ -96.918324, 32.837252 ], [ -96.918586, 32.837186 ], [ -96.91884400000001, 32.837161 ], [ -96.919421, 32.837159 ], [ -96.920727, 32.83717 ], [ -96.921387, 32.83717 ] ], [ [ -96.913203, 32.836445 ], [ -96.913142, 32.836438 ], [ -96.912999, 32.836438 ], [ -96.912774, 32.836427 ], [ -96.912573, 32.836433 ], [ -96.911554, 32.83642 ], [ -96.9104, 32.836416 ] ], [ [ -96.915253, 32.840564 ], [ -96.915376, 32.840569 ], [ -96.915816, 32.840562 ], [ -96.916197, 32.840567 ], [ -96.916478, 32.840598 ], [ -96.916623, 32.840641 ], [ -96.916757, 32.840702 ], [ -96.916913, 32.840794 ], [ -96.917326, 32.841157 ], [ -96.917452, 32.841272 ], [ -96.917956, 32.841761 ], [ -96.918061, 32.841867 ] ], [ [ -96.9145, 32.842674 ], [ -96.914547, 32.842534 ], [ -96.914708, 32.841971 ], [ -96.914802, 32.841473 ], [ -96.914858, 32.841078 ], [ -96.914882, 32.840742 ], [ -96.914907, 32.840224 ], [ -96.914915, 32.839706 ], [ -96.914885, 32.839084 ], [ -96.914826, 32.83811 ], [ -96.914831, 32.837297 ] ], [ [ -96.914987, 32.836886 ], [ -96.915092, 32.836889 ] ], [ [ -96.914526, 32.836763 ], [ -96.914155, 32.836758 ], [ -96.9104, 32.836758 ] ], [ [ -96.921387, 32.836813 ], [ -96.918825, 32.836796 ], [ -96.916358, 32.836774 ], [ -96.915003, 32.836767 ] ], [ [ -96.914831, 32.837297 ], [ -96.914872, 32.836663 ], [ -96.915033, 32.835872 ], [ -96.91514, 32.83546 ], [ -96.915226, 32.835212 ], [ -96.915853, 32.8337 ], [ -96.91595, 32.833443 ] ], [ [ -96.915092, 32.836889 ], [ -96.916398, 32.836891 ], [ -96.919547, 32.836963 ], [ -96.921322, 32.836952 ], [ -96.921387, 32.836952 ] ], [ [ -96.9104, 32.837008 ], [ -96.910671, 32.836977 ], [ -96.9111, 32.836941 ], [ -96.911543, 32.836925 ], [ -96.912637, 32.836898 ], [ -96.913501, 32.836886 ], [ -96.914528, 32.83688 ] ], [ [ -96.91577, 32.833443 ], [ -96.915671, 32.833693 ], [ -96.915344, 32.834518 ], [ -96.91481, 32.835911 ], [ -96.914754, 32.836127 ], [ -96.914657, 32.836659 ], [ -96.914617, 32.83752 ], [ -96.914595, 32.838561 ], [ -96.914603, 32.839688 ], [ -96.914587, 32.840693 ], [ -96.914512, 32.841211 ], [ -96.914421, 32.841666 ], [ -96.914284, 32.842196 ], [ -96.914097, 32.842674 ] ], [ [ -96.914316, 32.840555 ], [ -96.915253, 32.840564 ] ], [ [ -96.916862, 32.837164 ], [ -96.917377, 32.837281 ] ], [ [ -96.915129, 32.836607 ], [ -96.91441, 32.836582 ] ], [ [ -96.915263, 32.840458 ], [ -96.914324, 32.840454 ] ], [ [ -96.914528, 32.83688 ], [ -96.914987, 32.836886 ] ], [ [ -96.915003, 32.836767 ], [ -96.914526, 32.836763 ] ]
];

my $bearing = [-63.168358499156525,0,-88.81417863576165,-91.84236975813288,-66.4804397776352,95.21979003879285,-100.30570881092109,150.61043051857857,-42.42680621413666,-23.550372000573976,-13.952505152879572,-43.59833577684526,132.99198010184847,166.41929543518998,177.20325519324226,-179.08016175949166,-170.2370338024474,11.337660289272069,-82.74731094319029,63.53130497081162,8.962738746772079,9.37241746920313,-168.57228731223967,28.73076075405366,31.624597758763326,29.36786429209857,40.81330085442227,42.1946257366957,54.7169930372886,-109.61289479832884,-105.9508130297151,-97.35442495838335,103.73738360872169,128.6375329107378,139.40255086492127,154.35307612449398,172.41822883056525,-173.00067170261377,-157.8888529973499,-153.5843194614746,-135.57055815771457,-113.78745742209202,-92.43386994136274,-80.19821514884795,-62.82436796798226,-39.245350948615155,-19.378190588293595,-6.122391240486928,10.16238185779092,16.628046997768603,11.796298618679382,9.259418658966704,33.01398807351879,95.42809952638044,99.12772054024747,114.05171960369522,138.26425923288858,115.39825807606725,-78.13409883486399,-78.57409383522955,-87.1608521998273,-108.19195718992367,86.91738524336452,84.70017282115019,87.95033104208613,90.43302815269155,78.02446742557484,87.86117672643189,-69.86932102820376,-82.07107484899849,-72.86553078736863,-65.1355375506252,-44.7981708695929,-110.57110545811186,7.706991461697684,14.357081967635963,37.06518971504372,44.04525332938273,66.87692305523358,86.30473553343819,107.98313957934,119.27773275661788,133.08034138732987,136.03334418261207,147.83958089391126,166.35653590671714,-174.66648288115698,-152.70026364821263,-134.67606485534643,-102.21019447885837,-98.37013738569259,-85.39045487355833,-83.16251407288334,-79.41426027160959,-71.61992023883627,25.647805187311675,171.16629111227073,175.31992211154693,171.14075667690167,168.4699111035812,171.99557069131671,166.22310505773353,1.1490813989122273,-160.4320410387924,-163.99994946634428,-165.77289001767542,-173.45680596800386,-170.84905103991312,-174.09621979055856,-175.54766503661992,-178.24648292813612,-178.9015131718509,-172.65900563912462,-167.5744291592953,-155.7719187979583,-147.18225435460818,-144.47188257911304,-132.58756099972285,-127.58358615210913,-124.36541206463681,-117.43139970286094,-114.09107335076804,-98.50829769899121,-93.15284638632924,-92.50530269541622,-94.47703726891228,-100.11192008554171,59.77360017977726,9.143285027759825,13.77132015480269,18.804056386135507,24.65786911308088,-162.44500486120558,-67.84560294942294,-41.52913748098395,-31.493999863996763,-11.862722004156868,4.911415385207834,20.576859308160817,39.328103571820634,47.731045069650285,60.04949187595387,77.6845353441491,92.1637728779789,106.87667403935711,129.48750446242522,134.76457530705628,148.07063441512034,162.56674425715815,167.60958213096342,-147.58932438109017,-0.3560229039908105,36.377431696680866,149.50345988783283,88.36898545916792,-12.223747274643541,4.239696778394533,-175.4876519466172,0.5992644178258199,0.6673420119705482,0.20949071130099972,-111.81827272747626,0.6404507023306292,91.5793518292065,-88.72964175221959,-72.73595760641244,23.023787326465758,21.284935273114478,20.497437869075558,26.023401004269186,38.80671567232787,55.53828086401786,72.43572115612405,81.25555219912327,71.54335789800338,-96.67318521315028,-94.12560298544153,-92.89044170566763,-89.99983922215846,-81.7451500515321,-73.01710953553376,-56.65379972059106,-75.85450215089512,-117.43602194308066,-0.5191133757264856,138.78810984877518,137.5682425746788,123.67524095771084,118.34970555203208,104.79079948892173,95.33306354879426,88.48636023444747,84.26539611740044,-89.23804769497431,126.44610739090022,6.304981288824429,9.538566926163998,13.280042951632824,19.16618238072603,21.51585631114597,-89.9996339244023,-164.35486777447994,-163.1715107556702,-169.47198029178583,-173.0931353906555,-173.68544129434264,-176.65500600808483,-179.38201633300537,19.859344499549415,26.825916744943097,30.04299979358223,32.876257058655874,30.585844995133318,25.48436330548106,-49.58528537315648,-45.66818093615927,-60.586961024854496,-44.17809723517507,-37.21357406423359,-29.028010308307657,-20.883863911308925,-10.016986247912778,-7.470516078862875,6.345968960148907,4.34320933123148,-144.9163810436088,91.7864594482791,100.57490882823174,115.01987711640018,126.49515677620997,132.966745035407,143.6768700122894,152.57244080298454,162.6386056371201,174.514957150436,180,-172.73016111884996,-173.57809345551522,-170.66439195451878,-161.1629250483923,-159.27915118031842,-162.90191363911163,6.149002598388654,-178.2500225299691,-179.67835798380744,-171.71629870266574,-163.02862431750938,-152.95560774367897,-145.55034083174812,-138.5096300766174,-130.9661041794466,-110.60445245946968,-63.488932752077304,-58.529628507022345,-40.784935262998765,-33.40113040557487,-15.899450269674261,-11.98079922160087,-8.147813630969711,0.8158694624984411,15.093060661548853,22.923229163325363,32.44078804116013,42.44701224126366,45.83427921267664,48.528375495078414,49.163719675217294,46.128985873372955,48.673227507999385,-89.99993112361511,-131.16855313994876,-132.21634274731403,-131.4350519146657,-131.1287697990316,-136.22759996904776,-148.82348281361988,-154.9192138530867,-165.80042858228467,-176.30209430353858,175.72884636973504,169.64893781149905,164.32272447851255,166.6095398893929,171.11558508661616,166.3637807550949,175.08861951595486,178.00534677470006,-173.15552477625073,-163.2497127428419,-153.06780391136738,-140.2005052574728,-130.1707760198508,-118.29848203381599,96.31992932299448,93.37488183764103,98.65620852739154,-13.220894289645209,90.78374679176736,-122.38574263089491,90.11906042024525,90.91606631492044,89.24226505681405,87.1952301524781,89.99989371956248,92.8904234737817,-73.74422236611342,-116.57497470982092,-106.68941539794253,-96.5786003424879,-90.23620894320433,-89.42530845671874,-89.99982105641458,96.01646126426012,97.77709140355807,89.99996123049279,93.3299783600632,87.96524189628325,90.86961377588838,90.23605053342786,-44.507638815015056,-87.22999594365552,-91.08466222064868,-89.10502963141018,-82.51948924441974,-70.55890852325767,-61.55042515421009,-54.93400664520933,-43.708432529297596,-42.63081903510838,-40.89066031737039,-39.7687188456462,74.90365235952855,-164.24862093846133,-166.4900911667301,-170.98867168255882,-173.2072838170113,-176.56563073555716,-177.67795564554825,-179.25657611558916,177.6794175197143,177.08641995229797,-179.7039343413944,-162.31174704216053,-88.05239082888943,104.83933395017502,90.91884342556446,89.99898193057349,-89.65566421438594,90.45177683075707,90.6074206920093,90.35190900303913,15.252229486394574,-176.8898360115017,-170.29517886199278,-167.6901473062663,-163.7553909375346,-160.7898000462187,-162.40423641399113,11.815918282043796,-89.89521786020993,-88.44037032878992,-90.42210719551586,-89.99998237874593,89.64945709817326,-97.75278349052702,-95.7033459340717,-92.46126755841848,-91.68219351310293,-90.94678497048473,-90.39810804835399,-163.10988605635674,18.404250368996717,18.41984455338911,17.853582297431547,12.289104435180683,8.709879039137686,2.2353614586203556,1.0172614149810169,-0.34171312935830794,0.766344154317998,6.935793520625259,9.538556914147389,12.252956858473992,18.194809085044522,-175.03725779127225,-89.34475877575512,-158.31621119961858,-74.8695322495171,109.63776192527477,92.36950183161946,-10.475734036813332,90.29024058557611,-177.25427215663902,-89.10855416706457,-173.55458838828318,90.57168813707538];

my $dest= [[-96.920341,32.82926779636275],[-96.92060778450087,32.829303165932515],[-96.92079451212265,32.82930727422472],[-96.9210961260162,32.82931611998831],[-96.92143056929962,32.82932170113868],[-96.92175078577964,32.82938301475816],[-96.92146771734464,32.82936205709705],[-96.92172530845703,32.82936882357472],[-96.92136348883658,32.8285733087812],[-96.92177123148915,32.82880150647781],[-96.92203846421765,32.82898740960074],[-96.92233213654715,32.829388010261844],[-96.92256618035026,32.829464299752],[-96.91818844867862,32.82592626854599],[-96.9183240687229,32.825802906294],[-96.91849990199901,32.82575620184158],[-96.91868288907624,32.82564114322261],[-96.91898196210329,32.82509971766565],[-96.91839922050515,32.82833591159009],[-96.91939936288811,32.828473710634995],[-96.91827746330944,32.829069099629926],[-96.9183424530407,32.829710062621906],[-96.91832829383961,32.83072458287257],[-96.9198526077549,32.82516464288392],[-96.91977992030039,32.82560122433432],[-96.91984289709899,32.825812308181526],[-96.91993849516078,32.82598887460538],[-96.91992066883401,32.826238903029754],[-96.91979936845,32.82657737212902],[-96.91558867541256,32.82925325982501],[-96.91591825211054,32.829280543332246],[-96.91661219417051,32.829232199105775],[-96.9200814423861,32.82895520288886],[-96.92005398325918,32.829001529706176],[-96.92014274841405,32.82904315387903],[-96.92024569051316,32.82908204902757],[-96.92036576257566,32.829117188080225],[-96.92049991542756,32.8291095432823],[-96.92068009769577,32.82898608620437],[-96.92138420170551,32.82792978775588],[-96.92171631557892,32.82771161817116],[-96.92187935712697,32.827795547051295],[-96.92207326017358,32.827879543357014],[-96.92226698374023,32.82798357541711],[-96.92246448537438,32.82810061094041],[-96.92264872402215,32.82823261702553],[-96.92281465924218,32.82838056017075],[-96.92296125059312,32.82853740628445],[-96.9230934586633,32.82870012069524],[-96.92320124720449,32.828892668162396],[-96.92312961924138,32.82955501288251],[-96.92320546120253,32.82984911851759],[-96.92324379227583,32.83037394817867],[-96.92270259869152,32.83134546445511],[-96.92204971551025,32.83141062944011],[-96.92175819581165,32.83148440469963],[-96.92172000587533,32.831559751319034],[-96.92173711073838,32.831609629905216],[-96.9216494822712,32.831667000597555],[-96.92655118465909,32.83264882306949],[-96.92685801001652,32.83282005658583],[-96.92747801097255,32.832978659949504],[-96.9302650793092,32.832371591566265],[-96.92926835327323,32.832559809405865],[-96.92859472394949,32.8327592710776],[-96.92777716136813,32.83292793380188],[-96.92643864048699,32.833061754432606],[-96.92621014858483,32.83325968946926],[-96.92146666690911,32.83355569507261],[-96.92179815509333,32.833782727080155],[-96.92205159334094,32.833951741013955],[-96.9224459755929,32.83418569209505],[-96.92273127585463,32.83442253526159],[-96.92289147581616,32.834660225178936],[-96.9249454750224,32.83417971626583],[-96.92485651375128,32.835193962649534],[-96.92485732117676,32.835496918298205],[-96.92481195941141,32.8357485369176],[-96.92475341966224,32.83598777202126],[-96.9246596864881,32.836188576935854],[-96.92456474834997,32.83634990481375],[-96.92449659552395,32.8364777086477],[-96.92440321904128,32.836575941285275],[-96.9243016090113,32.836632555443444],[-96.92403574489141,32.8365385037244],[-96.92394065016207,32.83654373862211],[-96.92392931485305,32.83661021254796],[-96.923950727173,32.836676877840624],[-96.92400188604485,32.83676368677891],[-96.92407178849457,32.836866591597996],[-96.92418343518834,32.83700354450321],[-96.9251848089756,32.83703649768771],[-96.92661194950811,32.83729040333625],[-96.92687182316983,32.837474213658545],[-96.92710244217793,32.83766888088661],[-96.92752481874291,32.837947357295945],[-96.92582828486587,32.84104159517407],[-96.9257751346183,32.84102454703043],[-96.925712722213,32.840790165308846],[-96.92558006016057,32.8403794026038],[-96.92549021633258,32.840291211617924],[-96.92541616202962,32.84020654519793],[-96.9253039050267,32.84010335633012],[-96.92515801072389,32.84469659808116],[-96.9251584032161,32.84474522392278],[-96.9252116097644,32.844604187287594],[-96.92526366162194,32.844417441880175],[-96.92525058446878,32.84427494162168],[-96.9252453923334,32.84415864066478],[-96.92523408506669,32.843917493407886],[-96.9252336634307,32.84339645450699],[-96.92518619817741,32.843049478880005],[-96.92512869065526,32.84271352173969],[-96.92510318059608,32.8425585385925],[-96.92510367084212,32.84241648526235],[-96.92518418154818,32.84226431789665],[-96.92527874458767,32.84217799298068],[-96.92544437010139,32.84202546735504],[-96.925661096881,32.84193069822234],[-96.9257219592662,32.84197164316459],[-96.92585796613487,32.84197726015863],[-96.92612314644114,32.84195550758327],[-96.9263875339594,32.841953344233865],[-96.9270031608832,32.8419957293357],[-96.92772105822925,32.842088622556375],[-96.92815925385939,32.842197984018306],[-96.92850677720159,32.84229577431029],[-96.92872266046489,32.84237295449939],[-96.92303820319165,32.84522448611264],[-96.92265404447323,32.846746331255225],[-96.92229929299305,32.84767645249148],[-96.9219020292973,32.84847681291447],[-96.92172524992739,32.84869137616297],[-96.92374353544108,32.84311010646692],[-96.92380495209731,32.843288968456946],[-96.92375202335589,32.843474927497745],[-96.92365378612277,32.84363294947855],[-96.92353228389474,32.843797000878034],[-96.92338555984529,32.84399104877525],[-96.92322464999872,32.84414206086036],[-96.92288661228363,32.84444500544157],[-96.92245047920139,32.84476785145947],[-96.92217828087917,32.84492656849411],[-96.92186107223289,32.84505312677186],[-96.92158489820727,32.84514249717772],[-96.92127980472954,32.845194651263185],[-96.921047839665,32.84522956125484],[-96.92084405190435,32.84527620006287],[-96.9205974828288,32.84524054129007],[-96.92040118714759,32.84522355923814],[-96.92018320483953,32.8450852289178],[-96.92293237997681,32.84130852606885],[-96.92279138243077,32.84449342709605],[-96.91725900706562,32.85068690919724],[-96.91617973545887,32.849455950324824],[-96.91492410658923,32.84954952910515],[-96.91507415877298,32.85085562494866],[-96.91489982259995,32.850952218028326],[-96.91559379317768,32.8417812892913],[-96.9154169874526,32.84207982038637],[-96.91522006748852,32.84372179380654],[-96.91503900853823,32.84492319280571],[-96.92371072937414,32.841996001423894],[-96.92352657514154,32.84249420447107],[-96.91335044281459,32.842306787571815],[-96.91435142035817,32.8423707371403],[-96.9173645773578,32.84324404039408],[-96.91691993339032,32.843800685358794],[-96.91655255055922,32.84423366086846],[-96.91605849486353,32.84496395657043],[-96.91583180084045,32.84506656292941],[-96.91558054005691,32.84516247122861],[-96.91525876889908,32.845264673573695],[-96.9149795426836,32.84531016289491],[-96.91432191932128,32.845388932949106],[-96.91133296238822,32.84618997832162],[-96.91144171102619,32.846173294428326],[-96.91158523231833,32.846162877516356],[-96.91172858301583,32.846155724665685],[-96.91213481997016,32.84615983379001],[-96.912391,32.84621520363724],[-96.91246917977304,32.84628183379001],[-96.91269841550242,32.846507724665685],[-96.91562876138154,32.84716087751631],[-96.91737028782114,32.846310294428314],[-96.91723198968016,32.85074897832101],[-96.91621002339699,32.84993193294823],[-96.91571539381063,32.849630162893796],[-96.91532116012296,32.84949267357227],[-96.91498637995474,32.849401471226784],[-96.91450911026513,32.84931056292719],[-96.91412140612248,32.849265956567685],[-96.9130373235226,32.84925466086468],[-96.91172891696925,32.849315685353936],[-96.91172624648298,32.84928104038791],[-96.91137936836364,32.84913873713238],[-96.9111033071735,32.84982678756186],[-96.91084615409257,32.85017220445961],[-96.91053394985605,32.85060200140955],[-96.91020575606348,32.85091719279462],[-96.9099076270943,32.851124793791435],[-96.91108262394582,32.851069820366206],[-96.9109097898619,32.85100928926868],[-96.91091720111106,32.85044921802967],[-96.91088989618454,32.8497356249519],[-96.91079791482352,32.84912952910645],[-96.91068330705855,32.84865195032753],[-96.91052411451939,32.84846690920523],[-96.91044879364803,32.84138342710803],[-96.91018960710304,32.841529526067944],[-96.90996200771717,32.84156022893318],[-96.90974804056076,32.841557559255115],[-96.90940874283211,32.841709541307374],[-96.90894515933653,32.84206020007953],[-96.90708617746589,32.84497556125621],[-96.90705521048986,32.844974651264444],[-96.90738309222216,32.8452774971769],[-96.9072519176052,32.845193126770965],[-96.90736968934455,32.84532756849146],[-96.90731747783792,32.84533385145557],[-96.9072803139891,32.845396005434715],[-96.90723224246867,32.84550106085014],[-96.90712931248305,32.8455730487629],[-96.90701856451042,32.84564000086307],[-96.90674596805829,32.84656694945384],[-96.9065806921352,32.84681092746863],[-96.90970608997688,32.842803968461325],[-96.90805150513044,32.84265010647123],[-96.90782330337755,32.84251837622246],[-96.90764852560412,32.84238081297508],[-96.90749020943518,32.842238452547186],[-96.9073253927703,32.842081331304385],[-96.90717411099378,32.84191848614847],[-96.90703939857258,32.84175995450622],[-96.90691229157852,32.84159077431835],[-96.90679582566005,32.84139298402773],[-96.90669003234649,32.84118262256724],[-96.90669100386174,32.84036672935569],[-96.9066767074795,32.83959234426349],[-96.90660612591307,32.83932050761705],[-96.90656533931626,32.839052260196915],[-96.90669041385988,32.83843364321182],[-96.90683235729647,32.83766469828039],[-96.9058463600797,32.84453646732025],[-96.90578708653725,32.84373599295871],[-96.90570972216119,32.84314531788402],[-96.90568029511564,32.84272548525784],[-96.90568684160546,32.842358538595455],[-96.90571138291753,32.84205552174957],[-96.9057719479569,32.84175147889974],[-96.9058865590192,32.841433454537224],[-96.90606823534226,32.84110749345173],[-96.90924109177199,32.83993764073139],[-96.90932092641079,32.839844941692384],[-96.90940787752501,32.83976644195517],[-96.90947295832581,32.83972718736702],[-96.90948819248544,32.83965422400643],[-96.90974249642343,32.840380598152656],[-96.9098250229076,32.840714356319914],[-96.9098257696725,32.84078354518822],[-96.90978570149134,32.84098321160619],[-96.90965084777537,32.841152402590644],[-96.90947221724494,32.84129716530017],[-96.90927382384996,32.84137154702447],[-96.90916668479284,32.84129459516969],[-96.90876276011966,32.84145335723524],[-96.90733399512413,32.84234688080538],[-96.90684056681042,32.84254021357037],[-96.906676421573,32.842509403245295],[-96.90602449249442,32.84283049758664],[-96.90627688113032,32.84267354440427],[-96.90637653902586,32.842444591500694],[-96.90678948577578,32.841976686688064],[-96.90742470955576,32.841354877759215],[-96.90930629834148,32.839826212492106],[-96.90957300092155,32.839448738571804],[-96.9097839570224,32.839024503681486],[-96.90988814124343,32.83871955540756],[-96.90999057453156,32.838304941255686],[-96.91004023943334,32.8378637086241],[-96.91006310098157,32.837618904792265],[-96.91006717883496,32.83732657691671],[-96.90994649637634,32.83669977200938],[-96.90993596799443,32.83636653690735],[-96.9099556100428,32.83608491828854],[-96.90996141673106,32.835790962639805],[-96.9099933761891,32.835463716245144],[-96.91003847115428,32.8351202251716],[-96.91011567817172,32.83482353525526],[-96.91019897630811,32.83460769208846],[-96.91033936372787,32.834330741008124],[-96.91052281317126,32.83406472707586],[-96.91067729933795,32.83385769506809],[-96.91087480747571,32.83365568946341],[-96.90463237470915,32.83292375443461],[-96.90448785589236,32.83276993380416],[-96.90358330389304,32.832502271081225],[-96.9047872373956,32.83637080935307],[-96.90469951006277,32.83622959151379],[-96.91202606746195,32.83223465995944],[-96.91154606545459,32.8320970565953],[-96.90859189055601,32.831920823078825],[-96.90832950505407,32.83179100059599],[-96.90687487783904,32.83172262990384],[-96.90658599092711,32.83159175131867],[-96.90636180774267,32.831448404700055],[-96.90945822188766,32.83205262943277],[-96.9097763537565,32.831839464449594],[-96.91015208663012,32.83164894816486],[-96.91052638406339,32.831501118500185],[-96.91122221244876,32.831378012863844],[-96.91264953658857,32.83126966813877],[-96.91343332172714,32.83115212067162],[-96.90537559304622,32.83031140626788],[-96.90544318384582,32.830190560154406],[-96.90543111866747,32.83007861700941],[-96.90533935916473,32.82995761092477],[-96.9052738624001,32.829855575401915],[-96.90439259008015,32.829736543342506],[-96.90337849795029,32.82962854703753],[-96.90837322245928,32.833674618128164],[-96.90864036975053,32.83357978771685],[-96.90922656920247,32.83347508617467],[-96.90975577448452,32.833384543255285],[-96.91018693952483,32.833322188054886],[-96.9104840196879,32.83327404900349],[-96.91077196831336,32.83324615385611],[-96.91108373775586,32.833251529684176],[-96.91165426540974,32.833530202866456],[-96.91193953697552,32.833563199085724],[-96.9126044651269,32.83397254331178],[-96.91287204714311,32.834001259805554],[-96.90947517006302,32.83473337209765],[-96.90968787800865,32.834520902999984],[-96.91001608751691,32.83388787457889],[-96.91027872039547,32.83332230815813],[-96.91050472377987,32.832862224313374],[-96.91070004854892,32.832463642864475],[-96.91089765374069,32.83188558286972],[-96.91107947785278,32.83131006261832],[-96.9112244722226,32.83063309962674],[-96.91134159265796,32.82960671063291],[-96.91152376430092,32.82874391158941],[-96.91185792565125,32.82828571766091],[-96.91214202446575,32.82824414321915],[-96.9117560256446,32.82807620183887],[-96.91156586629741,32.82803190629173],[-96.90799249523697,32.82799526854418],[-96.91916185593074,32.828016299753095],[-96.91678289610542,32.82796801026274],[-96.91449955817367,32.8279174096013],[-96.91332878579807,32.827884506478206],[-96.9133415142159,32.828391308781256],[-96.91356771551156,32.82773682357513],[-96.91391431331547,32.82692805709752],[-96.91420724448977,32.82650101475855],[-96.91447945659964,32.82624070113894],[-96.91529290297521,32.824719119988536],[-96.9155765082821,32.82445527422482],[-96.91490521845624,32.82789716593251],[-96.916398,32.827897796362755],[-96.91973378169938,32.82797116593251],[-96.92169550647426,32.82796427422473],[-96.92194711753314,32.827971119988376],[-96.91114655849728,32.828036701138785],[-96.91160377144261,32.828018014758335],[-96.91221870014984,32.82799705709732],[-96.9128472883362,32.82799882357507],[-96.91412647909223,32.82799230878138],[-96.91517521644526,32.828003506478154],[-96.91638644404446,32.82802340960125],[-96.91781202680221,32.82461501026488],[-96.91789606590359,32.82489629975544],[-96.91775144404362,32.82575526854615],[-96.91739910901005,32.82718490629259],[-96.91752395451893,32.827440201839615],[-96.91760696789441,32.828014143219455],[-96.91774609668724,32.82891971765996],[-96.9179022827724,32.83000791158731],[-96.91808746925994,32.83118471062999],[-96.9182475941055,32.83224209962346],[-96.91834758715551,32.832815062614934],[-96.91843041137052,32.83332758286619],[-96.91846601993204,32.83391764286061],[-96.91845035447002,32.834458224308754],[-96.91883923284054,32.832404308160996],[-96.9199448381361,32.83248087458362],[-96.92172082814558,32.82915090301929],[-96.92240152476658,32.829340372118395],[-96.92031764549829,32.828741259827126],[-96.91976122276536,32.82879354333436],[-96.9207754124897,32.8327491990895],[-96.9199956896855,32.8328272028699],[-96.92035700531324,32.82933752970443],[-96.9209717744945,32.82943015387692],[-96.92114171249484,32.82940004902574],[-96.92081678878547,32.82948718807799]];

my $line_d = [
  0.046609981574718906, 0.006837014573958606,  0.09982096963311761,
   0.11145486692082905,  0.07751139204101343,  0.17381925202277865,
   0.14676779064907625,  0.06835463295054281,   0.4305992420136874,
    0.1557978717029982,  0.06959752243825565,   0.4175473486544049,
    0.1134246533617343,   0.4067920086631963,   0.0912417649765146,
   0.21051279092490788,   0.9728177474330546,   0.3420448027669489,
   0.24824621320909163,  0.34582337602506064,   0.2694827378486251,
  0.003791006838911109,  0.33104204432567463, 0.050152114348814274,
    0.1103696612125124,   0.2819178714479139,   0.2591681195374065,
   0.20295566550414915,   0.3323736620879069,   0.0167244127771416,
   0.25418196785296215,    0.251332659581037,   0.1366450335701835,
     0.369790836894593,   0.5098946385998686,  0.27700635228430115,
    0.7804466653674759,   0.7765870721458984,  0.11386458795215279,
  0.016257352691627366,   0.5849278801157626,   0.3090362347669837,
    0.2619924506934261,  0.32158671576383474,   0.6016049131070021,
  0.009815617625238785,   0.3854892432197202,    0.596468304092842,
   0.44346775518093884,   0.5882430664388428,   0.3861995959973342,
     1.047392774464168,  0.08754420230740816,  0.04984310632212073,
    0.0672324998303992,  0.08772656032497436,  0.04288867654437069,
   0.04456747112444238
];

my $area = [0.000013821966460524386,"",0.00038167607945955657,0.0004591385397222654,"",0.000025446515599589757,0.0005938959815914259,0.000027394937377022956,0.010084205265083024,0.0011018140741357297,0.00007450771955373174,0.00026057249737056594,0.00042241409592432797,0.010610408028146834,0.00019460648477219572,0.0004520746159345059,0.11616035194670211,0.0023737375298452097,0.008496745579042082,"",0.007468549572583057,"",0.00009892163896192197,"","",0.0060715760140698195,0.004114227195228051,"",0.010224029554891,"",0.0017417778558363863,0.0012496523814881585,0.00029788849513368243,0.013289667971670676,0.03293688294652814,0.005938823117793873,0.07260640770926477,0.044571317796879055,0.00008901635907172925,"",0.0011495755032210305,0.002592484257812901,0.00017045933611256446,0.009439521851774785,0.00879086205587918,"",0.0000975244541827153,0.000016710206772352964,0.0052802922007401665,0.0005023784935927536,0.001334167649175738,0.01736563067316484,"","","","","",""];

my $along_d=[0.023304990787359453,0.003418507286979303,0.049910484816558805,0.055727433460414526,0.038755696020506714,0.08690962601138932,0.07338389532453812,0.034177316475271405,0.2152996210068437,0.0778989358514991,0.034798761219127824,0.20877367432720245,0.05671232668086715,0.20339600433159816,0.0456208824882573,0.10525639546245394,0.4864088737165273,0.17102240138347444,0.12412310660454581,0.17291168801253032,0.13474136892431254,0.0018955034194555545,0.16552102216283732,0.025076057174407137,0.0551848306062562,0.14095893572395696,0.12958405976870324,0.10147783275207457,0.16618683104395346,0.0083622063885708,0.12709098392648108,0.1256663297905185,0.06832251678509176,0.1848954184472965,0.2549473192999343,0.13850317614215057,0.39022333268373793,0.3882935360729492,0.056932293976076395,0.008128676345813683,0.2924639400578813,0.15451811738349186,0.13099622534671304,0.16079335788191737,0.3008024565535011,0.004907808812619392,0.1927446216098601,0.298234152046421,0.22173387759046942,0.2941215332194214,0.1930997979986671,0.523696387232084,0.04377210115370408,0.024921553161060365,0.0336162499151996,0.04386328016248718,0.021444338272185344,0.02228373556222119]
;
my $along_e=[[-96.92058074705261,32.838295790638604],[-96.92038500000223,32.838300500005154],[-96.92017837949813,32.837840876146984],[-96.91575185809616,32.83419391015031],[-96.91550349979606,32.83693300067325],[-96.91447049297071,32.8382918379503],[-96.91528382138036,32.83401702016945],[-96.91074827033752,32.83702546820635],[-96.91465325332314,32.83491180557744],[-96.9133254981959,32.836688157348064],[-96.91774498947464,32.83732349979329],[-96.91858548156746,32.8367137123682],[-96.91212500559202,32.83706193530806],[-96.91369409219624,32.83774164388782],[-96.91639766393257,32.837037707584614],[-96.91504330753082,32.83916332521944],[-96.91553969265064,32.83839013773005],[-96.91430070726514,32.84120455527579],[-96.91571233411688,32.837779806500336],[-96.9177544997986,32.834998000000525],[-96.91166706734955,32.841629875937976],[-96.9107185000003,32.84265700000001],[-96.91156370689535,32.8349314664544],[-96.9204000000076,32.833668500000044],[-96.91099049992684,32.833673001386295],[-96.91421262070213,32.83569407895492],[-96.91178370739729,32.83716800028003],[-96.91715300456607,32.83775950369485],[-96.9169767353908,32.84067978015298],[-96.91422649999899,32.84055400003185],[-96.91397243336206,32.841584696234726],[-96.91523149763673,32.84157652148577],[-96.91515150426643,32.833991344631286],[-96.9142729703425,32.83879948063655],[-96.9156392575161,32.835658314541256],[-96.91543436762962,32.83921014952233],[-96.91983675113876,32.84033226350925],[-96.92009207607055,32.840359219198234],[-96.91380542577559,32.83652206253011],[-96.914236999999,32.84045300003009],[-96.91825697483058,32.836559607150164],[-96.91973317221229,32.83716163055562],[-96.91180206194201,32.83642316543709],[-96.91691026889121,32.84079238934942],[-96.9149104537422,32.840000370933915],[-96.9150394999991,32.83688750001096],[-96.91246302385605,32.836758013878296],[-96.91819499264128,32.8367903863771],[-96.91518494007596,32.83533040554249],[-96.91823942303635,32.83693311262286],[-96.91246139013953,32.83690233470654],[-96.91460659817584,32.8380121984508],[-96.91478449997625,32.840559500872736],[-96.91711949983032,32.83722250026362],[-96.91476949994939,32.83659450051384],[-96.91479349998943,32.84045600087646],[-96.91475749999225,32.83688300020942],[-96.91476449999463,32.83676500022616]];

my $lineslice=[0.018676476695075068,0.0027402452008965525,0.03986681961739431,0.044469828362384625,0.031068128858192007,0.06935270196562665,0.05864477838054148,0.027389022501664605,0.1719473071884825,0.06242418657786493,0.027896581131503166,0.16736929890940028,0.045433434840099055,0.16266637261526035,0.036564056331650635,0.0839934725605101,0.38889265754466407,0.13649460461297847,0.09926995453961898,0.1379641885925622,0.1077876650634276,0.0015124395896951679,0.13206729380017174,0.020007897318231,0.04424000448314326,0.11264892073505513,0.10385421506411856,0.08127347934642998,0.13303940509012496,0.006704256607118157,0.10143121432836028,0.10028472742058167,0.05457424680730121,0.14767043885943648,0.20376817712890685,0.11059083322186752,0.31189428275983044,0.3103470048596363,0.04563831858954404,0.006517020134452003,0.23446673433930426,0.12386477987649205,0.10501877199670123,0.12872175630992638,0.24002085475093318,0.003934571422019604,0.15452322553436254,0.23909413102456933,0.1769741790033523,0.23579706844935688,0.15480625196597156,0.41792933226585005,0.03509354680421111,0.01997323405388721,0.02694985837335511,0.03516662470663397,0.01719191698998208,0.01786484977009217];

my $lineslicealong=[0.018676476695075068,0.0027402452008965525,0.03986681961739431,0.044469828362384625,0.031068128858192007,0.06935270196562665,0.05864477838054148,0.027389022501664605,0.1719473071884825,0.06242418657786493,0.027896581131503166,0.16736929890940028,0.045433434840099055,0.16266637261526035,0.036564056331650635,0.0839934725605101,0.38889265754466407,0.13649460461297847,0.09926995453961898,0.1379641885925622,0.1077876650634276,0.0015124395896951679,0.13206729380017174,0.020007897318231,0.04424000448314326,0.11264892073505513,0.10385421506411856,0.08127347934642998,0.13303940509012496,0.006704256607118157,0.10143121432836028,0.10028472742058167,0.05457424680730121,0.14767043885943648,0.20376817712890685,0.11059083322186752,0.31189428275983044,0.3103470048596363,0.04563831858954404,0.006517020134452003,0.23446673433930426,0.12386477987649205,0.10501877199670123,0.12872175630992638,0.24002085475093318,0.003934571422019604,"",0.23909413102456933,0.1769741790033523,0.23579706844935688,0.15480625196597156,0.41792933226585005,0.03509354680421111,0.01997323405388721,0.02694985837335511,0.03516662470663397,0.01719191698998208,0.01786484977009217];

my $bufferpoint=[[-96.92206354723291,32.83681367237103,-96.91861839660037,32.83970830403321],[-96.92214354789262,32.836847672371015,-96.9186983959406,32.8397423040332],[-96.92214354789262,32.836847672371015,-96.9186983959406,32.8397423040332],[-96.92225854793142,32.836849672371,-96.91881339590176,32.83974430403319],[-96.9224065478538,32.836845672371005,-96.91896139597938,32.8397403040332],[-96.92254054880453,32.83689467237099,-96.91909539502853,32.83978930403317],[-96.92207154810605,32.836858672371,-96.91862639572713,32.83975330403318],[-96.92214354789262,32.836847672371015,-96.9186983959406,32.8397423040332],[-96.9215965320606,32.836031672371384,-96.9181514117749,32.83892630403357],[-96.92181953603794,32.83623667237129,-96.91837440779697,32.83913130403347],[-96.92190253914224,32.836396672371215,-96.91845740469222,32.839291304033395],[-96.92201254635982,32.83676867237105,-96.9185673974736,32.83966330403324],[-96.92206354723291,32.83681367237103,-96.91861839660037,32.83970830403321],[-96.91750347793385,32.83324167237263,-96.91405846590938,32.836136304034824],[-96.91745747483003,32.83308167237272,-96.91401246901363,32.83597630403491],[-96.91745247316176,32.832995672372746,-96.91400747068215,32.83589030403493],[-96.91745547011618,32.83283867237283,-96.9140104737282,32.83573330403502],[-96.91757545874877,32.83225267237308,-96.9141304850972,32.83514730403527],[-96.91681452061383,32.83544167237164,-96.91336942322332,32.83833630403383],[-96.91763752232112,32.83552967237161,-96.91419242151578,32.838424304033786],[-96.91633953285606,32.83607267237135,-96.91289441097933,32.83896730403354],[-96.91622954422557,32.8366586723711,-96.91278439960814,32.83955330403328],[-96.91604156279395,32.83761567237066,-96.91259638103715,32.84051030403285],[-96.91739345376357,32.8319956723732,-96.91394849008316,32.8348903040354],[-96.91714946101835,32.83236967237305,-96.91370448282728,32.83526430403523],[-96.9170424638505,32.83251567237296,-96.91359747999476,32.83541030403514],[-96.91696946596491,32.83262467237292,-96.91352447788005,32.83551930403511],[-96.91678446945663,32.832804672372845,-96.91333947438785,32.835699304035025],[-96.91649747461668,32.83307067237271,-96.91305246922707,32.8359653040349],[-96.91212252507606,32.83567167237153,-96.90867741876039,32.838566304033726],[-96.91228952410601,32.83562167237156,-96.9088444197306,32.838516304033746],[-96.91282252162267,32.835493672371626,-96.90937742221432,32.838388304033806],[-96.91613251465776,32.83513467237179,-96.91268742918024,32.83802930403398],[-96.91594751392053,32.83509667237181,-96.91250242991757,32.837991304034],[-96.91588051304747,32.835051672371826,-96.91243543079072,32.83794630403402],[-96.91582951207745,32.83500167237186,-96.91238443176091,32.83789630403404],[-96.91579751099103,32.834945672371866,-96.91235243284747,32.83784030403405],[-96.91578150903155,32.83484467237192,-96.9123364348072,32.837739304034095],[-96.91581350478289,32.83462567237202,-96.9123684390565,32.83752030403419],[-96.91637148239563,32.83347167237254,-96.91292646144697,32.83636630403472],[-96.91655947622677,32.833153672372674,-96.91311446761674,32.83604830403486],[-96.91658047587758,32.83313567237269,-96.91313546796594,32.83603030403488],[-96.9166344754896,32.833115672372706,-96.91318946835399,32.83601030403488],[-96.9166904754508,32.833113672372704,-96.91324546839279,32.83600830403489],[-96.9167524756254,32.833122672372696,-96.91330746821818,32.836017304034876],[-96.91680347605217,32.83314467237269,-96.91335846779134,32.83603930403487],[-96.91683847675051,32.833180672372656,-96.91339346709289,32.83607530403486],[-96.91685647758467,32.83322367237266,-96.91341146625861,32.83611830403484],[-96.91686247849643,32.83327067237264,-96.91341746534673,32.83616530403482],[-96.91684647995136,32.833345672372594,-96.9134014638916,32.83624030403477],[-96.91665349048513,32.833888672372346,-96.91320845335626,32.83678330403453],[-96.9166104938413,32.83406167237228,-96.91316544999967,32.83695630403446],[-96.91653250164006,32.834463672372095,-96.9130874421998,32.837358304034275],[-96.91587751807229,32.83531067237172,-96.9124324257652,32.8382053040339],[-96.91511351688884,32.83524967237174,-96.91166842694885,32.83814430403393],[-96.9147135158412,32.83519567237175,-96.91126842799662,32.83809030403395],[-96.91456951479353,32.83514167237177,-96.9111244290444,32.83803630403396],[-96.9144835132221,32.835060672371824,-96.91103843061609,32.837955304034004],[-96.91429551176702,32.83498567237185,-96.91085043207133,32.83788030403404],[-96.9190995282191,32.83583367237147,-96.91565441561694,32.83872830403365],[-96.91931152891755,32.83586967237146,-96.9158664149184,32.83876430403364],[-96.91983952934437,32.835891672371446,-96.91639441449149,32.83878630403363],[-96.92253751489055,32.83514667237178,-96.91909242894738,32.838041304033965],[-96.92145451584119,32.83519567237175,-96.91800942799661,32.83809030403395],[-96.92069751698584,32.83525467237173,-96.91725242685182,32.83814930403392],[-96.91979951750965,32.835281672371714,-96.9163544263279,32.838176304033894],[-96.91838351733504,32.83527267237172,-96.91493842650256,32.83816730403391],[-96.91808051838268,32.83532667237169,-96.91463542545473,32.83822130403387],[-96.91326552131223,32.83547767237163,-96.90982042252476,32.838372304033825],[-96.91352852288375,32.8355586723716,-96.91008342095307,32.838453304033784],[-96.91371652331055,32.835580672371584,-96.91027142052616,32.838475304033764],[-96.91404852497907,32.835666672371545,-96.91060341885742,32.83856130403373],[-96.91427452668641,32.8357546723715,-96.91082941714988,32.83864930403369],[-96.91437852839371,32.83584267237148,-96.9109334154423,32.83873730403364],[-96.91637951615161,32.83521167237174,-96.91293442768618,32.83810630403393],[-96.91624053289486,32.83607467237136,-96.9127954109405,32.83896930403355],[-96.9161945358245,32.8362256723713,-96.91274940801041,32.839120304033486],[-96.91610553774531,32.836324672371255,-96.91266040608936,32.83921930403343],[-96.91600653941387,32.8364106723712,-96.91256140442056,32.83930530403339],[-96.91587554032576,32.83645767237119,-96.91243040350852,32.83935230403337],[-96.91574654046156,32.836464672371186,-96.91230140337268,32.839359304033366],[-96.91564753993772,32.8364376723712,-96.91220240389664,32.83933230403338],[-96.9155265388318,32.83638067237122,-96.91208140500271,32.8392753040334],[-96.91540053691102,32.836281672371264,-96.91195540692375,32.83917630403345],[-96.91511353206062,32.836031672371384,-96.91166841177491,32.83892630403357],[-96.91500052913096,32.83588067237145,-96.91155541470495,32.838775304033646],[-96.91497452738484,32.83579067237148,-96.91152941645133,32.83868530403368],[-96.91498452563872,32.83570067237153,-96.9115394181977,32.83859530403371],[-96.91502752428063,32.835630672371565,-96.91158241955597,32.83852530403374],[-96.91509252323296,32.83557667237158,-96.91164742060377,32.83847130403377],[-96.91520252284495,32.83555667237159,-96.91175742099188,32.838451304033775],[-96.9162055204392,32.83543267237165,-96.91276042339796,32.83832730403384],[-96.91763752232112,32.83552967237161,-96.91419242151578,32.838424304033786],[-96.91790552284495,32.83555667237159,-96.91446042099187,32.838451304033775],[-96.91814752358219,32.83559467237157,-96.91470242025453,32.83848930403376],[-96.91858452594913,32.835716672371525,-96.91513941788722,32.838611304033705],[-96.9169055829543,32.838654672370204,-96.91346036087387,32.841549304032384],[-96.91687357959741,32.83848167237027,-96.91342836423125,32.84137630403245],[-96.91683557202994,32.838091672370446,-96.91339037179984,32.84098630403264],[-96.91673056104766,32.83752567237071,-96.91328538278367,32.84042030403289],[-96.91667155633273,32.83728267237082,-96.91322638749925,32.840177304033],[-96.9166315516955,32.83704367237092,-96.91318639213715,32.83993830403311],[-96.91655654670907,32.836786672371026,-96.9131113971243,32.83968130403321],[-96.9164506328649,32.84122667236904,-96.91300531095612,32.84412130403122],[-96.91649463084661,32.84112267236908,-96.91304931297469,32.84401730403127],[-96.91659462516054,32.84082967236922,-96.91314931866158,32.843724304031404],[-96.91669661860129,32.84049167236936,-96.91325132522175,32.84338630403155],[-96.91673661291543,32.8401986723695,-96.91329133090848,32.843093304031676],[-96.91678760775356,32.83993267236961,-96.91334233607105,32.8428273040318],[-96.91683560018556,32.83954267236979,-96.91339034364019,32.842437304031975],[-96.91689758720383,32.8388736723701,-96.91345235662375,32.841768304032286],[-96.91691557761818,32.83837967237032,-96.91347036621073,32.8412743040325],[-96.91692656826564,32.83789767237054,-96.91348137556461,32.840792304032725],[-96.91697256244467,32.83759767237066,-96.91352738138643,32.84049230403285],[-96.91704755689544,32.83731167237081,-96.9136023869365,32.840206304032996],[-96.91720555117162,32.837016672370936,-96.91376039266109,32.839911304033116],[-96.91738054674785,32.83678867237104,-96.91393539708547,32.83968330403323],[-96.91762954106305,32.83649567237117,-96.91418440277116,32.83939030403336],[-96.91793253652301,32.83626167237127,-96.91448740731187,32.83915630403346],[-96.91808253464102,32.836164672371325,-96.9146374091941,32.83905930403351],[-96.9183105320994,32.83603367237138,-96.91486541173607,32.83892830403356],[-96.91867052905337,32.835876672371455,-96.91522541478255,32.838771304033635],[-96.91903252641477,32.83574067237151,-96.91558741742153,32.83863530403369],[-96.91974852466863,32.83565067237156,-96.91630341916789,32.838545304033744],[-96.92056952393142,32.835612672371575,-96.91712441990526,32.838507304033755],[-96.92111352354338,32.83559267237158,-96.91766842029331,32.83848730403377],[-96.92156952296136,32.83556267237159,-96.91812442087546,32.838457304033774],[-96.92189652201068,32.83551367237162,-96.91845142182625,32.8384083040338],[-96.91632557492107,32.83824067237039,-96.91288036890825,32.84113530403257],[-96.91605760206782,32.839639672369756,-96.9126123417576,32.84253430403194],[-96.91582161776684,32.84044867236938,-96.91237632605632,32.84334330403157],[-96.91554563098245,32.84112967236907,-96.91210031283883,32.84402430403126],[-96.91549263286488,32.84122667236904,-96.91204731095611,32.84412130403122],[-96.91763752232112,32.83552967237161,-96.91419242151578,32.838424304033786],[-96.91782752358218,32.83559467237157,-96.91438242025453,32.83848930403376],[-96.91790552501789,32.83566867237155,-96.91446041881862,32.838563304033734],[-96.91794052594913,32.835716672371525,-96.91449541788721,32.838611304033705],[-96.9179545270356,32.835772672371505,-96.91450941680058,32.83866730403369],[-96.91794552874293,32.83586067237146,-96.91450041509303,32.83875530403363],[-96.9179245296548,32.835907672371434,-96.91447941418102,32.83880230403363],[-96.91772853355451,32.836108672371346,-96.91428341028075,32.83900330403352],[-96.91743653788109,32.836331672371244,-96.91399140595351,32.83922630403343],[-96.91731053906463,32.83639267237122,-96.91386540476984,32.839287304033405],[-96.91714153966609,32.83642367237122,-96.91369640416829,32.8393183040334],[-96.91701553958849,32.836419672371214,-96.91357040424592,32.839314304033394],[-96.91686253883181,32.83638067237122,-96.9134174050027,32.8392753040334],[-96.91678453778412,32.83632667237125,-96.91333940605057,32.83922130403344],[-96.91673653700803,32.83628667237126,-96.91329140682674,32.839181304033445],[-96.91664753467981,32.83616667237133,-96.91320240915528,32.83906130403351],[-96.91661053275905,32.836067672371364,-96.91316541107633,32.83896230403356],[-96.91655352852953,32.83584967237147,-96.91310841530648,32.838744304033646],[-96.91946545376356,32.8319956723732,-96.91602049008317,32.8348903040354],[-96.91948851409514,32.835105672371796,-96.91604342974294,32.838000304033976],[-96.91412163286489,32.84122667236904,-96.91067631095612,32.84412130403122],[-96.91320960761773,32.83992567236962,-96.90976433620692,32.842820304031804],[-96.91212260812226,32.839951672369615,-96.9086773357023,32.8428463040318],[-96.91244263220506,32.841192672369054,-96.90899731161603,32.844087304031234],[-96.91243963286489,32.84122667236904,-96.90899431095612,32.84412130403122],[-96.91330645376357,32.8319956723732,-96.90986149008316,32.8348903040354],[-96.91330345843843,32.83223667237309,-96.9098584854076,32.83513130403527],[-96.91328148922418,32.83382367237237,-96.9098364546174,32.836718304034555],[-96.91327651151482,32.83497267237186,-96.90983143232359,32.837867304034035],[-96.92212545376354,32.8319956723732,-96.91868049008315,32.8348903040354],[-96.92211946251203,32.832446672372996,-96.91867448133343,32.83534130403518],[-96.91212245801167,32.832214672373105,-96.90867748583443,32.83510930403528],[-96.91330345843843,32.83223667237309,-96.9098584854076,32.83513130403527],[-96.91649747461668,32.83307067237271,-96.91305246922707,32.8359653040349],[-96.91623448470413,32.83359067237248,-96.91278945913814,32.83648530403467],[-96.91604949244453,32.833989672372304,-96.91260445139665,32.836884304034484],[-96.91573850600513,32.834688672371996,-96.91229343783411,32.83758330403419],[-96.91569550744073,32.83476267237195,-96.91225043639827,32.83765730403413],[-96.91562850879876,32.834832672371924,-96.91218343504005,32.83772730403411],[-96.91549151033139,32.83491167237189,-96.9120464335072,32.837806304034075],[-96.91539751081642,32.834936672371875,-96.91195243302212,32.83783130403406],[-96.91492551199984,32.83499767237185,-96.9114804318385,32.83789230403403],[-96.91212252724902,32.8357836723715,-96.90867741658715,32.838678304033685],[-96.91241752668641,32.8357546723715,-96.90897241714988,32.83864930403369],[-96.91274752629836,32.83573467237152,-96.90930241753794,32.838629304033695],[-96.91307752602673,32.835720672371515,-96.9096324178096,32.83861530403371],[-96.91367052602675,32.835720672371515,-96.91022541780961,32.83861530403371],[-96.91411352707442,32.8357746723715,-96.9106684167618,32.83866930403368],[-96.91437852839371,32.83584267237148,-96.9109334154423,32.83873730403364],[-96.91479453285605,32.83607267237135,-96.91134941097933,32.83896730403354],[-96.91791154566135,32.83673267237106,-96.91446639817218,32.83962730403326],[-96.91983952934437,32.835891672371446,-96.91639441449149,32.83878630403363],[-96.91988761570983,32.84034267236944,-96.91644232811362,32.84323730403162],[-96.91905160014673,32.83954067236979,-96.91560634367897,32.84243530403198],[-96.91874259463576,32.83925667236993,-96.91529734919074,32.84215130403211],[-96.9185335923654,32.83913967236998,-96.91508835146139,32.84203430403216],[-96.91838359104591,32.839071672370004,-96.91493835278112,32.841966304032184],[-96.91809058978461,32.83900667237004,-96.91464535404259,32.84190130403221],[-96.91788658947412,32.83899067237005,-96.9144413543531,32.84188530403224],[-96.91698558986222,32.83901067237003,-96.91354035396496,32.84190530403222],[-96.91585959170565,32.839105672369996,-96.91241435212127,32.84200030403218],[-96.91603859174447,32.83910767237,-96.91259335208244,32.842002304032185],[-96.9158725897458,32.83900467237004,-96.9124273540814,32.84189930403222],[-96.91577660391131,32.839734672369715,-96.91233133991385,32.842629304031895],[-96.91569861147941,32.840124672369534,-96.91225333234469,32.84301930403172],[-96.91556462073596,32.84060167236932,-96.9121193230868,32.84349630403151],[-96.91541362781922,32.84096667236915,-96.91196831600253,32.84386130403134],[-96.91529163286488,32.84122667236904,-96.91184631095612,32.84412130403122],[-96.91664163286488,32.84122667236904,-96.9131963109561,32.84412130403122],[-96.91664263280667,32.84122367236903,-96.91319731101436,32.84411830403121],[-96.9168226231035,32.840723672369265,-96.91337732071891,32.843618304031445],[-96.91696661047033,32.84007267236956,-96.91352133335391,32.84296730403174],[-96.9170445999721,32.839531672369795,-96.91359934385365,32.84242630403198],[-96.91709859201613,32.83912167236999,-96.91365335181072,32.842016304032164],[-96.91710658978461,32.83900667237004,-96.91366135404259,32.84190130403221],[-96.91719645376355,32.8319956723732,-96.91375149008316,32.8348903040354],[-96.91710145805047,32.8322166723731,-96.91365648579563,32.835111304035294],[-96.91703646014545,32.83232467237306,-96.91359148370034,32.83521930403525],[-96.9169834616391,32.832401672373024,-96.91353848220648,32.835296304035204],[-96.91680346617828,32.83263567237291,-96.91335847766663,32.835530304035096],[-96.91649747461668,32.83307067237271,-96.91305246922707,32.8359653040349],[-96.91479453285605,32.83607267237135,-96.91134941097933,32.83896730403354],[-96.9149175345634,32.83616067237132,-96.91147240927172,32.83905530403351],[-96.91539754220777,32.83655467237116,-96.91195240162628,32.83944930403334],[-96.91541654238239,32.836563672371135,-96.91197140145164,32.83945830403332],[-96.91568254684492,32.83679367237104,-96.91223739698847,32.839688304033224],[-96.91577654886274,32.83689767237099,-96.91233139497032,32.83979230403317],[-96.91588355200594,32.83705967237092,-96.91243839182667,32.8399543040331],[-96.91597755602231,32.83726667237082,-96.91253238780975,32.84016130403301],[-96.91601455943722,32.83744267237074,-96.91256938439433,32.840337304032936],[-96.91604156279395,32.83761567237066,-96.91259638103715,32.84051030403285],[-96.91590458287668,32.8386506723702,-96.9124593609515,32.84154530403238],[-96.9158725897458,32.83900467237004,-96.9124273540814,32.84189930403222],[-96.91912851417273,32.8351096723718,-96.91568342966532,32.83800430403398],[-96.91760251339669,32.835069672371816,-96.91415743044146,32.837964304034],[-96.9175005130863,32.835053672371814,-96.91405543075193,32.837948304034],[-96.91744951269827,32.83503367237182,-96.91400443113997,32.83792830403401],[-96.91741251225206,32.83501067237184,-96.91396743158627,32.83790530403403],[-96.91736651155364,32.83497467237186,-96.9139214322848,32.83786930403404],[-96.91733151077761,32.83493467237188,-96.91388643306092,32.83782930403405],[-96.91731051011799,32.834900672371894,-96.91386543372063,32.83779530403408],[-96.91729450928378,32.83485767237192,-96.91384943455499,32.837752304034105],[-96.91728650792575,32.834787672371945,-96.91384143591321,32.83768230403413],[-96.91728650635432,32.83470667237198,-96.91384143748488,32.83760130403417],[-96.9173904930653,32.83402167237229,-96.91394545077576,32.836916304034474],[-96.91747648061093,32.83337967237257,-96.91403146323195,32.83627430403476],[-96.91750347793385,32.83324167237263,-96.91405846590938,32.836136304034824],[-96.9175574753538,32.8331086723727,-96.9141124684898,32.83600330403488],[-96.91777446600369,32.83262667237293,-96.91432947784124,32.835521304035105],[-96.91800545376357,32.8319956723732,-96.91456049008316,32.8348903040354],[-96.91710658978461,32.83900667237004,-96.91366135404259,32.84190130403221],[-96.91713057697787,32.838346672370335,-96.91368536685115,32.84124130403252],[-96.91713356826564,32.83789767237054,-96.91368837556463,32.840792304032725],[-96.91718156289095,32.83762067237067,-96.91373638094012,32.84051530403284],[-96.91726255856408,32.83739767237076,-96.9138173852676,32.84029230403295],[-96.91735855549844,32.83723967237084,-96.9139133883337,32.84013430403303],[-96.91748755243279,32.8370816723709,-96.91404239139975,32.83997630403309],[-96.91766754911495,32.836910672370976,-96.91422239471805,32.83980530403316],[-96.91791154566135,32.83673267237106,-96.91446639817218,32.83962730403326],[-96.92114352585213,32.835711672371524,-96.91769841798425,32.83860630403371],[-96.92127952695799,32.8357686723715,-96.91783441687821,32.83866330403369],[-96.9214195283549,32.83584067237147,-96.9179744154811,32.838735304033655],[-96.92153453052786,32.83595267237143,-96.91808941330783,32.83884730403361],[-96.9215965320606,32.836031672371384,-96.9181514117749,32.83892630403357],[-96.92189454911494,32.836910672370976,-96.91844939471804,32.83980530403316],[-96.92201755856406,32.83739767237076,-96.9185723852676,32.84029230403295],[-96.92205556289093,32.83762067237067,-96.9186103809401,32.84051530403284],[-96.92204956975972,32.8379746723705,-96.91860437407036,32.84086930403269],[-96.92194557604648,32.83829867237035,-96.91850036778267,32.84119330403254],[-96.92179458186767,32.838598672370225,-96.91834936196068,32.84149330403241],[-96.92162058633062,32.83882867237011,-96.91817535749708,32.84172330403231],[-96.92153458786358,32.83890767237009,-96.91808935596389,32.84180230403227],[-96.921148593976,32.83922267236994,-96.91770334985058,32.84211730403213],[-96.91973461435141,32.840272672369466,-96.91628932947224,32.84316730403165],[-96.91925262114347,32.8406226723693,-96.9158073226792,32.84351730403149],[-96.91909662358864,32.840748672369244,-96.91565132023369,32.84364330403143],[-96.91844963286488,32.84122667236904,-96.9150043109561,32.84412130403122],[-96.91870363286489,32.84122667236904,-96.91525831095613,32.84412130403122],[-96.91880163146763,32.84115467236906,-96.91535631235361,32.84404930403125],[-96.91920962543223,32.84084367236922,-96.91576431838982,32.843738304031405],[-96.91983661640846,32.84037867236942,-96.91639132741494,32.84327330403161],[-96.92170658978459,32.83900667237004,-96.91826135404257,32.84190130403221],[-96.92195858549627,32.838785672370136,-96.91851335833157,32.84168030403232],[-96.92215158029595,32.83851767237026,-96.9187063635326,32.84141230403244],[-96.92223457740477,32.83836867237033,-96.9187893664242,32.8412633040325],[-96.9223125723792,32.83810967237044,-96.9188673714505,32.84100430403263],[-96.92233456682982,32.83782367237057,-96.91888937700071,32.84071830403275],[-96.9223265650835,32.837733672370604,-96.91888137874722,32.84062830403279],[-96.92229656240588,32.837595672370675,-96.91885138142526,32.84049030403285],[-96.92213855322831,32.83712267237089,-96.91869339060415,32.84001730403306],[-96.92208754973585,32.83694267237097,-96.91864239409709,32.839837304033146],[-96.92206354723291,32.83681367237103,-96.91861839660037,32.83970830403321],[-96.92202254447783,32.83667167237109,-96.91857739935588,32.839566304033276],[-96.92200454106303,32.83649567237117,-96.91855940277115,32.83939030403336],[-96.92199653731846,32.83630267237127,-96.91855140651629,32.83919730403345],[-96.92201753446636,32.83615567237131,-96.91857240936872,32.8390503040335],[-96.92204153316648,32.83608867237135,-96.91859641066884,32.83898330403353],[-96.92211953066366,32.835959672371416,-96.918674413172,32.8388543040336],[-96.9222375283549,32.83584067237147,-96.91879241548112,32.838735304033655],[-96.92232352717143,32.8357796723715,-96.91887841666478,32.83867430403368],[-96.92244952606553,32.83572267237153,-96.91900441777081,32.83861730403371],[-96.91613251465776,32.83513467237179,-96.91268742918024,32.83802930403398],[-96.91591051444433,32.83512367237179,-96.91246542939368,32.83801830403398],[-96.91492551199984,32.83499767237185,-96.9114804318385,32.83789230403403],[-96.9160465897846,32.83900667237004,-96.91260135404258,32.84190130403221],[-96.9158725897458,32.83900467237004,-96.9124273540814,32.84189930403222],[-96.92310951490994,32.83514767237178,-96.91966442892799,32.83804230403397],[-96.92253751489055,32.83514667237178,-96.91909242894738,32.838041304033965],[-96.91948851409514,32.835105672371796,-96.91604342974294,32.838000304033976],[-96.91912851417273,32.8351096723718,-96.91568342966532,32.83800430403398],[-96.91757351541438,32.83517367237177,-96.9141284284235,32.83806830403395],[-96.91718151541438,32.83517367237177,-96.9137364284235,32.83806830403395],[-96.91685151514275,32.83515967237178,-96.91340642869514,32.838054304033946],[-96.91983952934437,32.835891672371446,-96.91639441449149,32.83878630403363],[-96.92004652765647,32.835804672371474,-96.91660141617966,32.83869930403366],[-96.92030852637598,32.83573867237152,-96.91686341746033,32.83863330403371],[-96.92056652589093,32.835713672371526,-96.91712141794545,32.838608304033706],[-96.92114352585213,32.835711672371524,-96.91769841798425,32.83860630403371],[-96.92244952606553,32.83572267237153,-96.91900441777081,32.83861730403371],[-96.92310952606553,32.83572267237153,-96.91966441777079,32.83861730403371],[-96.91492551199984,32.83499767237185,-96.9114804318385,32.83789230403403],[-96.91486451186404,32.83499067237185,-96.91141943197432,32.83788530403403],[-96.91472151186404,32.83499067237185,-96.91127643197434,32.83788530403403],[-96.91449651165063,32.834979672371865,-96.91105143218776,32.83787430403404],[-96.91429551176702,32.83498567237185,-96.91085043207133,32.83788030403404],[-96.91327651151482,32.83497267237186,-96.90983143232359,32.837867304034035],[-96.91212251143723,32.83496867237186,-96.9086774324012,32.83786330403405],[-96.91697559191913,32.83911667236998,-96.9135303519078,32.84201130403216],[-96.91709859201613,32.83912167236999,-96.91365335181072,32.842016304032164],[-96.9175385918803,32.83911467236999,-96.91409335194659,32.842009304032175],[-96.91791959197732,32.83911967236998,-96.91447435184956,32.84201430403216],[-96.91820059257887,32.839150672369975,-96.91475535124795,32.84204530403216],[-96.91834559341326,32.83919367236995,-96.9149003504134,32.84208830403213],[-96.91847959459695,32.839254672369925,-96.91503434922956,32.84214930403211],[-96.91863559638219,32.839346672369885,-96.91519034744407,32.84224130403208],[-96.91904860342619,32.83970967236973,-96.91560334039904,32.8426043040319],[-96.91917460565779,32.839824672369666,-96.91572933816714,32.84271930403184],[-96.91967861514708,32.84031367236945,-96.9162333286765,32.84320830403162],[-96.91978361720408,32.84041967236941,-96.91633832661917,32.84331430403158],[-96.91622263286489,32.84122667236904,-96.91277731095613,32.84412130403122],[-96.91626963014797,32.8410866723691,-96.91282431367341,32.843981304031274],[-96.9164306192223,32.84052367236935,-96.91298532460068,32.84341830403153],[-96.91652460955825,32.84002567236958,-96.9130793342661,32.84292030403176],[-96.91658060189317,32.839630672369765,-96.91313534193225,32.84252530403195],[-96.91660459537313,32.8392946723699,-96.91315934845325,32.84218930403208],[-96.91662958532162,32.838776672370145,-96.91318435850624,32.841671304032324],[-96.91663757527033,32.83825867237038,-96.91319236855892,32.84115330403256],[-96.91660756320141,32.83763667237066,-96.9131623806296,32.840531304032844],[-96.9165485443032,32.836662672371105,-96.91310339953053,32.83955730403328],[-96.91655352852953,32.83584967237147,-96.91310841530648,32.838744304033646],[-96.91670952055561,32.83543867237165,-96.91326442328152,32.83833330403383],[-96.91681452061383,32.83544167237164,-96.91336942322332,32.83833630403383],[-96.91624851816928,32.8353156723717,-96.91280342566819,32.83821030403389],[-96.91587751807229,32.83531067237172,-96.9124324257652,32.8382053040339],[-96.91212251807228,32.83531067237172,-96.90867742576519,32.8382053040339],[-96.92310951913933,32.83536567237169,-96.91966442469798,32.83826030403386],[-96.9205475188095,32.83534867237169,-96.91710242502786,32.838243304033874],[-96.91808051838268,32.83532667237169,-96.91463542545473,32.83822130403387],[-96.91672551824689,32.83531967237171,-96.91328042559057,32.83821430403389],[-96.91655352852953,32.83584967237147,-96.91310841530648,32.838744304033646],[-96.91659451622921,32.835215672371746,-96.91314942760856,32.83811030403393],[-96.91675550088344,32.8344246723721,-96.91331044295649,32.83731930403428],[-96.91686249289071,32.834012672372296,-96.91341745095038,32.836907304034476],[-96.91694848807963,32.83376467237241,-96.91350345576217,32.83665930403459],[-96.91757545874877,32.83225267237308,-96.9141304850972,32.83514730403527],[-96.91767245376354,32.8319956723732,-96.91422749008315,32.8348903040354],[-96.91681452061383,32.83544167237164,-96.91336942322332,32.83833630403383],[-96.91812052065262,32.835443672371646,-96.9146754231845,32.838338304033826],[-96.92126952204949,32.835515672371606,-96.9178244217874,32.83841030403379],[-96.92304452183608,32.83550467237161,-96.91959942200086,32.83839930403379],[-96.92310952183607,32.83550467237161,-96.91966442200085,32.83839930403379],[-96.91212252292253,32.83556067237159,-96.90867742091423,32.838455304033765],[-96.9123935223211,32.83552967237161,-96.90894842151577,32.838424304033786],[-96.91282252162267,32.835493672371626,-96.90937742221432,32.838388304033806],[-96.91326552131223,32.83547767237163,-96.90982042252476,32.838372304033825],[-96.91435952078842,32.83545067237164,-96.91091442304868,32.83834530403383],[-96.9152235205556,32.83543867237165,-96.91177842328152,32.83833330403383],[-96.91625052043919,32.83543267237165,-96.91280542339794,32.83832730403384],[-96.91749245376356,32.8319956723732,-96.91404749008316,32.8348903040354],[-96.91739345861302,32.83224567237309,-96.913948485233,32.83514030403527],[-96.91706647461668,32.83307067237271,-96.91362146922707,32.8359653040349],[-96.91653250164006,32.834463672372095,-96.9130874421998,32.837358304034275],[-96.9164765058305,32.83467967237199,-96.91303143800873,32.83757430403418],[-96.91637951615161,32.83521167237174,-96.91293442768618,32.83810630403393],[-96.91633953285606,32.83607267237135,-96.91289441097933,32.83896730403354],[-96.91631755305369,32.837113672370904,-96.91287239077879,32.840008304033084],[-96.91632557492107,32.83824067237039,-96.91288036890825,32.84113530403257],[-96.9163095944223,32.83924567236993,-96.91286434940422,32.842140304032114],[-96.91623460447406,32.83976367236969,-96.91278933935101,32.84265830403188],[-96.91614361330355,32.84021867236949,-96.9126983305203,32.84311330403167],[-96.91600662358866,32.840748672369244,-96.91256132023369,32.84364330403143],[-96.91581963286488,32.84122667236904,-96.91237431095611,32.84412130403122],[-96.91603859174447,32.83910767237,-96.91259335208244,32.842002304032185],[-96.91697559191913,32.83911667236998,-96.9135303519078,32.84201130403216],[-96.91858452594913,32.835716672371525,-96.91513941788722,32.838611304033705],[-96.9190995282191,32.83583367237147,-96.91565441561694,32.83872830403365],[-96.91685151514275,32.83515967237178,-96.91340642869514,32.838054304033946],[-96.91613251465776,32.83513467237179,-96.91268742918024,32.83802930403398],[-96.91698558986222,32.83901067237003,-96.91354035396496,32.84190530403222],[-96.9160465897846,32.83900667237004,-96.91260135404258,32.84190130403221],[-96.91625052043919,32.83543267237165,-96.91280542339794,32.83832730403384],[-96.91670952055561,32.83543867237165,-96.91326442328152,32.83833330403383],[-96.91672551824689,32.83531967237171,-96.91328042559057,32.83821430403389],[-96.91624851816928,32.8353156723717,-96.91280342566819,32.83821030403389]];

sub flat{
    return map { ref eq 'ARRAY' ? @$_ : $_ } @_;
}

sub assertErr( $actual, $expected, $maxErr, $description, $type='number')
	{
    if ( ! looks_like_number($actual) || ! looks_like_number($expected)) { die "$description produced NaN" };
    my $err = $type eq 'number' ? abs(($actual - $expected) / $expected) : abs( ( $actual-$expected ) / 360);
	my $msg = sprintf ( "%-30.30s a=%10.5f   e=%10.5f   ratio =%10.5f", $description, $actual, $expected, $err);
    if ($err > $maxErr) {
		warn ". err: $msg limit= $maxErr\n"
		}
	else
		{
		warn ". ok : $msg\n";
		}
}

##
my @points		= &flat ( @{ $lines } );

my $ruler		= CheapRuler->new( 32.8351 );
my $miles_ruler	= CheapRuler->new( 32.8351, 'miles');


warn "#1 distance\n";

{
my $actual = 0;

for ( my $i = 0; $i < scalar( @points ) - 1; $i++) {
	$actual += $ruler->distance( $points[$i], $points[$i + 1]);
	}

assertErr(39.636521117030824, $actual, 0.003, 'distance'); #distance within 0.3%
}

warn "#2 distance over dateline\n";

{
my $p0 = [179.9, 32.7];
my $p1 = [-179.9, 32.9];
my $actual = $ruler->distance($p0, $p1);
assertErr(29.051939213242004, $actual, 0.001, 'distance over dateline'); 
}

warn "#3 distance in miles\n";

{
    my $d = $ruler->distance([30.5, 32.8351], [30.51, 32.8451]);
    my $d2 = $miles_ruler->distance([30.5, 32.8351], [30.51, 32.8451]);

    assertErr( $d / $d2, 1.609344, 1e-12, 'distance in miles');
}

warn "#4 bearing\n";

{
    for (my $i = 0; $i < $#points; $i++) {
        my $expected = $bearing->[ $i ];
        my $actual = $ruler->bearing( $points[$i], $points[$i + 1]);
        assertErr($expected, $actual, 0.005, "bearing $i", 'degrees');
    }

}

warn "#5 bearing over dateline\n";
{
    my $p0 = [179.9, 32.7];
    my $p1 = [-179.9, 32.9];
    my $actual = $ruler->bearing($p0, $p1);
    assertErr(39.995159766887575, $actual, 0.005, 'bearing datetime', 'degrees');
}


warn "#6 destination\n";
{
    for (my $i = 0; $i < scalar @points; $i++) {
        my $bearing = ($i % 360) - 180;
        my $actual = $ruler->destination($points[$i], 1.0, $bearing);
        assertErr($dest->[$i][0], $actual->[0], 1e-6, "destination $i longitude");
        assertErr($dest->[$i][1], $actual->[1], 1e-6, "destination $i latitude");
    }
 
}

warn "#7 lineDistance\n";
{
    for (my $i = 0; $i < scalar @{$lines}; $i++) {
        
        my $actual = $ruler->lineDistance( $lines->[$i]);
        assertErr($line_d->[$i], $actual, 0.003, "lineDistance $i");
    }

}

warn "#8 area\n";
{
    for (my $i = 0; $i < scalar @{$lines}; $i++) {

        if (scalar @{ $lines->[$i] } < 3) { next };
		
        my $actual = $ruler->area( [ $lines->[$i] ] );
        assertErr($area->[$i], $actual, 0.003, "area $i");
    }
}

warn "#9 along\n";
{
    for (my $i = 0; $i < scalar @{$lines}; $i++) {
        my $actual = $ruler->along($lines->[$i], $along_d->[$i]);
        assertErr($along_e->[$i][0], $actual->[0], 1e-6, "along $i lon");
        assertErr($along_e->[$i][1], $actual->[1], 1e-6, "along $i lat");
    }

}

warn "#9 along, before 1st point\n";
{
	my $actual = $ruler->along( $lines->[0], -5 );

	assertErr($lines->[0][0][0], $actual->[0], 1e-6, "along fist lon");
    assertErr($lines->[0][0][1], $actual->[1], 1e-6, "along first lat");
}

warn "#10 along, after last point\n";
{
	my $actual = $ruler->along( $lines->[0], 1000);

	my $lp = $#{ $lines->[0] };

	assertErr($lines->[0][$lp][0], $actual->[0], 1e-6, "along after lon");
    assertErr($lines->[0][$lp][1], $actual->[1], 1e-6, "along after lat");
}

warn "#11 along over dateline\n";
{
    my $line = [[179.9, 32.7], [-179.9, 32.9]];
   
    my $dist = 9.683979737747334;
    my $actual = $ruler->along($line, $dist);

	assertErr(179.96672246608756, $actual->[0], 1e-6, "along after lon");
    assertErr(32.76672246608757, $actual->[1], 1e-6, "along after lat");

};

warn "#12 pointToSegmentDistance\n";
{
    my $p = [-77.034076, 38.882017];
    my $p0 = [-77.031669, 38.878605];
    my $p1 = [-77.029609, 38.881946];
    my $distance = $ruler->pointToSegmentDistance($p, $p0, $p1);
	assertErr(0.37461484020420416, $distance, 1e-6, "point to seg distance");
};

warn "#13 pointOnLine\n";
{
    #not Turf comparison because pointOnLine is bugged https://github.com/Turfjs/turf/issues/344
    my $line = [[-77.031669, 38.878605], [-77.029609, 38.881946]];
    my $result = $ruler->pointOnLine( $line, [-77.034076, 38.882017]);

   
	assertErr(-77.03052689033436,	$result->{point}[0], 1e-6, "pointOnLine lon");
	assertErr(38.880457324462576,	$result->{point}[1], 1e-6, "pointOnLine lat");
	assertErr(1, 					$result->{index} == 0 ? 1 : -1, 1e-6, "pointOnLine index");
	assertErr(0.5544221677861756,	$result->{t}, 1e-6, "pointOnLine t");

	my $t1 = $ruler->pointOnLine( $line, [-80, 38])->{t};
	my $t2 = $ruler->pointOnLine( $line, [-75, 38])->{t};

	assertErr(1, $t1 < 0 ? -1 : 1, 1e-6, "pointOnLine t not less than 0");
	assertErr(1, $t2 > 1 ? -1 : 1, 1e-6, "pointOnLine t not bigger than 1");

};

warn "#14 pointOnLine over dateline\n";
{
    my $line = [[179.9, 32.7], [-179.9, 32.9]];
    my $actual = $ruler->pointOnLine($line, [180, 32.7]);

	assertErr(179.9416136283502, $actual->{point}[0], 1e-6, "pointOnLine dl lon");
	assertErr(32.7416136283502,	$actual->{point}[1], 1e-6, "pointOnLine dl lat");
}

warn "#15 lineSlice\n";
{
    for (my $i = 0; $i < scalar @{$lines}; $i++) {
        my $line = $lines->[$i];
        my $dist = $ruler->lineDistance($line);
        my $start = $ruler->along($line, $dist * 0.3);
        my $stop = $ruler->along($line, $dist * 0.7);
        my $actual = $ruler->lineDistance( $ruler->lineSlice($start, $stop, $line));

        assertErr( $lineslice->[$i], $actual, 1e-5, "lineSlice $i");
		}
};



warn "#16 lineSliceAlong\n";
{
    for (my $i = 0; $i < scalar @{ $lines }; $i++) {
        if ($i == 46) { next }; # skip due to Turf bug https://github.com/Turfjs/turf/issues/351

        my $line = $lines->[$i];
        my $dist = $ruler->lineDistance($line);
        #my $start = $ruler->along($line, $dist * 0.3);
        #my $stop = $ruler->along($line, $dist * 0.7);

        my $actual = $ruler->lineDistance( $ruler->lineSliceAlong($dist * 0.3, $dist * 0.7, $line) );

        assertErr( $lineslicealong->[$i], $actual, 1e-5, "lineSliceAlong $i");
    }
}

warn "#17 lineSlice reverse\n";
{
    my $line = $lines->[0];
    my $dist = $ruler->lineDistance($line);
    my $start = $ruler->along($line, $dist * 0.7);
    my $stop = $ruler->along($line, $dist * 0.3);
    my $actual = $ruler->lineDistance($ruler->lineSlice($start, $stop, $line));
    assertErr($actual, 0.018676476689649835, 1e-5, 'lineSlice reversed length');
}

warn "#18 bufferPoint\n";
{
    for (my $i = 0; $i < scalar @points; $i++) {
    
        my $actual = $miles_ruler->bufferPoint( $points[$i], 0.1);
        assertErr( $bufferpoint->[$i][0], $actual->[0], 2e-7, "bufferPoint $i west");
        assertErr( $bufferpoint->[$i][1], $actual->[1], 2e-7, "bufferPoint $i east");
        assertErr( $bufferpoint->[$i][2], $actual->[2], 2e-7, "bufferPoint $i south");
        assertErr( $bufferpoint->[$i][3], $actual->[3], 2e-7, "bufferPoint $i north");
    }
};

warn "#19 bufferBBox\n";
{
    my $bbox = [30, 38, 40, 39];
    my $actual = $ruler->bufferBBox($bbox, 1);
	assertErr( 29.989319282570946, $actual->[0], 2e-7, "bufferBBox west");
    assertErr( 37.99098299160844, $actual->[1], 2e-7, "bufferBBox east");
    assertErr( 40.010680717429054, $actual->[2], 2e-7, "bufferBbox south");
    assertErr( 39.00901700839156, $actual->[3], 2e-7, "bufferBbox north");
}

warn "#20 insideBBox\n";
{
    my $bbox = [30, 38, 40, 39];
    assertErr( 1,  $ruler->insideBBox( [35, 38.5], $bbox), 1e-6, 'insideBBox inside');
    assertErr( 1, ! $ruler->insideBBox( [45, 45], $bbox),  1e-6, 'insideBBox outside');
}

warn "#21 insideBBox over dateline\n";
{
    assertErr( 1, $ruler->insideBBox( [180, 32.8], [179.9, 32.7, -179.9, 32.9] ), 1e-6, 'insideBBox dateline'  );
}

warn "#22 cheapRuler.fromTile\n";
{
    my $ruler1 = CheapRuler->new(50.5, 'kilometers');
    my $ruler2 = CheapRuler::fromTile(11041, 15, 'kilometers');

    my $p1 = [30.5, 50.5];
    my $p2 = [30.51, 50.51];

    assertErr( $ruler1->distance($p1, $p2), $ruler2->distance($p1, $p2), 2e-5, 'cheapRuler.fromTile distance');

}

warn "#23 cheapRuler.units\n";
{
	my $units = CheapRuler::units();

    assertErr( $units->{kilometers}, 1, 1e-6, 'units km' );
}
