# Generated by default/object.tt
package Paws::SecurityHub::AwsAutoScalingAutoScalingGroupDetails;
  use Moose;
  has CreatedTime => (is => 'ro', isa => 'Str');
  has HealthCheckGracePeriod => (is => 'ro', isa => 'Int');
  has HealthCheckType => (is => 'ro', isa => 'Str');
  has LaunchConfigurationName => (is => 'ro', isa => 'Str');
  has LoadBalancerNames => (is => 'ro', isa => 'ArrayRef[Str|Undef]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsAutoScalingAutoScalingGroupDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsAutoScalingAutoScalingGroupDetails object:

  $service_obj->Method(Att1 => { CreatedTime => $value, ..., LoadBalancerNames => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsAutoScalingAutoScalingGroupDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->CreatedTime

=head1 DESCRIPTION

Provides details about an auto scaling group.

=head1 ATTRIBUTES


=head2 CreatedTime => Str

Indicates when the auto scaling group was created.

Uses the C<date-time> format specified in RFC 3339 section 5.6,
Internet Date/Time Format
(https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
contain spaces. For example, C<2020-03-22T13:22:13.933Z>.


=head2 HealthCheckGracePeriod => Int

The amount of time, in seconds, that Amazon EC2 Auto Scaling waits
before it checks the health status of an EC2 instance that has come
into service.


=head2 HealthCheckType => Str

The service to use for the health checks.


=head2 LaunchConfigurationName => Str

The name of the launch configuration.


=head2 LoadBalancerNames => ArrayRef[Str|Undef]

The list of load balancers associated with the group.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

