# Generated by default/object.tt
package Paws::MediaConvert::OpusSettings;
  use Moose;
  has Bitrate => (is => 'ro', isa => 'Int', request_name => 'bitrate', traits => ['NameInRequest']);
  has Channels => (is => 'ro', isa => 'Int', request_name => 'channels', traits => ['NameInRequest']);
  has SampleRate => (is => 'ro', isa => 'Int', request_name => 'sampleRate', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaConvert::OpusSettings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaConvert::OpusSettings object:

  $service_obj->Method(Att1 => { Bitrate => $value, ..., SampleRate => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaConvert::OpusSettings object:

  $result = $service_obj->Method(...);
  $result->Att1->Bitrate

=head1 DESCRIPTION

Required when you set Codec, under AudioDescriptionsE<gt>CodecSettings,
to the value OPUS.

=head1 ATTRIBUTES


=head2 Bitrate => Int

Optional. Specify the average bitrate in bits per second. Valid values
are multiples of 8000, from 32000 through 192000. The default value is
96000, which we recommend for quality and bandwidth.


=head2 Channels => Int

Specify the number of channels in this output audio track. Choosing
Mono on the console gives you 1 output channel; choosing Stereo gives
you 2. In the API, valid values are 1 and 2.


=head2 SampleRate => Int

Optional. Sample rate in hz. Valid values are 16000, 24000, and 48000.
The default value is 48000.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaConvert>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

