# Generated by default/object.tt
package Paws::MediaConnect::MediaStream;
  use Moose;
  has Attributes => (is => 'ro', isa => 'Paws::MediaConnect::MediaStreamAttributes', request_name => 'attributes', traits => ['NameInRequest']);
  has ClockRate => (is => 'ro', isa => 'Int', request_name => 'clockRate', traits => ['NameInRequest']);
  has Description => (is => 'ro', isa => 'Str', request_name => 'description', traits => ['NameInRequest']);
  has Fmt => (is => 'ro', isa => 'Int', request_name => 'fmt', traits => ['NameInRequest'], required => 1);
  has MediaStreamId => (is => 'ro', isa => 'Int', request_name => 'mediaStreamId', traits => ['NameInRequest'], required => 1);
  has MediaStreamName => (is => 'ro', isa => 'Str', request_name => 'mediaStreamName', traits => ['NameInRequest'], required => 1);
  has MediaStreamType => (is => 'ro', isa => 'Str', request_name => 'mediaStreamType', traits => ['NameInRequest'], required => 1);
  has VideoFormat => (is => 'ro', isa => 'Str', request_name => 'videoFormat', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaConnect::MediaStream

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaConnect::MediaStream object:

  $service_obj->Method(Att1 => { Attributes => $value, ..., VideoFormat => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaConnect::MediaStream object:

  $result = $service_obj->Method(...);
  $result->Att1->Attributes

=head1 DESCRIPTION

A single track or stream of media that contains video, audio, or
ancillary data. After you add a media stream to a flow, you can
associate it with sources and outputs on that flow, as long as they use
the CDI protocol or the ST 2110 JPEG XS protocol. Each source or output
can consist of one or many media streams.

=head1 ATTRIBUTES


=head2 Attributes => L<Paws::MediaConnect::MediaStreamAttributes>

Attributes that are related to the media stream.


=head2 ClockRate => Int

The sample rate for the stream. This value is measured in Hz.


=head2 Description => Str

A description that can help you quickly identify what your media stream
is used for.


=head2 B<REQUIRED> Fmt => Int

The format type number (sometimes referred to as RTP payload type) of
the media stream. MediaConnect assigns this value to the media stream.
For ST 2110 JPEG XS outputs, you need to provide this value to the
receiver.


=head2 B<REQUIRED> MediaStreamId => Int

A unique identifier for the media stream.


=head2 B<REQUIRED> MediaStreamName => Str

A name that helps you distinguish one media stream from another.


=head2 B<REQUIRED> MediaStreamType => Str

The type of media stream.


=head2 VideoFormat => Str

The resolution of the video.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaConnect>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

