
package Paws::KinesisAnalytics::ListApplications;
  use Moose;
  has ExclusiveStartApplicationName => (is => 'ro', isa => 'Str');
  has Limit => (is => 'ro', isa => 'Int');

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'ListApplications');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::KinesisAnalytics::ListApplicationsResponse');
  class_has _result_key => (isa => 'Str', is => 'ro');
1;

### main pod documentation begin ###

=head1 NAME

Paws::KinesisAnalytics::ListApplications - Arguments for method ListApplications on L<Paws::KinesisAnalytics>

=head1 DESCRIPTION

This class represents the parameters used for calling the method ListApplications on the
L<Amazon Kinesis Analytics|Paws::KinesisAnalytics> service. Use the attributes of this class
as arguments to method ListApplications.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to ListApplications.

=head1 SYNOPSIS

    my $kinesisanalytics = Paws->service('KinesisAnalytics');
    my $ListApplicationsResponse = $kinesisanalytics->ListApplications(
      ExclusiveStartApplicationName => 'MyApplicationName',    # OPTIONAL
      Limit                         => 1,                      # OPTIONAL
    );

    # Results:
    my $ApplicationSummaries = $ListApplicationsResponse->ApplicationSummaries;
    my $HasMoreApplications  = $ListApplicationsResponse->HasMoreApplications;

    # Returns a L<Paws::KinesisAnalytics::ListApplicationsResponse> object.

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.
For the AWS API documentation, see L<https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics/ListApplications>

=head1 ATTRIBUTES


=head2 ExclusiveStartApplicationName => Str

Name of the application to start the list with. When using pagination
to retrieve the list, you don't need to specify this parameter in the
first request. However, in subsequent requests, you add the last
application name from the previous response to get the next page of
applications.



=head2 Limit => Int

Maximum number of applications to list.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method ListApplications in L<Paws::KinesisAnalytics>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

