# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

BEGIN { $| = 1; print "1..2\n"; }
END {print "not ok 1\n" unless $loaded;}
use Lingua::DE::Sentence;
$loaded = 1;
print "ok 1\n";

######################### End of black magic.

# Insert your test code below (better if it prints "ok 13"
# (correspondingly "not ok 13") depending on the success of chunk 13
# of the test code):

use Lingua::DE::Sentence qw(get_sentences);

$splitting = 1;
$test_data = join ("", (<DATA>));
while ($test_data =~ m%\|([^\|]*?)\|%g) {
    push @exp_sent, $1;
}
$test_data =~ s/\|//g;
$real_sent = get_sentences($test_data);

for ($i=0; $i<scalar @exp_sent; $i++) {
    unless ($exp_sent[$i] eq $real_sent->[$i]) {
	print 
	    "not ok 2 ",
	    "Splitting is not correct: ",
	    "expected:  $exp_sent[$i] ",
	    "but found: $real_sent->[$i]";
	$splitting = 0;
	last;
    }
}
print "ok 2\n" if $splitting;

__DATA__

 |Durch den 1781 von Herschel entdeckten Planeten Uranus wurde der Horizont des Planetensystems unserer Sonne um das Doppelte erweitert.| |Dieser Planet ist nmlich noch einmal so weit als Saturn - 400Millionen Meilen von der Sonne entfernt.| |Er vollendet seine lange Reise um die Sonne erst in 84Jahren und 6Trabanten umkreisen ihn.| |Die Entdeckung der vier kleinen Planeten, durch welche die frher unterbrochene harmonische Progression in den Abstnden der Planeten, sich vollstndiger zu besttigen scheint, verdanken wir den Deutschen.| |Piazzi, in Deutschland geboren, entdeckte am 1tenJan. 1801 zu Palermo glcklich einen zwischen Mars und Jupiter frher vermutheten Planeten, dem er den Namen Ceres beilegte.| |Kaum 1Jahre nachher hatte Olbers in Bremen das Glck einen 2ten planetarischen Krper zwischen Mars und Jupiter aufzufinden, den er Pallas nannte.| |Am 1tenSeptbr. 1804 entdeckte Prof. Harding zu Lilienthal einen dritten neuen Planeten, ungefhr in demselben mittleren Abstande von der Sonne als Ceres und Pallas.| |Man hat ihn Juno genannt.| - |Endlich hat Olbers am 29tenMaerz 1807 abermals einen 4ten Planeten zwischen Mars und Jupiter entdeckt, der von dem groen Gaus in Goettingen den Namen Vesta erhielt.| |Auer diesen nunmehr bekannten Haupt und Nebenplaneten gibt es im weiten Reiche unserer Sonne noch eine ungleich grere Anzahl anderer Weltkrper welche mehrentheils in langen elliptischen Bahnen sich um die Sonne drehen.| |Dies sind die Kometen.| |Ueber diese hat sich neuerlich die Meinung der Astronomen sehr gendert.| |Jener Gedanke namentlich, da sie ein Planetensystem mit dem andern verbinden, ist ganz verschwunden; obgleich einige sich sehr weit von der Sonne entfernen mssen, indem ihre Sonnennhe zwischen Jupiter und Saturn liegt.| - |Man hat bis jetzt Kometen welche von der Erde aus sichtbar gewesen sind 400 beobachtet, nur 128 wirklich gemessen.| |Rechnen wir aber alle dazu, welche auerhalb der Erde ihre Bahnen ziehen, so kann ihre Zahl leicht auf einige l00,000 gesteigert werden, welche alle zu unserm Planetensystem gehren.| - |Die wichtigste Entdeckung in dieser Hinsicht machte in der neuesten Zeit unser Astronom Enke.| |Er berechnete die Bahn eines Kometen, der in 3Jahrn seinen Umlauf vollendet.| |Bei seinem letzten Erscheinen hatte er sein Wiederkommen genau vorhergesagt, und es entdeckte ihn zuerst Rhmker in Paramatta auf Neuholland.| |Nur fand man, da er sich ein wenig versptet hatte, und dies fhrte auf die bewegungshemmende Eigenschaft des Aethers.| |Dieser Komet ist nun schon 5mal beobachtet.| - |Der Hauptmann Biela in Bhmen entdeckte spter einen 2ten Kometen, der in 6Jahren seinen Weg um die Sonne zurcklegt.| - |Der berhmte Halley sagte die Wiederkunft eines Kometen auf das Jahr 1759 voraus, den der sternkundige Landmann Palitsch bei Dresden wirklich am 25Decbr. 1758 zuerst wiedersehe.| |Htte man damals die Masse des Jupiters und Saturns genauer und die Existenz des Uranus gekannt, so wrde man eine Genauigkeit von 5-6 Tagen erreicht haben.| |Von allen Kometen welche beobachtet, und deren Bahnen berechnet worden, ist keiner unserer Erde so nahe gekommen, als der von Biela entdeckte; und allerdings knnte uns dieser gefhrlich werden, da man berechnet hat, da einer seiner Knoten wirklich innerhalb der Erdbahn liegt.| |Die groe Leichtigkeit dieser Weltkrper kann uns jedoch von aller Besorgni befreien; denn man hat nachgewiesen, da einer derselben (der von 1770) durch das Trabantensystem des Jupiter gegangen ist, ohne dasselbe im mindesten in Unordnung zu bringen.| |Die Dichtigkeit der Kometen betrgt 1/5000 von der Dichtigkeit der Erde.| |Sie sind also noch weit dnner, als die dnnste Luft, welche wir unter der Luftpumpe hervorbringen knnen.| |Zu den merkwrdigsten, bisher noch keineswegs gengend erklrten Erscheinungen gehren die Aerolithen, jene greren und kleineren Steinmassen, welche aus den Himmelsrumen zu uns herabkommen.| |Chladni hat das Verdienst, auf dieses schon den Alten unter dem Namen von Steinregen bekannte Phnomen, von neuem aufmerksam gemacht, und neue Erfahrungen darber gesammelt zu haben.| |Die verschiedensten Hypothesen sind aufgestellt worden, um den Ursprung dieser Massen zu erklren, die in den meisten Fllen aus terrestrischen Stoffen (Eisen, Nickel etc) gebildet scheinen, und in denen Gustav Rose sogar das Vorkommen crystallinischer Theile nachgewiesen hat.| - |Einige haben sie fr vulkanische Auswrfe der Erde erklren wollen; andere sie fr Producte von Mondseruptionen gehalten, welche wahrscheinlichere Meinung in der auf dem Monde 5mal geringeren Schwere, und der groen Feinheit seiner Atmosphre, die der Bewegung keinen merklichen Widerstand entgegen setzen kann, einen Sttzpunkt findet.| - |Die Annahme, da die Bestandtheile dieser Massen, sich aufgelst im Luftkreise vorfinden sollten, und durch irgend eine elektrische Explosion, (die Feuerkugeln, welche die Erscheinung gewhnlich begleiten) im Moment des Herabfallens vereinigt wrden, hat wenig Haltbarkeit, da mindestens ein Raum von 4-5Meilen Luft erforderlich wre, um hnliche Massen aufgelst zu enthalten.| |Einige glauben Ueberbleibsel der ehemaligen chaotischen Massen darin zu erkennen, und wir mgten sie geradezu fr planetarische Weltkrper erklren, die gleich den brigen im Weltall kreisen, bis sie der Attractionssphre des Einen oder Andern sich nhernd, auf fremden Bahnen ihren Untergang finden.| |Die Kleinheit derselben darf dieser Annahme nicht entgegen stehen.| |Der kleinste Hauptplanet ist im Verhltni gegen den Syrius viel kleiner als der grte Aerolith im Vergleich mit der Vesta.| |Bei allen Messungen im Weltraume ist es weit interressanter die Gren und Zahlen in ihrer relativen Ausdehnung zu kennen, als in ihrer absoluten: gerade wie bei den Berghhen.| |Die Schneekoppe ist mal so hoch als der hchste Gipfel der Pyrenen; der Pic von Teneriffa  von der Spitze des Himalaya; der Brocken 1/6 des Chimborazo.| |So wird auch eine vergleichende Berechnung von der Gre des Weltraums, wie sie Herschel anstellte, hier an ihrem Platze seyn.| |Man setze den Durchmesser unseres Sonnensystems mit den uersten Kometenbahnen= 1Linie: so wird die grere Axe unserer linsenfrmigen Sternschicht= 260Fu seyn; und von uns bis zum fernsten Nebelfleck = 4geogr. Meilen.| |Die Sehweite des bewaffneten Auge ist also 4Meile, die des unbewaffneten in gleichem Verhltni 5Fu.| - |Man hat Infusionsthiere beobachtet, deren Durchmesser 1/1000 einer Linie betrgt.| |Diese verhalten sich zu einem Wallfisch von 60-70 Fu Lnge, wie der Durchmesser unseres Sonnensystems, zu der Entfernung desselben von den weitesten Nebelflecken.| |Bei allen diesen Erscheinungen ist natrlich eine Ungewiheit vorhanden, welche nur dadurch verringert wird, da man sie in ganz bestimmte Grnzen einschlieen lt.| |So wei man mit Bestimmtheit, da der Sirius 10,000mal weiter von uns entfernt ist als Uranus, weil seine Parallaxe noch nicht 1/5 Sek. betrgt.| - |Bei der Entfernung des Mondes von 51,000Meilen ist man nur um 14-15Meilen ungewi, welches so viel heit, als ob man bei der Hhe des Brockens 3200Fu, um 1-2Fu ungewi wre.| |Wenn wir nunmehr zu den tellurischen Verhltnissen bergehen, so mssen wir zuerst zwei flssige Hllen um den Erdkrper bemerken, die des Meeres und der Luft, wodurch man schon auf die Kugelgestalt der Erde gefhrt werden knnen.| |Schon Aristoteles stellt die Behauptung auf, da die Erde rund sey, weil man bei den Mondfinsternissen den Erdschatten rund in die Mondscheibe eintreten sieht.| |Die Erde hat aber keine vollkomne Kugelgestalt, mit gleichem Durchmesser, sondern bildet vielmehr ein Sphrod mit starker Abplattung an den Polen.| |Diese Abplattung ist bedeutender als man frher glaubte.| |Man nahm sie sonst zu 1/305-1/310 an.| |Jetzt wei man, da sie zwischen 1/289-1/290 liegt.| - |Eben so hielt man frher die Figur des Erdsphroids fr unregelmig, und glaubte die sdliche Hemisphre abgeplatteter als die nrdliche.| |Nach Freycinets und Duperrs sehr genauen Messungen ist erweislich dies nicht der Fall, und die Regelmigkeit dieser um so viel grer.| |Die specifische Dichtigkeit der Erde ist sehr betrchtlich; sie ist 4-5 mal grer als die des Wassers.| |Die Attraction der Berge, nach deren Einwirkung auf die Pendelschwingungen man die Schwere der Erde berechnet hat, gab verschiedene Resultate.| |In Schottland 4,7 schwerer als Wasser, am Mont Cnis 4,4 - nach Cavendish Erdwage 5,4.| |Das Mittel aus diesen verschiedenen Angaben wrde 4,8-5,0 ergeben.| |Von Cavendish der berhmte Versuche ber die Zersetzung des Wassers gemacht hat, sagt man: er habe das Wasser zerlegt und die Erde gewogen.| |Wir mssen aber annehmen, da im Innern der Erde eine grere Dichtigkeit herscht, als wir in den dichtesten Gebirgsarten antreffen.| |(Die magnetische Spannung der Erde uert sich horizontal und perpendikular, oft auch oscillirend, und wird durch die innere und uere Erwrmung vermehrt.| - |Die Versuche von Morechini in Rom haben bewiesen, da man kleine unmagnetische eiserne Nadeln, durch die Einwirkung der Sonnenstrahlen magnetisiren kann, und diese Versuche die bei der Einwirkung der italienischen Sonne nicht immer gelangen, sind von Miss Sommerville in London, mit vielem Glck wiederholt, nach Wollaston's unverwerflichem Zeugnis.| - |Wir mssen demnach unsere Erde in einer fortdauernd electro-magnetischen Spannung annehmen, und es ist sehr wahrscheinlich, da diese Spannung durch die Sonnenwrme erhalten wird, wie dies aus Seebeck's schner Entdeckung vom Thermomagnetismus, der durch ungleiche Erwrmung hervorgerufen wird, und aus anderweiten Beobachtungen der Miss Sommerville ber die Sonnenstrahlen hervorgeht.)| |400 Millionen Meilen = 3 Milliarden Kilometer Zurck 4-5 Meilen = 30-38 Kilometer Zurck 1 Linie = 2 Millimeter Zurck 260 Fu = 85 Meter Zurck 4 geogr. Meilen = 35 Kilometer Zurck 5Fu = 1,6 Meter Zurck 51,000 Meilen = 378,000 Kilometer Zurck 14-15 Meilen = 100-110 Kilometer Zurck 3200 Fu = 1040 Meter Zurck 1-2 Fu = 30-60 cm Zurck Vorige Seite Titelseite Nchste Seite|

|Entfhrung| 

|Willibald Alexis| 

|O Lady Judith, sprder Schatz, Drckt dich zu fest mein Arm?| |Je zwei zu Pferd haben schlechten Platz Und Winternacht weht nicht warm.| |Hart ist der Sitz und knapp und schmal, Und kalt mein Kleid von Erz, Doch klter und hrter als Sattel und Stahl War gegen mich dein Herz.| |Sechs Nchte lag ich in Sumpf und Moor Und hab' um dich gewacht, Doch weicher, bei Sankt Grg ich's schwor, Schlaf' ich die siebente Nacht!|
 |Zwei Krebse "Geh doch gerade und vorwrts!" rief einem jungen Krebs seine Mutter zu.| |"Von Herzen gerne, liebe Mutter", antwortete dieser, "nur mchte ich es dich ebenso machen sehen."| |Jedoch vergeblich war der Mutter Anstrengung und sichtbar ihre Klgelei und Tadelsucht.| |Gib keine Befehle, die man nicht vollbringen kann, und tadle an andern keine Fehler, die du selbst begehst!|
|Die alten und die jungen Frsche| 

|Abraham a Sancta Clara| 

|Die jungen Frsche haben einmal bei warmer Sommerzeit nchst einer Lache ber allen Maen gequackt und geschrien, also zwar, da ein alter Frosch selbst ber diese abgeschmackte Musik verdrssig geworden und die Jungen nicht wenig ausgefilzt hat.| |"Schamt euch, ihr grnhosenden Fratzen!" sagte er, "ihr wilden Lachendrescher, ihr hupfenden Spitzbuben, schamt euch, da ihr so ein verdrielich Geschrei vollfhrt!| |Wenn ihr aber doch wollt lustig sein und frohlocken, so singt aufs wenigst' wie die Nachtigall, wlche auf diesem nchsten Ast sitzt.| |Ihr gromaulenden Narren, knt ihr denn nichts anderes als nur das Qua-Qua-Qua?"| |"Vater", antworteten die Frsche, "das haben wir von dir gelernt."|
|Dr. Rentschler Dorithricin( Limone Halstabletten|

|Liebe Patientin, lieber Patient!|
|Bitte lesen Sie folgende Gebrauchsinformation aufmerksam, weil sie wichtige Informationen darber enthlt, was Sie bei der Anwendung dieses Arzneimittels beachten sollten.| |Wenden Sie sich bitte bei Fragen an Ihren Arzt oder Apotheker.|

|Gebrauchsinformation
Dorithricin( Limone Halstabletten
Zusammensetzung
1 Lutschtablette enthlt:
Arzneilich wirksame Bestandteile:
Tyrothricin			0,5 mg
Lidocainhydrochlorid 1H20	1,0 mg|

|Sonstige Bestandteile:
Povidon, Saccharin-Natrium, Sorbitol, Weinsure, Talkum, Saccharosestearat, Carmellose-Natrium, Aromen.|

|Darreichungsform und Inhalt
Originalpackung mit 20 (N1) Lutschtabletten|

|Stoff- oder Indikationsgruppe, Wirkungsweise
Dorithricin( Limone Halstabletten wirken zweifach bei schmerzhaften Entzndungen im Mund- und Rachenraum: Das Lokalansthetikum (rtliches Betubungsmittel) Lidocain lindert einerseits den Schmerz und die Schluckbeschwerden, andererseits bekmpft das Lokalantibiotikum Tyrothricin effektiv die krankheitsverursachenden Keime.|

|Pharmazeutischer Unternehmer und Hersteller
Dr. Rentschler Arzneimittel GmbH & Co.
Mittelstrae 18, 88471 Laupheim
Telefon (07392) 701-0, Telefax (07392) 701-300|

|Anwendungsgebiete
Entzndliche und infektise (ansteckende) Erkrankungen des Mund- und Rachenraums (Entzndungen der Mundschleimhaut und des Zahnfleisches, Mandelentzndungen und Mundsoor), Halsentzndungen, Kehlkopfentzndungen, Infektionen der oberen Luftwege.|
|Vor operativen Eingriffen im Mund und Rachen (Zahnextraktion, Entfernung der Gaumenmandeln).|

|Gegenanzeigen
Wann drfen Sie Dorithricin( Limone Halstabletten nicht anwenden?|
|Bei einer berempfindlichkeit gegen einen der Wirk- oder Hilfsstoffe von Dorithricin( Limone Halstabletten sollten Sie dieses Arzneimittel nicht anwenden.|
|Bei greren frischen Wunden im Mund- und Rachenraum sollten Sie Dorithricin( Limone Halstabletten nicht anwenden.|

|Wann drfen Sie Dorithricin( Limone Halstabletten erst nach Rcksprache mit Ihrem Arzt anwenden?|
|Im folgenden wird beschrieben, wann Sie Dorithricin( Limone Halstabletten nur unter bestimmten Bedingungen und nur mit besonderer Vorsicht anwenden drfen.| |Befragen Sie bitte hierzu Ihren Arzt.| |Dies gilt auch, wenn diese Angaben bei Ihnen frher einmal zutrafen.|
|Dorithricin( Limone Halstabletten enthalten Sorbitol.| |Bei angeborener Sorbitol- bzw. Fructose-Unvertrglichkeit sollten Sie vor der Anwendung Ihren Arzt befragen.| |Bei einer eitrigen Mandelentzndung mit Fieber ist in jedem Fall vom Arzt zu entscheiden, ob neben den primr notwendigen Behandlungsmanahmen wie z.B. einer zustzlichen Antibiotikagabe, Dorithricin( Limone Halstabletten angewendet werden sollen.|

|Was mssen Sie in Schwangerschaft und Stillzeit beachten?|
|Schdigende Wirkungen durch Dorithricin( Limone Halstabletten sind bisher nicht bekannt geworden.| |Aus grundstzlichen medizinischen berlegungen sollte jedoch auf eine strenge Indikationsstellung geachtet werden und vor der Anwendung in jedem Fall mit einem Arzt Rcksprache gehalten werden.|

|Was ist bei Kindern und lteren Menschen zu bercksichtigen?|
|Dorithricin( Limone Halstabletten sind fr Suglinge und Kleinkinder nicht geeignet, das die sachgeme Anwendung (Lutschen) nicht gewhrleistet ist.|

|Vorsichtsmanahmen fr die Anwendung und Warnhinweise
Worauf mssen Sie achten?|
|Hinweis fr Diabetiker
Der in einer Dorithricin( Limone Halstablette eingesetzte Zuckeraustauschstoff Sorbitol entspricht 0,07 BE.|

|Wechselwirkungen
Nicht bekannt.|

|Dosierungsanleitung, Art und Dauer der Anwendung
Die folgenden Angaben gelten, soweit Ihnen Ihr Arzt Dorithricin( Limone Halstabletten nicht anders verordnet hat.| |Bitte halten Sie sich an die Anwendungsvorschriften, da Dorithricin( Limone Halstabletten sonst nicht richtig wirken knnen.|

|Wie oft, in welcher Menge und wie sollten Sie Dorithricin( Limone Halstabletten anwenden?|
|Soweit nicht anders verordnet, lassen Erwachsene alle 2 Stunden, bis zu 8 mal tglich, eine Lutschtablette langsam im Mund zergehen.|
|Kinder erhalten bis zu 6 mal tglich eine Lutschtablette.|

|Wie lange sollten Sie Dorithricin( Limone Halstabletten anwenden?|
|Die Behandlung soll noch einen Tag nach abklingen der Beschwerden fortgesetzt werden.| |Bei schweren Halsentzndungen oder Halsschmerzen, die mit hohem Fieber, Kopfschmerzen, belkeit oder Erbrechen einhergehen, sollten Dorithricin( Limone Halstabletten nicht lnger als 2 Tage ohne rztlichen oder zahnrztlichen Rat angewendet werden.|

|Anwendungsfehler und berdosierung
Bis jetzt sind keine Vergiftungsflle nach Anwendung dieses Arzneimittels bekannt.|

|Was mssen Sie beachten, wenn Sie zu wenig Dorithricin( Limone Halstabletten angewendet oder eine Anwendung vergessen haben?|
|Dorithricin( Limone Halstabletten werden mehrmals tglich angewendet.| |Sollten Sie eine Anwendung vergessen haben, knnen Sie diese jederzeit nachholen.|

|Nebenwirkungen
Welche Nebenwirkungen knnen bei der Anwendung von Dorithricin( Limone Halstabletten auftreten?|
|In seltenen Fllen kann es zu berempfindlichkeitsreaktionen oder zu einer Sensibilisierung im Mundbereich kommen.|
|Wenn Sie Nebenwirkungen bei sich beobachten, die nicht in dieser Packungsbeilage aufgefhrt sind, teilen Sie diese bitte Ihrem Arzt oder Apotheker mit.|

|Hinweise und Angaben zur Haltbarkeit des Arzneimittels
Das Verfallsdatum dieses Arzneimittels ist auf der Verpackung aufgedruckt.| |Verwenden Sie das Arzneimittel nicht mehr nach diesem Datum!|

|Achten Sie stets darauf, das Arzneimittel so aufzubewahren, da es fr Kinder nicht zu erreichen ist!|

|Stand der Information
Juni 1998|

|Liebe Patientin, lieber Patient,
im Mund-Rachenraum leben stndig mehr Keime als Menschen in der Riesenstadt New York.| |Das Abwehrsystem des Krpers, effektiv wie eine Polizeitruppe, sorgt dafr, da alle Keimarten in einem ausgewogenen Gleichgewichtsverhltnis zueinander bleiben und dadurch keine Krankheiten auslsen knnen.| |Erst Strungen von auen, kleine Verletzungen etwa, eine Invasion fremder Krankheitserreger durch Ansteckung, oder auch Schwchen im Abwehrsystem knnen die friedliche Situation pltzlich verndern.| |Dann finden einzelne Keimarten Gelegenheit, sich in gefhrlichem Mae zu vermehren und uerst aggressiv gegen den Krper zu werden.|
|Wegen der reichlichen Versorgung der Mundhhle mit Nerven machen sich solche Geschehnisse durch Schmerzen und Krankheitsgefhl bald bemerkbar.| |Der Krper wehrt sich so gut er kann durch vermehrtes Heranfhren von Abwehrstoffen mit dem Blutstrom.| |Das Gewebe im Mund und Rachen schwillt an, entzndet und rtet sich.| |Es bilden sich Belge auf der Schleimhaut.| |Sptestens jetzt ist es notwendig, energisch einzugreifen und den Krper zu untersttzen.| |Dorithricin( Limone Halstabletten bekmpfen die Krankheitserreger intensiv und dmpfen zugleich die Schmerzen nachhaltig.| |Ihr Organismus wird rascher und besser mit der Erkrankung fertig.| |Wenn Sie sich an die Einnahmevorschrift halten, wird der Erfolg nicht ausbleiben.| |Ist trotz richtiger Einnahme nach 2-3 Tagen keine durchgreifende Besserung festzustellen, sollten Sie den Arzt aufsuchen.|
|Dorithricin( Limone Halstabletten sind zuckerfrei und damit zahnschonend und fr Diabetiker geeignet.|

|Wir wnschen Ihnen gute Besserung!|
|Ihre Dr. Rentschler Arzneimittel GmbH & Co.|


                       |Logische Optimierung| 


|Logische Optimierung 
Hhere, nichtprozedurale Abfragesprachen (SQL, 
QBE, ...) verlangen keine Kenntnisse des 
Benutzers ber die Implementierung, mssen aber 
in prozedurale Form (z. B. Relationenalgebra) 
umgesetzt werden.|  
 
|Um trotzdem effiziente Bearbeitung von Queries zu 
erzielen wird die gestellte Anfrage intern 
umformuliert und verbessert.| |Diesen Vorgang 
nennt man Query Optimization.|  
|Im allgemeinen wird keine optimale Lsung erzielt, 
sondern nur eine Verbesserung.| 













|Grundlagen der Datenbanksysteme I1| 



                       |Logische Optimierung| 

                                  
                                  
   
                  |Query (z.B. SQL)| 

       |Query Prozessor| 

          ??|Analyse 
          ??||Umwandlung in relationale Algebra 
          ??||Datenzugriff 
          ??||Ausfhrung|                           
















|Grundlagen der Datenbanksysteme I2| 



                       |Logische Optimierung| 

|Fragen: 
     Welche Operationen bentigen viel Zeit fr ihre 
     Ausfhrung?| 
      
     |Knnen diese vermieden werden, indem man 
     die Anfrage neu formuliert?| 
       
|Beispiel: 
Gegeben sei folgender relationaler Ausdruck: 
                 ?||A(? B=C?||D="99" (AB ?| |CD)) 
Dieser offensichtlich teuere Ausdruck (wg. 
kartesichem Produkt) kann besser formuliert 
werden: 
                ?||A(? B=C(AB ? ?| |D="99" (CD)))
Das kartesische Produkt in dieser Abfrage ist 
offensichtlich durch die Selektion ber B=C 
quivalent zu einem Gleichverbund: 
                 ?||A(AB [B=C] ?| |D="99" (CD))| 







|Grundlagen der Datenbanksysteme I3| 



                       |Logische Optimierung| 

|Grundlegende Aspekte 
Zu betrachten sind fr eine Optimierung die fnf 
Grundoperationen.| |Wo liegt ihr Schwachpunkt und 
wie knnen diese Schwachpunkte umgangen 
werden?| 
 
??|Die auf jeden Fall aufwendigste Operation ist das 
     kartesische Produkt bzw. der Verbund:  
     Bei einfachster Implementierung eines 
     Verbundes zwischen A und B erfolgt ein 
     Durchlauf aller Tupel von B fr jedes Tupel von A. 
     Dies ist ein Aufwand mit o(nm).| 
??|Die Projektionen sind aufwendig durch das 
     Entfernen von Duplikaten.| 
??|Die Selektionen sollte man so frh wie mglich 
     durchfhren, da dies zu kleineren 
     Zwischenresultaten fhrt.| 











|Grundlagen der Datenbanksysteme I4| 



                       |Logische Optimierung| 

 
??|Die unren Operationen (Projektion/Selektion) 
     bedingen je einen Durchlauf aller Tupel, daher 
     mehrere mglichst zusammenziehen oder mit 
     einer binren Operation zusammenfassen.| 
??|Nach gemeinsamen Teilausdrcken suchen, 
     damit diese nur einmal abgearbeitet werden.|
??|Eventuell temporre Verwendung bestimmter 
     Dateiorganisationen (Indizes, Sortieren) einfhren  
     ?|  |Physische Optimierung| 
      
|Der Zeitaufwand fr das Untersuchen der 
verschiedenen Mglichkeiten ist im allgemeinen 
viel geringer als fr das Durchfhren einer 
ineffizienten Query.| |Daher wird die Optimierung 
immer durchgefhrt!| 












|Grundlagen der Datenbanksysteme I5| 



                       |Logische Optimierung| 

|Algebraische Manipulation 
??||Gesetze der relationalen Algebra.| 
??|quivalenz von Ausdrcken.| 
  |Es gilt E1 ?|  |E2 falls sie dieselbe Abbildung 
  reprsentieren, d.h. falls dieselben Relationen fr 
  identische Bezeichnungen in den beiden 
  Ausdrcken eingesetzt werden, erhallten wir 
  gleiche Ergebnisse.| 

|A. ist sehr aufgeblasen, er glaubt im Guten weit vorgeschritten zu sein, da er, offenbar als ein immer verlockenderer Gegenstand immer mehr Versuchungen aus ihm bisher ganz unbekannten Richtungen sich ausgesetzt fhlt.| |Die richtige Erklrung ist aber die, da ein groer Teufel in ihm Platz genommen hat und die Unzahl der Kleineren herbeikommt, um dem Groen zu dienen.|
|Verschiedenheit der Anschauungen, die man etwa von einem Apfel haben kann: die Anschauung des kleinen Jungen, der den Hals strecken mu, um noch knapp den Apfel auf der Tischplatte zu sehn und die Anschauung des Hausherrn, der den Apfel nimmt und frei dem Tischgenossen reicht.|

|Zum letztenmal Psychologie!|
|Zwei Aufgaben des Lebensanfangs: Deinen Kreis immer mehr einschrnken und immer wieder nachprfen, ob Du Dich nicht irgendwo auerhalb Deines Kreises versteckt hltst.|
|Das Bse ist manchmal in der Hand wie ein Werkzeug, erkannt oder unerkannt, lt es sich, wenn man den Willen hat, ohne Widerspruch zur Seite legen.|
|Die Freuden dieses Lebens sind nicht die seinen, sondern unsere Angst vor dem Aufsteigen in ein hheres Leben; die Qualen dieses Lebens sind nicht die seinen, sondern unsere Selbstqual wegen jener Angst.|

|Kannst Du denn etwas anderes kennen als Betrug?| |Wird einmal der Betrug vernichtet darst Du ja nicht hinsehn oder Du wirst zur Salzsule.|
|Alle sind zu A. sehr freundlich, so etwa wie man ein ausgezeichnetes Billard selbst vor guten Spielern sorgfltig zu bewahren sucht, solange bis der groe Spieler kommt, das Brett genau untersucht, keinen vorzeitigen Fehler duldet, dann aber, wenn er selbst zu spielen anfngt, sich auf die rcksichtsloseste Weise auswtet.|
|"Dann aber kehrte er zu seiner Arbeit zurck, so wie wenn nichts geschehen wre."| |Das ist eine Bemerkung, die uns aus einer unklaren Flle alter Erzhlungen gelufig ist, trotzdem sie vielleicht in keiner vorkommt.|


|9.)| |Das Lager der PDS-Wahler schliet offenkundig auch Menschen ein, die 1989 gegen den SED-Staat aufstanden (,,Wir sind ein Volk!").| |Der Hauptgrund fr ihr Verhalten heute ist die Enttuschung ber das verweigerte Gefhl, mit der Wiedervereinigung endlich zu Hause angekommen zu sein.| |Mit der Vereinigung in einem Staat ging nicht eine Einheit im Fhlen und Wollen einher.| |Verweigerung der nationalen Solidaritt erzeugt ein Trauma.| |Whrend in Mittel- und Osteuropa der Vlkerfrhling einzog und die multinationalen Zwangsgebilde zum Einsturz brachte, sa die westdeutsche politische Klasse in einem antinationalen Getto, von einem postnationalen Zeitalter trumend; ihr fehlendes positives Verhltnis zur eigenen Nation ist eine der Ursachen der PDS-Erfolge.|
|Hauptaufgabe der LANs ist heute das Application-Sharing, das heisst, auf der Festplatte eines zentralen Server-Rechners liegen verschiedene Anwendungen, die von allen - dazu zugelassenen - Client-Rechnern genutzt werden knnen.| |Ebenso werden die verschiedenen Daten und Dateien - gleich ob Dokumente oder Spreadsheets - auch zentral vorgehalten.| |Eine Sonderrolle nehmen hier noch die Anwendungen wie Datenbanksysteme (DBMS) ein, die - ebenfalls zentral - auf einem Server gefahren werden, deren Datenbestnde dann von den vernetzten Arbeitsstationen aus mit Client-Software (Access, Excel etc.) abgefragt werden knnen.| |Bezeichnet wird dieses System der Datenhaltung und -bearbeitung als "Client-Server-Computing" im weitesten Sinne.| |Der Schritt zu einem Intranet ist da bald nicht mehr weit.| |Nur: was ist ein Intranet?| 
|Als dieser Begriff im Sprachgebrauch aufkam, wurde er zunchst eher als Marketing-Gag denn als neues Werkzeug fr die tgliche Arbeit angesehen.|
|Meistens wird als Intranet eine Netzwerkumgebung und deren Werkzeuge bezeichnet, die hauptschlich firmenintern, das heisst, im eigenen LAN angesiedelt sind - ganz im Gegensatz zum Internet, das den gesamten Rest der Welt umfasst.|

|Hier tabellarisch die wichtigsten technischen Daten der Testgerte:|

|Rechnername	fuchur	multimed1|
	
|Domain/IP-Nummer	radiond1.de / 192.168.1.10	fh-reutlingen.de / 134.103.192.26|	

|Netzart	Intranet	FHRT-Net|	

|Prozessor	AMD 486DX100	Cyrix 486/66|	

|Arbeitsspeicher (RAM)	20 MB	32 MB|	

|Harddisks	2 x 500MB IDE	920MB / 298MB SCSI|	

|Betriebssystem	Linux (S.u.S.e 5.3)	Linux (S.u.S.e 5.3)|	

|Die Testlufe auf diesen Rechnern haben eine fr das System ausreichende Server-Performance ergeben.| |Dazu hat auch das verwendete Betriebssystem beigetragen.|

|Whrend der Programmierarbeiten am Intranet Framework sind mir etliche Inkompatibilitten zwischen den beiden im Internet am weitesten verbreiteten Browsern aufgefallen - um nicht zu sagen: sauer aufgestoen.|
|Stichwort "JavaScript"
Beide Browser knnen durch die eingebaute Sprache JavaScript (Netscape) bzw. JScript (Microsoft) etliche einfachere Programmlogik auf den Client - den Browser - verlagern.| |Der Stolperstein dabei ist dabei aber die unterschiedliche Implementation der Sprache: offensichtlich verstehen Microsoft und Netscape unter ein und dem selben Konstrukt etwa verschiedenes, so das man tatschlich das ein oder andere Mal gezwungen ist, in ein JavaScript-Programm eine Abfrage nach dem Hersteller (!) des Browsers vorzusehen.|

 |Die Software des Frameworks bergibt nmlich die zu speichernden Daten per URL-Parameter, wie zum Beispiel in der Form "http://seite.html?parameter1=1&parameter2=2" usw. Apache genauso wie seine Kollegen kann aber nur eine bestimmte Lnge dieses Strings verarbeiten; berschreitet die Lnge der URL den Grenzwert, dann gibt das Webserver-Programm eine Fehlermeldung an den Bowser zurck und fhrt die gewnscht Aktion nicht aus.| |Durch empirische Versuche habe ich die URL-Lnge auf ca. 4650 Zeichen eingrenzen knnen (was in etwa 2 DIN-A4-Seiten entsprechen drfte), dies wohlgemerkt im besten Falle.|
|Dieser berlauf drfte aber bei dem geplanten Anwendungsgebiet nicht auftreten, da die zu speichernden Textarten selten mehr als 2000 Zeichen habe, wie eine Untersuchung der bisher mit Word erstellten Texte gezeigt hat.|
|Trotzdem ist hier fr die Zukunft geplant, entweder den Sourcecode des Apache entsprechend zu verndern, oder - das wre wohl die elegante Lsung - zumindest das Editor-Feld der HTML-Seite nach Java zu portieren und den geschriebenen Text dann mittels JDBC in die Datenbank zu schreiben.|


|In der Theorie war jeder Nutzer angehalten, seine redaktionellen Texte in das entsprechende Verzeichnis, dessen Namen eine rumliche oder thematische Zuordnung erlaubte, einzusortieren.| |In der Praxis wurde das System von den Mitarbeitern des Radiosenders aus den verschiedensten Grnden (Unkenntnis des Systems, Angst vor dem Computer, usw.) nicht genutzt.| |Die Dokumente wurden nach einem Ausdruck nicht gespeichert, und wenn, dann willkrlich irgendwohin in das Verzeichnissystem mit irgendeinem Dateinamen, der nichts aussagte ("Dokument1.doc").| |Das Prinzip dabei: Der Computer ist eine Schreibmaschine mit Bildschirm ...
Das Problem ... 
Dieses chaotische System lief solange gut, bis man einen Text zu einem bestimmten Thema suchte: Er war ohne besondere Hilfen und vor allem Kenntnisse von Windows95 nicht zu finden.| |Glck hatte nur der Redakteur, der den Menupunkt "Datei suchen" kannte und vor allem auch bedienen konnte.| |Doch ist diese Art der Suche nicht sehr produktiv, und meist auch nicht sonderlich erfolgreich, da Microsoft dem Anschein nach die Suchalgorithmen sehr unscharf programmiert hat.|

|Das Intranet-Framework erlaubt auch das Drucken eines Textes.| |Dazu findet man in der Menuzeile verschiedener Fenster den Button Drucken.| |Ein Klick auf diesen ffnet ein Vorschaufenster mit dem zu druckenden Text.|
|Allerdings kann man in dieser Version des Intranet-Frameworks keine perfekte Druckausgabe wie zum Beispiel bei Word fr Windows erwarten.| |Dies ist prinzipbedingt, denn eigentlich ist die Beschreibungssprache HTML nicht fr die Erstellung druckreifer Web-Dokumente erdacht worden, sondern noch eher zur Strukturierung von Dokumenten jeglicher Art.| |Dies lsst auch schon der Name erkennen: Hypertext Markup Language.|
|Ich habe versucht, dieses Manko durch HTML-Tabellen-Programmierung etwas zu umgehen, das heit, ich habe die einzelnen auszugebenden Textteile mittels Tabelle positioniert.|

|WWWBoard wurde komplett in Perl geschrieben und stellt auf einfache Weise die Funktionalitten eines Schwarzen Brettes zur Verfgung.|
|Installation 
Die Installation der Software gestaltet sich als recht einfach: Laut der Installationsanleitung werden die entsprechenden Eintrge in das Programm vorgenommen, die Verzeichnisse fr die verschiedenen Daten auf dem Server erstellt - das wars.|
|Auch die grundstzliche Einbindung ins Framework ist kein Problem.| |Lediglich die Optik der Software muss an den Style-Guide des Intranets angepasst werden.|

|[1]	HTML Handbuch	Stefan Mnz/Wolfgang Nefzger,  Feldkirchen, Franzis-Verlag, 1997|
	
|[2]	SQL - Standardisierte Datanbanksprache vom PC bis zum Mainframe	Albrecht Achilles, Mnchen, Oldenbourg Verlag, 1989|	

|[3]	Das SQL-Lehrbuch	Rick F. Van der Lans Bonn, Addison-Wesley, 1987|	

|[4]	MySQL - Technical Reference Manual	David Axmark  TcX AB, 1998|	

|[5]	PHP3 - Manual	Stig S. Bakken PHP Documentation Group, 1997|	

|[6]	Linux - das Kompendium	Jack Tackett jun. etc. Haar, Verlag Markt & Technik, 1995	
Zeitschriften|

|[1]	Dynamische Webseiten mit PHP/FI	Tom Schwaller Linux Magazin 6/1996 S. 39, Aschheim 1996|	

|[2]	Pulverkaffee - Dynamische HTML-Seiten mit PHP/FI, mSQL und gd	Tobias Hcker iX 8/1996 S. 56, Hannover 1996|	


|[3]	Net at Work - Intranet im preiswerten Eigenbau	Dirk Brenken Ct 10/1996 S. 302, Hannover 1996|	

|[4]	Systemcocktail - Datenbanken und Web-Technik	Jrgen Diercks iX 10/1997 S. 110, Hannover 1997|	

|[5]	Heies Bemhn - Internet Explorer 4 fr Solaris	Henning Behme iX 4/1998 S. 62, Hannover 1998|	


|[6]	Ins Netz gegangen - Freie Unix-Versionen	Jrgen Kuri Ct 11/1998 S. 366, Hannover 1998|	

|[7]	Geschfte im Web	Detlef Beyer/Andr Schrter Ct 15/1998 S. 290, Hannover 1998|	

|[8]	Schirmherrschaft - Das Web: Plattform fr Firmenanwendungen	Jrgen Diercks iX 1/1999 S. 104, Hannover 1999|	

|REC-html40-19980424| 

|HTML 4.0 Specification| 

|W3C Recommendation, revised on 24-Apr-1998| 

|This version:| 

|http://www.w3.org/TR/1998/REC-html40-19980424| 

|Latest version:| 

|http://www.w3.org/TR/REC-html40| 

|Previous version:| 

|http://www.w3.org/TR/REC-html40-971218| 

|Editors:| 

|Dave Raggett <dsr@w3.org>| 

|Arnaud Le Hors <lehors@w3.org>| 

|Ian Jacobs <ij@w3.org>| 

|Available formats|

|The HTML 4.0 W3C Recommendation is also available in the following formats:| 

|A plain text file:| 

|http://www.w3.org/TR/1998/REC-html40-19980424/html40.txt (735Kb),|
 
|A gzip'ed tar file containing HTML documents:| 

|http://www.w3.org/TR/1998/REC-html40-19980424/html40.tgz (357Kb),| 

|A zip file containing HTML documents (this is a '.zip' file not an '.exe'):| 

|http://www.w3.org/TR/1998/REC-html40-19980424/html40.zip (389Kb),| 

|A gzip'ed Postscript file:| 

|http://www.w3.org/TR/1998/REC-html40-19980424/html40.ps.gz (600Kb, 367 pages),| 

|A PDF file:| 

|http://www.w3.org/TR/1998/REC-html40-19980424/html40.pdf (2.1Mb) file.| 


|Eins, zwei, drei, etc..|
|Selbst der 100. Punkt ist kein Grund fuer eine Trennung.|
|Auch nicht der 1000. Punkt, oder der 30000. Punkt.|
|Selbstverstaendlich sind normale Jahreszahlen Satzenden, wie etwa 1903.|
|Oder erst recht 1979.| |Ganz zu schweigen von 2010.|
|Insbesondere sollte es mit einem Jahr sehr gut klappen: 2000.|
|Auch andere duerfen keine Probleme machen, etwa 1900.|
|Und 2100.|
|Selbst <<Dies und das!!>> sagte er, sollte verstanden werden.|
|Abkuerzungen aus nur Vokalen sollen richtig interpretiert werden, ua. solche wie iaa. oder a. oder auch uuu..|
|Verstanden ?|
