/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.memcached.protocol;

import java.nio.ByteBuffer;
import org.couchbase.mock.memcached.protocol.BinaryCommand;
import org.couchbase.mock.memcached.protocol.ErrorCode;

public class BinaryResponse {
    private static final byte MAGIC = -127;
    private static final byte DATATYPE = 0;
    protected final ByteBuffer buffer;

    protected BinaryResponse(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    protected BinaryResponse(BinaryCommand command, ErrorCode errorCode, int extlen, int keylen, int datalen, long cas) {
        this.buffer = BinaryResponse.createAndRewind(command, errorCode, extlen, keylen, datalen, cas);
    }

    public BinaryResponse(BinaryCommand command, ErrorCode errorCode) {
        this.buffer = BinaryResponse.createAndRewind(command, errorCode, 0, 0, 0, 0L);
    }

    static ByteBuffer createAndRewind(BinaryCommand command, ErrorCode errorCode, int extlen, int keylen, int datalen, long cas) {
        ByteBuffer message = BinaryResponse.create(command, errorCode, extlen, keylen, datalen, cas);
        message.rewind();
        return message;
    }

    static ByteBuffer create(BinaryCommand command, ErrorCode errorCode, int extlen, int keylen, int datalen, long cas) {
        ByteBuffer message = ByteBuffer.allocate(24 + extlen + keylen + datalen);
        message.put((byte)-127);
        message.put(command.getComCode().cc());
        message.putShort((short)keylen);
        message.put((byte)extlen);
        message.put((byte)0);
        message.putShort(errorCode.value());
        message.putInt(datalen + keylen + extlen);
        message.putInt(command.getOpaque());
        message.putLong(cas);
        return message;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }
}

