#
# This file is part of WWW-DaysOfWonder-Memoir44
#
# This software is copyright (c) 2009 by Jerome Quelin.
#
# This is free software; you can redistribute it and/or modify it under
# the same terms as the Perl 5 programming language system itself.
#
use 5.010;
use strict;
use warnings;

package WWW::DaysOfWonder::Memoir44;
# ABSTRACT: download & manage memoir44 scenarios from official website
$WWW::DaysOfWonder::Memoir44::VERSION = '3.000';
1;

__END__

=pod

=encoding UTF-8

=head1 NAME

WWW::DaysOfWonder::Memoir44 - download & manage memoir44 scenarios from official website

=head1 VERSION

version 3.000

=head1 DESCRIPTION

Memoir'44 is a unique historical game edited by Days of Wonder
(L<http://www.daysofwonder.com>), where players command a horde of
little plastic Army men facing-off in dozens of WWII battles on an
oversize hex game board. Each battle scenario mimics the historical
terrain, troop placements and objectives of each army. Deploying forces
through a variety of Command cards, the smart commander uses the unique
skills of his units - infantry, paratroopers, tanks, artillery,
commandos and resistance fighters - to its greatest strength.

The game comes with some bundled scenarios, but there are a lot more
available online. This module allows one to list and retrieve those
officials and non-officials scenarios.

Don't use this module directly, but check the L<mem44> command for an
easy to use way of fetching the scenarios.

=head1 SEE ALSO

You can find more information on memoir44 on its website:
L<http://www.daysofwonder.com/memoir44/>

You can find more information on this module at:

=over 4

=item * Search CPAN

L<http://search.cpan.org/dist/WWW-DaysOfWonder-Memoir44>

=item * See open / report bugs

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=WWW-DaysOfWonder-Memoir44>

=item * Git repository

L<http://github.com/jquelin/www-daysofwonder-memoir44>

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/WWW-DaysOfWonder-Memoir44>

=item * CPAN Ratings

L<http://cpanratings.perl.org/d/WWW-DaysOfWonder-Memoir44>

=back

=head1 AUTHOR

Jerome Quelin

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2009 by Jerome Quelin.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
