package Net::Amazon::EMR::StepStateChangeReason;
use Moose;
with 'Net::Amazon::EMR::Role::AttrHash';
use Net::Amazon::EMR::Coercions;
use Moose::Util::TypeConstraints;

subtype 'Net::Amazon::EMR::Type::StepStateChangeReason::Code' => as 'Str' => where { m/^(?:NONE)$/x };

has 'Code' => ( is => 'ro',
                isa => 'Net::Amazon::EMR::Type::StepStateChangeReason::Code',
);

has 'Message' => ( is => 'ro', 
                   isa => 'Str' );


__PACKAGE__->meta->make_immutable();

1;

__END__

=head1 NAME

Net::Amazon::EMR::StepStateChangeReason

=head1 DESCRIPTION

Implements the StepStateChangeReason data type described at L<http://docs.amazonwebservices.com/ElasticMapReduce/latest/APIReference/API_StepStateChangeReason.html>.

=head1 AUTHOR

Jon Schutz 

L<http://notes.jschutz.net>

=head1 DOCUMENTATION, LICENSE AND COPYRIGHT

See L<Net::Amazon::EMR>.

=cut
