# Config.PL
#
# Configuration file generation for ServiceNow::Simple

# Just to tell make we are done with configuring
open CFG, '>Config';
print CFG "\n";
close CFG;

if ($ENV{PERL_MM_USE_DEFAULT} || !-t STDIN) { exit; }

# Are we being run from ActiveStates PPM
if ($0 =~ /\.PPM$/i)
{
    print "Running from PPM...\n\n";
    chdir '..';

    # find ServiceNow::Simple.pm
    foreach $dir (@INC)
    {
        if (-e $dir.'/ServiceNow/Simple.pm')
        {
            $configfile = $dir.'Simple.cfg';
            last;
        }
    }
    unless ($configfile)
    {
        print STDERR "The module ServiceNow::Simple.pm is not found. Are you realy running the script via PPM install?\n";
        <STDIN>;
        exit(1);
    }
}
else
{
    # called directly
    unless (-d 'blib/lib')
    {
        die "Do not execute this script directly, run:\n\tperl Makefile.PL
\tmake\n\tmake test\n\tmake install\n
If you are using ActivePerl under Windows use 'nmake' or 'dmake' instead of 'make'.";
    }
}

if (($configfile && -f $configfile) || -f 'blib/lib/ServiceNow/Simple.cfg') { exit; }

print "\n================ Set the defaults for module ServiceNow::Simple ================\n";
print "\nSpecify defaults for ServiceNow::Simple? (y/N) ";
$res = <STDIN>;
exit unless $res =~ /^y$/i;

if (! $configfile)
{
    print "\n\t... will be saved to .../lib/ServiceNow/Simple.cfg\n";
    $configfile = 'blib/lib/ServiceNow/Simple.cfg';
}
else
{
    print "\n\t... will be saved to $configfile\n";
}

#exit if -f $configfile;

# Gather the defaults
print "\nDefault user to use for API: ";
my $user = <STDIN>;
$user =~ s/^\s+//;
$user =~ s/\s+$//;

print "Password for user '$user': ";
my $password = <STDIN>;
$password =~ s/^\s+//;
$password =~ s/\s+$//;

print "\nIf you are operating behind a firewall, you may need\n";
print "to define the https proxy, a typical https proxy setting could be\n";
print "  http://myproxy.mycompany.com/\n";
print "Either enter your proxy setting or just press ENTER for none: ";
my $proxy = <STDIN>;
$proxy =~ s/^\s+//;
$proxy =~ s/\s+$//;

print "\nSaving config file, using the following:\n";

open $fh, '>', $configfile || die "failed to open $configfile: $!";
print $fh "# Config file for ServiceNow::Simple\n# generated by Config.PL (".scalar(localtime).")\n# This file MUST be valid perl (as it is 'required')\n# Note user and password are obfuscated.\n\n";
print $fh q{%config = (} . "\n";

# Doing simple obfuscation of user and password
my $k = '5Jv@sI9^bl@D*j5H3@:7g4H[2]d%Ks314aNuGeX;';
my $x = substr($k, 0, length($user));
my $u = $user ^ $x;
my $up = unpack('H*', $u);
print $fh "\tuser     => '$up',\n";
print     "\tuser     => '$user' (obfuscated),\n";

$x = substr($k, 0, length($password));
$u = $password ^ $x;
$up = unpack('H*', $u);
print $fh "\tpassword => '$up',\n";
print     "\tpassword => '$password' (obfuscated),\n";

print $fh "\tproxy    => '$proxy',\n";
print     "\tproxy    => '$proxy',\n";

print $fh ");\n1;\n#--< End of File >--#\n";
close $fh;
print "\nFinished configuration\n";


#####################################################################
# DO NOT REMOVE THE FOLLOWING LINE, IT IS NEEDED TO LOAD THIS LIBRARY
1;

#---< End of File >---#
