use strict;
use warnings;
use ExtUtils::MakeMaker;

WriteMakefile(
    NAME          => 'ETLp',
    AUTHOR        => q{Dan Horne <dan.horne at redbone.co.nz>},
    VERSION_FROM  => 'lib/ETLp.pm',
    ABSTRACT_FROM => 'lib/ETLp.pm',
    ($ExtUtils::MakeMaker::VERSION >= 6.3002
        ? ('LICENSE' => 'perl')
        : ()),
    PL_FILES  => {},
    EXE_FILES => ['script/etlp'],
    PREREQ_PM => {
        'Test::More'                              => 0,
        'Moose'                                   => '0.83',
        'Config::General'                         => '2.43',
        'DBI'                                     => 0,
        'DBD::SQLite'                             => 0,
        'Try::Tiny'                               => 0,
        'Modern::Perl'                            => 0,
        'MooseX::Declare'                         => '0.33',
        'MooseX::Singleton'                       => 0,
        'Cwd'                                     => 0,
        'DBD::Mock'                               => 0,
        'Module::Pluggable'                       => 0,
        'UNIVERSAL::require'                      => 0,
        'MooseX::Types::DateTime'                 => 0,
        'DBIx::VersionedDDL'                      => '0.16',
	'Math::Base36'                            => '0.07',
        'Test::Class'                             => 0,
        'DBIx::Class'                             => '0.08121',
        'Time::Piece'                             => 0,
        'Text::CSV'                               => 0,
        'Text::CSV_XS'                            => 0,
        'File::Slurp'                             => 0,
        'Convert::NLS_DATE_FORMAT'                => 0,
        'File::chdir'                             => 0,
        'File::Copy'                              => 0,
        'File::Basename'                          => 0,
        'File::LocalizeNewlines'                  => '1.12',
        'IPC::Cmd'                                => 0,
        'Mail::Sendmail'                          => 0,
        'File::Copy::Recursive'                   => 0,
        'Exception::Class'                        => 0,
        'Parallel::SubFork'                       => 0,
        'CGI::Session::Driver::oracle'            => 0,
        'CGI::Session'                            => 0,
        'CGI::Application'                        => 0,
        'CGI::Application::Plugin::TT'            => 0,
        'CGI::Application::Plugin::ParsePath'     => 0,
        'CGI::Application::Plugin::HTMLPrototype' => 0,
        'CGI::Application::Plugin::ValidateRM'    => 0,
        'CGI::Application::Plugin::Session'       => 0,
        'CGI::Application::Plugin::Forward'       => 0,
        'CGI::Application::Plugin::Redirect'      => 0,
	'CGI::Application::Plugin::Config::General' => 0,
        'Text::Wrapper'                           => 0,
        'Crypt::PasswdMD5'                        => 0,
        'Data::Page::Navigation'                  => 0,
        'Log::Log4perl'                           => 0,
        'Log::Dispatch::FileRotate'               => 0,
        'DateTime::Format::SQLite'                => 0,
        'autodie'                                 => 0,
        'File::Path'                              => 0,
    },

    dist  => {COMPRESS => 'gzip -9f', SUFFIX => 'gz',},
    clean => {FILES    => 'ETLp-*'},
);
